/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.internal.artifacts.transform.TransformationStep;

public class TransformationChain {
    private final TransformationChain init;
    private final TransformationStep last;

    public TransformationChain(@Nullable TransformationChain init, TransformationStep last) {
        this.init = init;
        this.last = last;
    }

    @Nullable
    public TransformationChain getInit() {
        return this.init;
    }

    public TransformationStep getLast() {
        return this.last;
    }

    public boolean requiresDependencies() {
        return this.init != null && this.init.requiresDependencies() || this.last.requiresDependencies();
    }

    public String getDisplayName() {
        String lastDisplayName = this.last.getDisplayName();
        return this.init == null ? lastDisplayName : this.init.getDisplayName() + " -> " + lastDisplayName;
    }

    public void visitTransformationSteps(Action<? super TransformationStep> action) {
        if (this.init != null) {
            this.init.visitTransformationSteps(action);
        }
        action.execute(this.last);
    }
}

