/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.result;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.internal.artifacts.result.ResolvedComponentResultInternal;
import org.gradle.internal.impldep.com.google.common.collect.ArrayListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;

public class DefaultResolvedComponentResult
implements ResolvedComponentResultInternal {
    private final ModuleVersionIdentifier moduleVersion;
    private final Set<DependencyResult> dependencies = new LinkedHashSet<DependencyResult>();
    private final Set<ResolvedDependencyResult> dependents = new LinkedHashSet<ResolvedDependencyResult>();
    private final ComponentSelectionReason selectionReason;
    private final ComponentIdentifier componentId;
    private final List<ResolvedVariantResult> selectedVariants;
    private final List<ResolvedVariantResult> allVariants;
    private final String repositoryId;
    private final Multimap<ResolvedVariantResult, DependencyResult> variantDependencies = ArrayListMultimap.create();

    public DefaultResolvedComponentResult(ModuleVersionIdentifier moduleVersion, ComponentSelectionReason selectionReason, ComponentIdentifier componentId, List<ResolvedVariantResult> selectedVariants, List<ResolvedVariantResult> allVariants, String repositoryId) {
        this.moduleVersion = moduleVersion;
        this.selectionReason = selectionReason;
        this.componentId = componentId;
        this.selectedVariants = selectedVariants;
        this.allVariants = allVariants;
        this.repositoryId = repositoryId;
    }

    @Override
    public ComponentIdentifier getId() {
        return this.componentId;
    }

    @Override
    @Deprecated
    public String getRepositoryName() {
        return this.repositoryId;
    }

    @Override
    @Nullable
    public String getRepositoryId() {
        return this.repositoryId;
    }

    public Set<DependencyResult> getDependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    public Set<ResolvedDependencyResult> getDependents() {
        return Collections.unmodifiableSet(this.dependents);
    }

    public DefaultResolvedComponentResult addDependency(DependencyResult dependency) {
        this.dependencies.add(dependency);
        return this;
    }

    public DefaultResolvedComponentResult addDependent(ResolvedDependencyResult dependent) {
        this.dependents.add(dependent);
        return this;
    }

    @Override
    public ComponentSelectionReason getSelectionReason() {
        return this.selectionReason;
    }

    @Override
    @Nullable
    public ModuleVersionIdentifier getModuleVersion() {
        return this.moduleVersion;
    }

    public String toString() {
        return this.getId().getDisplayName();
    }

    @Override
    public List<ResolvedVariantResult> getVariants() {
        return this.selectedVariants;
    }

    @Override
    public List<ResolvedVariantResult> getAllVariants() {
        return this.allVariants;
    }

    @Override
    public List<DependencyResult> getDependenciesForVariant(ResolvedVariantResult variant) {
        if (!this.selectedVariants.contains(variant)) {
            this.reportInvalidVariant(variant);
        }
        return ImmutableList.copyOf((Collection)this.variantDependencies.get((Object)variant));
    }

    private void reportInvalidVariant(ResolvedVariantResult variant) {
        Optional<ResolvedVariantResult> sameName = this.selectedVariants.stream().filter(v -> v.getDisplayName().equals(variant.getDisplayName())).findFirst();
        String moreInfo = sameName.isPresent() ? "A variant with the same name exists but is not the same instance." : "There's no resolved variant with the same name.";
        throw new InvalidUserCodeException("Variant '" + variant.getDisplayName() + "' doesn't belong to resolved component '" + this + "'. " + moreInfo + " Most likely you are using a variant from another component to get the dependencies of this component.");
    }

    public void associateDependencyToVariant(DependencyResult dependencyResult, ResolvedVariantResult fromVariant) {
        this.variantDependencies.put((Object)fromVariant, (Object)dependencyResult);
    }

    public static void eachElement(ResolvedComponentResult node, Action<? super ResolvedComponentResult> moduleAction, Action<? super DependencyResult> dependencyAction, Set<ResolvedComponentResult> visited) {
        if (!visited.add(node)) {
            return;
        }
        moduleAction.execute(node);
        for (DependencyResult dependencyResult : node.getDependencies()) {
            dependencyAction.execute(dependencyResult);
            if (!(dependencyResult instanceof ResolvedDependencyResult)) continue;
            DefaultResolvedComponentResult.eachElement(((ResolvedDependencyResult)dependencyResult).getSelected(), moduleAction, dependencyAction, visited);
        }
    }
}

