/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import java.util.Map;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.AbstractModuleMetadataCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleComponentAtRepositoryKey;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataCacheEntry;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.util.internal.BuildCommencedTimeProvider;

public class InMemoryModuleMetadataCache
extends AbstractModuleMetadataCache {
    private final Map<ModuleComponentAtRepositoryKey, ModuleMetadataCache.CachedMetadata> inMemoryCache = Maps.newConcurrentMap();
    private final AbstractModuleMetadataCache delegate;

    public InMemoryModuleMetadataCache(BuildCommencedTimeProvider timeProvider) {
        super(timeProvider);
        this.delegate = null;
    }

    public InMemoryModuleMetadataCache(BuildCommencedTimeProvider timeProvider, AbstractModuleMetadataCache delegate) {
        super(timeProvider);
        this.delegate = delegate;
    }

    @Override
    protected ModuleMetadataCache.CachedMetadata get(ModuleComponentAtRepositoryKey key) {
        ModuleMetadataCache.CachedMetadata metadata = this.inMemoryCache.get(key);
        if (metadata == null && this.delegate != null && (metadata = this.delegate.get(key)) != null) {
            this.inMemoryCache.put(key, metadata);
        }
        return metadata;
    }

    @Override
    protected ModuleMetadataCache.CachedMetadata store(ModuleComponentAtRepositoryKey key, ModuleMetadataCacheEntry entry, ModuleMetadataCache.CachedMetadata cachedMetaData) {
        ModuleMetadataCache.CachedMetadata dehydrated = cachedMetaData.dehydrate();
        this.inMemoryCache.put(key, dehydrated);
        if (this.delegate != null) {
            this.delegate.store(key, entry, dehydrated);
        }
        return dehydrated;
    }
}

