/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentMetaDataResolveState;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainModuleResolution;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.VersionedComponentChooser;
import org.gradle.api.internal.artifacts.repositories.resolver.MetadataFetchingCost;
import org.gradle.internal.component.external.model.ModuleComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.ResolveExceptionAnalyzer;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.result.BuildableComponentResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryChainComponentMetaDataResolver
implements ComponentMetaDataResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryChainComponentMetaDataResolver.class);
    private final List<ModuleComponentRepository<ModuleComponentGraphResolveState>> repositories = new ArrayList<ModuleComponentRepository<ModuleComponentGraphResolveState>>();
    private final List<String> repositoryNames = new ArrayList<String>();
    private final VersionedComponentChooser versionedComponentChooser;

    public RepositoryChainComponentMetaDataResolver(VersionedComponentChooser componentChooser) {
        this.versionedComponentChooser = componentChooser;
    }

    public void add(ModuleComponentRepository<ModuleComponentGraphResolveState> repository) {
        this.repositories.add(repository);
        this.repositoryNames.add(repository.getName());
    }

    @Override
    public void resolve(ComponentIdentifier identifier, ComponentOverrideMetadata componentOverrideMetadata, BuildableComponentResolveResult result2) {
        if (!(identifier instanceof ModuleComponentIdentifier)) {
            throw new UnsupportedOperationException("Can resolve meta-data for module components only.");
        }
        this.resolveModule((ModuleComponentIdentifier)identifier, componentOverrideMetadata, result2);
    }

    @Override
    public boolean isFetchingMetadataCheap(ComponentIdentifier identifier) {
        if (identifier instanceof ModuleComponentIdentifier) {
            for (ModuleComponentRepository<ModuleComponentGraphResolveState> repository : this.repositories) {
                ModuleComponentRepositoryAccess<ModuleComponentGraphResolveState> localAccess = repository.getLocalAccess();
                MetadataFetchingCost fetchingCost = localAccess.estimateMetadataFetchingCost((ModuleComponentIdentifier)identifier);
                if (fetchingCost.isFast()) {
                    return true;
                }
                if (!fetchingCost.isExpensive()) continue;
                return false;
            }
        }
        return true;
    }

    private void resolveModule(ModuleComponentIdentifier identifier, ComponentOverrideMetadata componentOverrideMetadata, BuildableComponentResolveResult result2) {
        LOGGER.debug("Attempting to resolve component for {} using repositories {}", (Object)identifier, this.repositoryNames);
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        ArrayList<ComponentMetaDataResolveState> resolveStates = new ArrayList<ComponentMetaDataResolveState>();
        for (ModuleComponentRepository<ModuleComponentGraphResolveState> repository : this.repositories) {
            resolveStates.add(new ComponentMetaDataResolveState(identifier, componentOverrideMetadata, repository, this.versionedComponentChooser));
        }
        RepositoryChainModuleResolution latestResolved = this.findBestMatch(resolveStates, errors);
        if (latestResolved != null) {
            LOGGER.debug("Using {} from {}", (Object)latestResolved.component.getId(), latestResolved.repository);
            for (Throwable error : errors) {
                LOGGER.debug("Discarding resolve failure.", error);
            }
            result2.resolved(latestResolved.component);
            return;
        }
        if (!errors.isEmpty()) {
            result2.failed(new ModuleVersionResolveException(identifier, errors));
        } else {
            for (ComponentMetaDataResolveState resolveState : resolveStates) {
                resolveState.applyTo(result2);
            }
            result2.notFound(identifier);
        }
    }

    @Nullable
    private RepositoryChainModuleResolution findBestMatch(List<ComponentMetaDataResolveState> resolveStates, Collection<Throwable> failures) {
        LinkedList<ComponentMetaDataResolveState> queue = new LinkedList<ComponentMetaDataResolveState>(resolveStates);
        LinkedList<ComponentMetaDataResolveState> missing = new LinkedList<ComponentMetaDataResolveState>();
        RepositoryChainModuleResolution best = this.findBestMatch(queue, failures, missing);
        if (ResolveExceptionAnalyzer.hasCriticalFailure(failures)) {
            return null;
        }
        if (best != null) {
            return best;
        }
        queue.addAll(missing);
        missing.clear();
        return this.findBestMatch(queue, failures, missing);
    }

    @Nullable
    private RepositoryChainModuleResolution findBestMatch(LinkedList<ComponentMetaDataResolveState> queue, Collection<Throwable> failures, Collection<ComponentMetaDataResolveState> missing) {
        RepositoryChainModuleResolution best = null;
        block5: while (!queue.isEmpty()) {
            ComponentMetaDataResolveState request = queue.removeFirst();
            BuildableModuleComponentMetaDataResolveResult<ModuleComponentGraphResolveState> metaDataResolveResult = request.resolve();
            switch (metaDataResolveResult.getState()) {
                case Failed: {
                    failures.add(metaDataResolveResult.getFailure());
                    if (!ResolveExceptionAnalyzer.isCriticalFailure(metaDataResolveResult.getFailure())) continue block5;
                    queue.clear();
                    continue block5;
                }
                case Missing: {
                    if (!request.canMakeFurtherAttempts()) continue block5;
                    missing.add(request);
                    continue block5;
                }
                case Resolved: {
                    RepositoryChainModuleResolution moduleResolution = new RepositoryChainModuleResolution(request.repository, metaDataResolveResult.getMetaData());
                    if (!metaDataResolveResult.getMetaData().getMetadata().isMissing()) {
                        return moduleResolution;
                    }
                    best = best != null ? best : moduleResolution;
                    continue block5;
                }
            }
            throw new IllegalStateException("Unexpected state for resolution: " + (Object)((Object)metaDataResolveResult.getState()));
        }
        return best;
    }
}

