/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.Arrays;
import java.util.List;
import org.gradle.api.internal.ClassPathProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactoryInternal;
import org.gradle.api.internal.classpath.Module;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.classpath.PluginModuleRegistry;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public class DependencyClassPathProvider
implements ClassPathProvider {
    private static final List<String> MODULES = Arrays.asList("gradle-worker-processes", "gradle-launcher", "gradle-workers", "gradle-dependency-management", "gradle-plugin-use", "gradle-tooling-api-builders", "gradle-configuration-cache");
    private final ModuleRegistry moduleRegistry;
    private final PluginModuleRegistry pluginModuleRegistry;
    private ClassPath gradleApi;

    public DependencyClassPathProvider(ModuleRegistry moduleRegistry, PluginModuleRegistry pluginModuleRegistry) {
        this.moduleRegistry = moduleRegistry;
        this.pluginModuleRegistry = pluginModuleRegistry;
    }

    @Override
    public ClassPath findClassPath(String name) {
        if (name.equals(DependencyFactoryInternal.ClassPathNotation.GRADLE_API.name())) {
            return this.gradleApi();
        }
        if (name.equals(DependencyFactoryInternal.ClassPathNotation.GRADLE_TEST_KIT.name())) {
            return this.gradleTestKit();
        }
        if (name.equals(DependencyFactoryInternal.ClassPathNotation.LOCAL_GROOVY.name())) {
            return this.localGroovy();
        }
        if (name.equals(DependencyFactoryInternal.ClassPathNotation.GRADLE_KOTLIN_DSL.name())) {
            return this.gradleKotlinDsl();
        }
        return null;
    }

    private ClassPath gradleApi() {
        if (this.gradleApi == null) {
            this.gradleApi = this.initGradleApi();
        }
        return this.gradleApi;
    }

    private ClassPath initGradleApi() {
        ClassPath classpath = ClassPath.EMPTY;
        for (String moduleName : MODULES) {
            classpath = classpath.plus(this.moduleRegistry.getModule(moduleName).getAllRequiredModulesClasspath());
        }
        for (Module pluginModule : this.pluginModuleRegistry.getApiModules()) {
            classpath = classpath.plus(pluginModule.getClasspath());
        }
        return classpath.removeIf(f -> f.getName().startsWith("kotlin-sam-with-receiver-compiler-plugin"));
    }

    private ClassPath gradleTestKit() {
        return this.moduleRegistry.getModule("gradle-test-kit").getClasspath();
    }

    private ClassPath localGroovy() {
        ImmutableSet groovyModules = ImmutableSet.of((Object)"groovy-ant", (Object)"groovy-astbuilder", (Object)"groovy-console", (Object)"groovy-datetime", (Object)"groovy-dateutil", (Object)"groovy-groovydoc", (Object[])new String[]{"groovy-json", "groovy-nio", "groovy-sql", "groovy-templates", "groovy-test", "groovy-xml", "javaparser-core"});
        ClassPath groovy = this.moduleRegistry.getExternalModule("groovy").getClasspath();
        for (String groovyModule : groovyModules) {
            groovy = groovy.plus(this.moduleRegistry.getExternalModule(groovyModule).getClasspath());
        }
        return groovy;
    }

    private ClassPath gradleKotlinDsl() {
        return this.moduleRegistry.getModule("gradle-kotlin-dsl").getAllRequiredModulesClasspath();
    }
}

