/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrModuleToJsTransformerKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsGenerationGranularity;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0004J\u0016\u0010\u0010\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\bJ\u0014\u0010\u0013\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\f\u001a\u00020\bH\u0002J\f\u0010\u0014\u001a\u00020\u0005*\u00020\u0004H\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\u0005*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/ModuleFragmentToExternalName;", "", "jsOutputNamesMapping", "", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "", "(Ljava/util/Map;)V", "stableFileName", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getStableFileName", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;)Ljava/lang/String;", "getExternalNameFor", "file", "granularity", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsGenerationGranularity;", "module", "getExternalNameForExporterFile", "getSafeNameExporterFor", "getSafeNameFor", "getExternalModuleNameForPerFile", "getJsOutputName", "backend.js"})
@SourceDebugExtension(value={"SMAP\nModuleFragmentToExternalName.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleFragmentToExternalName.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/ModuleFragmentToExternalName\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1#2:52\n*E\n"})
public final class ModuleFragmentToExternalName {
    @NotNull
    private final Map<IrModuleFragment, String> jsOutputNamesMapping;

    public ModuleFragmentToExternalName(@NotNull Map<IrModuleFragment, String> jsOutputNamesMapping) {
        Intrinsics.checkNotNullParameter(jsOutputNamesMapping, (String)"jsOutputNamesMapping");
        this.jsOutputNamesMapping = jsOutputNamesMapping;
    }

    @NotNull
    public final String getExternalNameFor(@NotNull IrFile file2, @NotNull JsGenerationGranularity granularity) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)granularity), (String)"granularity");
        boolean bl2 = bl = granularity == JsGenerationGranularity.PER_FILE;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "This method should be used only for PER_FILE granularity";
            throw new AssertionError((Object)string2);
        }
        return this.getExternalModuleNameForPerFile(this.getJsOutputName(file2.getModule()), file2);
    }

    @NotNull
    public final String getExternalNameForExporterFile(@NotNull IrFile file2, @NotNull JsGenerationGranularity granularity) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)granularity), (String)"granularity");
        return this.getExternalNameFor(file2, granularity) + ".export";
    }

    @NotNull
    public final String getSafeNameFor(@NotNull IrFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return IrModuleToJsTransformerKt.getSafeName(file2.getModule()) + '/' + this.getStableFileName(file2);
    }

    @NotNull
    public final String getSafeNameExporterFor(@NotNull IrFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.getSafeNameFor(file2) + ".export";
    }

    @NotNull
    public final String getExternalNameFor(@NotNull IrModuleFragment module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return this.getJsOutputName(module2);
    }

    private final String getJsOutputName(IrModuleFragment $this$getJsOutputName) {
        String string2 = this.jsOutputNamesMapping.get($this$getJsOutputName);
        if (string2 == null) {
            string2 = NameTablesKt.sanitizeName$default(IrModuleToJsTransformerKt.getSafeName($this$getJsOutputName), false, 2, null);
        }
        return string2;
    }

    private final String getExternalModuleNameForPerFile(String $this$getExternalModuleNameForPerFile, IrFile file2) {
        return $this$getExternalModuleNameForPerFile + '/' + this.getStableFileName(file2);
    }

    private final String getStableFileName(IrFile $this$stableFileName) {
        String string2 = $this$stableFileName.getPackageFqName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        String prefix = StringsKt.replace$default((String)string2, (char)'.', (char)'/', (boolean)false, (int)4, null);
        String string3 = AnnotationUtilsKt.getJsName((IrAnnotationContainer)$this$stableFileName);
        if (string3 == null) {
            string3 = StringsKt.substringBefore$default((String)IrDeclarationsKt.getName((IrFile)$this$stableFileName), (String)".kt", null, (int)2, null);
        }
        String fileName = string3;
        return prefix + (((CharSequence)prefix).length() > 0 ? "/" : "") + fileName;
    }
}

