/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsSuperRef;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0005\u001a\u0012\u0010\u0006\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\n\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005\u001a\u0012\u0010\r\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0010\u0010\u000e\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u000fH\u0002\u001a\u0014\u0010\u0010\u001a\u00020\u0001*\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\u0011"}, d2={"isInterface", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "(Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;)Z", "escapedIfNeed", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "isAccessorOfOverriddenStableProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "isSimpleSuperCall", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "container", "overriddenStableProperty", "overridesExternal", "Lorg/jetbrains/kotlin/ir/declarations/IrOverridableDeclaration;", "shouldExportAccessor", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsClassGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsClassGenerator.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsClassGeneratorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,529:1\n1#2:530\n1747#3,3:531\n*S KotlinDebug\n*F\n+ 1 JsClassGenerator.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsClassGeneratorKt\n*L\n513#1:531,3\n*E\n"})
public final class JsClassGeneratorKt {
    @NotNull
    public static final JsFunction escapedIfNeed(@NotNull JsFunction $this$escapedIfNeed) {
        Intrinsics.checkNotNullParameter((Object)$this$escapedIfNeed, (String)"<this>");
        Object object = $this$escapedIfNeed.getName();
        boolean bl = object != null && (object = ((JsName)object).getIdent()) != null ? !IdentifierPolicyKt.isValidES5Identifier((String)object) : false;
        if (bl) {
            $this$escapedIfNeed.setName(new JsName('\'' + $this$escapedIfNeed.getName().getIdent() + '\'', $this$escapedIfNeed.getName().isTemporary()));
        }
        return $this$escapedIfNeed;
    }

    public static final boolean isSimpleSuperCall(@NotNull JsStatement $this$isSimpleSuperCall, @NotNull JsFunction container) {
        block8: {
            Intrinsics.checkNotNullParameter((Object)$this$isSimpleSuperCall, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            if (!($this$isSimpleSuperCall instanceof JsExpressionStatement)) {
                return false;
            }
            JsExpression jsExpression = ((JsExpressionStatement)$this$isSimpleSuperCall).getExpression();
            JsInvocation jsInvocation = jsExpression instanceof JsInvocation ? (JsInvocation)jsExpression : null;
            if (jsInvocation == null) {
                return false;
            }
            JsInvocation invocation = jsInvocation;
            if (!(invocation.getQualifier() instanceof JsSuperRef) || container.getParameters().size() != invocation.getArguments().size()) {
                return false;
            }
            int i = 0;
            List<JsParameter> list2 = container.getParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getParameters(...)");
            int n = CollectionsKt.getLastIndex(list2);
            if (i > n) break block8;
            while (true) {
                JsNameRef jsNameRef;
                JsParameter declaredParameter;
                block10: {
                    block9: {
                        JsNameRef jsNameRef2;
                        declaredParameter = container.getParameters().get(i);
                        JsExpression jsExpression2 = invocation.getArguments().get(i);
                        jsNameRef = jsExpression2 instanceof JsNameRef ? (JsNameRef)jsExpression2 : null;
                        if (jsNameRef == null) break block9;
                        JsNameRef it = jsNameRef2 = jsNameRef;
                        boolean bl = false;
                        jsNameRef = it.getQualifier() == null ? jsNameRef2 : null;
                        if (jsNameRef != null) break block10;
                    }
                    return false;
                }
                JsNameRef providedParameter = jsNameRef;
                if (!Intrinsics.areEqual((Object)declaredParameter.getName(), (Object)providedParameter.getName())) {
                    return false;
                }
                if (i == n) break;
                ++i;
            }
        }
        return true;
    }

    public static final boolean shouldExportAccessor(@Nullable IrSimpleFunction $this$shouldExportAccessor, @NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if ($this$shouldExportAccessor == null) {
            return false;
        }
        if (ExportModelGeneratorKt.isExported((IrDeclaration)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)$this$shouldExportAccessor)), context)) {
            return true;
        }
        return JsClassGeneratorKt.isAccessorOfOverriddenStableProperty($this$shouldExportAccessor, context);
    }

    public static final boolean overriddenStableProperty(@NotNull IrSimpleFunction $this$overriddenStableProperty, @NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$overriddenStableProperty, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrPropertySymbol irPropertySymbol = $this$overriddenStableProperty.getCorrespondingPropertySymbol();
        Intrinsics.checkNotNull((Object)irPropertySymbol);
        IrProperty property = (IrProperty)irPropertySymbol.getOwner();
        if (ExportModelGeneratorKt.isOverriddenExported((IrOverridableDeclaration)property, context)) {
            return ExportModelGeneratorKt.isOverriddenExported((IrOverridableDeclaration)$this$overriddenStableProperty, context);
        }
        return JsClassGeneratorKt.overridesExternal((IrOverridableDeclaration)$this$overriddenStableProperty) || AnnotationUtilsKt.getJsName((IrAnnotationContainer)property) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isAccessorOfOverriddenStableProperty(@NotNull IrSimpleFunction $this$isAccessorOfOverriddenStableProperty, @NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$isAccessorOfOverriddenStableProperty, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (JsClassGeneratorKt.overriddenStableProperty($this$isAccessorOfOverriddenStableProperty, context)) return true;
        IrPropertySymbol irPropertySymbol = $this$isAccessorOfOverriddenStableProperty.getCorrespondingPropertySymbol();
        Intrinsics.checkNotNull((Object)irPropertySymbol);
        if (!JsClassGeneratorKt.overridesExternal((IrOverridableDeclaration)irPropertySymbol.getOwner())) return false;
        return true;
    }

    private static final boolean overridesExternal(IrOverridableDeclaration<?> $this$overridesExternal) {
        boolean bl;
        block4: {
            if (IrUtilsKt.isEffectivelyExternal((IrDeclaration)((IrDeclaration)$this$overridesExternal))) {
                return true;
            }
            Iterable $this$any$iv = $this$overridesExternal.getOverriddenSymbols();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrSymbol it = (IrSymbol)element$iv;
                    boolean bl2 = false;
                    IrSymbolOwner irSymbolOwner = it.getOwner();
                    Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration<*>");
                    if (!JsClassGeneratorKt.overridesExternal((IrOverridableDeclaration)irSymbolOwner)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean isInterface(IrClassifierSymbol $this$isInterface) {
        IrSymbolOwner irSymbolOwner = $this$isInterface.getOwner();
        IrClass irClass = irSymbolOwner instanceof IrClass ? (IrClass)irSymbolOwner : null;
        return irClass != null ? IrUtilsKt.isInterface((IrClass)irClass) : false;
    }

    public static final /* synthetic */ boolean access$overridesExternal(IrOverridableDeclaration $receiver) {
        return JsClassGeneratorKt.overridesExternal($receiver);
    }

    public static final /* synthetic */ boolean access$isInterface(IrClassifierSymbol $receiver) {
        return JsClassGeneratorKt.isInterface($receiver);
    }
}

