/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.model.impl;

import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.maven.model.impl.MavenIdBean;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.maven.model.impl.ResourceRootConfiguration;

public class MavenModuleResourceConfiguration {
    @Tag(value="id")
    @NotNull
    public MavenIdBean id;
    @Tag(value="parentId")
    @Nullable
    public MavenIdBean parentId;
    @Tag(value="directory")
    @NotNull
    public String directory;
    @Tag(value="manifest")
    @Nullable
    public String manifest;
    @Tag(value="classpath")
    @Nullable
    public String classpath;
    @Tag(value="delimiters-pattern")
    @NotNull
    public String delimitersPattern;
    @Tag(value="model-map")
    @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false)
    public Map<String, String> modelMap = new HashMap<String, String>();
    @Tag(value="properties")
    @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false)
    public Map<String, String> properties = new HashMap<String, String>();
    @XCollection(propertyElementName="filtering-excluded-extensions", elementName="extension")
    public Set<String> filteringExclusions = CollectionFactory.createFilePathSet();
    @OptionTag
    public String escapeString = null;
    @OptionTag
    public boolean escapeWindowsPaths = true;
    @OptionTag
    public boolean overwrite;
    @OptionTag
    public String outputDirectory = null;
    @OptionTag
    public String testOutputDirectory = null;
    @XCollection(propertyElementName="resources", elementName="resource")
    public List<ResourceRootConfiguration> resources = new ArrayList<ResourceRootConfiguration>();
    @XCollection(propertyElementName="test-resources", elementName="resource")
    public List<ResourceRootConfiguration> testResources = new ArrayList<ResourceRootConfiguration>();

    public Set<String> getFilteringExcludedExtensions() {
        if (this.filteringExclusions.isEmpty()) {
            return MavenProjectConfiguration.DEFAULT_FILTERING_EXCLUDED_EXTENSIONS;
        }
        Set result = CollectionFactory.createFilePathSet();
        result.addAll(MavenProjectConfiguration.DEFAULT_FILTERING_EXCLUDED_EXTENSIONS);
        result.addAll(this.filteringExclusions);
        return Collections.unmodifiableSet(result);
    }

    public int computeConfigurationHash(boolean forTestResources) {
        int result = this.computeModuleConfigurationHash();
        List<ResourceRootConfiguration> _resources = forTestResources ? this.testResources : this.resources;
        result = 31 * result;
        for (ResourceRootConfiguration resource : _resources) {
            result += resource.computeConfigurationHash();
        }
        return result;
    }

    public int computeModuleConfigurationHash() {
        int result = this.id.hashCode();
        result = 31 * result + (this.parentId != null ? this.parentId.hashCode() : 0);
        result = 31 * result + this.directory.hashCode();
        result = 31 * result + (this.manifest != null ? this.manifest.hashCode() : 0);
        result = 31 * result + (this.classpath != null ? this.classpath.hashCode() : 0);
        result = 31 * result + this.delimitersPattern.hashCode();
        result = 31 * result + this.modelMap.hashCode();
        result = 31 * result + this.properties.hashCode();
        result = 31 * result + this.filteringExclusions.hashCode();
        result = 31 * result + (this.escapeString != null ? this.escapeString.hashCode() : 0);
        result = 31 * result + (this.outputDirectory != null ? this.outputDirectory.hashCode() : 0);
        result = 31 * result + (this.testOutputDirectory != null ? this.testOutputDirectory.hashCode() : 0);
        result = 31 * result + (this.escapeWindowsPaths ? 1 : 0);
        result = 31 * result + (this.overwrite ? 1 : 0);
        return result;
    }

    public String toString() {
        return "MavenModuleResourceConfiguration{id=" + this.id + ", parentId=" + this.parentId + ", directory='" + this.directory + "', manifest='" + this.manifest + "', classpath='" + this.classpath + "', delimitersPattern='" + this.delimitersPattern + "', modelMap=" + this.modelMap + ", properties=" + this.properties + ", filteringExclusions=" + this.filteringExclusions + ", escapeString='" + this.escapeString + "', escapeWindowsPaths=" + this.escapeWindowsPaths + ", overwrite=" + this.overwrite + ", outputDirectory='" + this.outputDirectory + "', testOutputDirectory='" + this.testOutputDirectory + "', resources=" + this.resources + ", testResources=" + this.testResources + "}";
    }
}

