/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.util;

import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.components.JBList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

public final class PluginPlatformInfo {
    private static final PluginPlatformInfo UNRESOLVED_INSTANCE = new PluginPlatformInfo(PlatformResolveStatus.UNRESOLVED, null, null);
    private final PlatformResolveStatus myPlatformResolveStatus;
    private final IdeaPlugin myMainIdeaPlugin;
    private final BuildNumber mySinceBuildNumber;

    private PluginPlatformInfo(PlatformResolveStatus platformResolveStatus, IdeaPlugin mainIdeaPlugin, BuildNumber sinceBuildNumber) {
        this.myPlatformResolveStatus = platformResolveStatus;
        this.myMainIdeaPlugin = mainIdeaPlugin;
        this.mySinceBuildNumber = sinceBuildNumber;
    }

    public PlatformResolveStatus getResolveStatus() {
        return this.myPlatformResolveStatus;
    }

    public IdeaPlugin getMainIdeaPlugin() {
        return this.myMainIdeaPlugin;
    }

    @Nullable
    public BuildNumber getSinceBuildNumber() {
        return this.mySinceBuildNumber;
    }

    public static PluginPlatformInfo forDomElement(@NotNull DomElement pluginXmlDomElement) {
        GenericAttributeValue<BuildNumber> sinceBuild;
        Module module;
        if (pluginXmlDomElement == null) {
            PluginPlatformInfo.$$$reportNull$$$0(0);
        }
        if ((module = pluginXmlDomElement.getModule()) == null) {
            return UNRESOLVED_INSTANCE;
        }
        boolean isDevkitModule = PluginModuleType.isPluginModuleOrDependency(module);
        if (!isDevkitModule) {
            return PluginPlatformInfo.forModule(module);
        }
        IdeaPlugin plugin = (IdeaPlugin)DomUtil.getParentOfType((DomElement)pluginXmlDomElement, IdeaPlugin.class, (boolean)true);
        assert (plugin != null);
        if (!plugin.hasRealPluginId()) {
            XmlFile mainPluginXml = PluginModuleType.getPluginXml(module);
            if (mainPluginXml == null) {
                return new PluginPlatformInfo(PlatformResolveStatus.DEVKIT_NO_MAIN, null, null);
            }
            plugin = DescriptorUtil.getIdeaPlugin(mainPluginXml);
            assert (plugin != null);
        }
        if (!DomUtil.hasXml(sinceBuild = plugin.getIdeaVersion().getSinceBuild()) || sinceBuild.getValue() == null) {
            return new PluginPlatformInfo(PlatformResolveStatus.DEVKIT_NO_SINCE_BUILD, plugin, null);
        }
        return new PluginPlatformInfo(PlatformResolveStatus.DEVKIT, plugin, (BuildNumber)sinceBuild.getValue());
    }

    public static PluginPlatformInfo forModule(@NotNull Module module) {
        if (module == null) {
            PluginPlatformInfo.$$$reportNull$$$0(1);
        }
        return (PluginPlatformInfo)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency((Object)PluginPlatformInfo._forModule(module), (Object)JavaLibraryModificationTracker.getInstance((Project)module.getProject())));
    }

    private static PluginPlatformInfo _forModule(@NotNull Module module) {
        String branch;
        String major;
        PsiClass markerClass;
        if (module == null) {
            PluginPlatformInfo.$$$reportNull$$$0(2);
        }
        if ((markerClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(JBList.class.getName(), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false))) == null) {
            return UNRESOLVED_INSTANCE;
        }
        OrderEntry entry = LibraryUtil.findLibraryEntry((VirtualFile)markerClass.getContainingFile().getVirtualFile(), (Project)module.getProject());
        if (!(entry instanceof LibraryOrderEntry)) {
            return UNRESOLVED_INSTANCE;
        }
        String libraryName = entry.getPresentableName();
        String version = StringUtil.substringAfterLast((String)libraryName, (String)":");
        if (StringUtil.isEmpty((String)version)) {
            return UNRESOLVED_INSTANCE;
        }
        if (Character.isUpperCase(version.charAt(0))) {
            version = StringUtil.substringAfter((String)version, (String)"-");
            assert (version != null);
        }
        if (version.contains("-")) {
            version = StringUtil.substringBefore((String)version, (String)"-");
            assert (version != null);
        }
        String string = major = version.contains(".") ? StringUtil.substringBefore((String)version, (String)".") : version;
        if (major == null) {
            return UNRESOLVED_INSTANCE;
        }
        if (major.length() == 4 && version.length() >= 6) {
            if ((version = StringUtil.replace((String)version, (String)".", (String)"").substring(2)).length() < 3) {
                return UNRESOLVED_INSTANCE;
            }
            branch = version.substring(0, 3);
        } else if (major.length() == 3) {
            branch = version;
        } else {
            return UNRESOLVED_INSTANCE;
        }
        BuildNumber number = BuildNumber.fromStringOrNull((String)branch);
        if (number == null) {
            return UNRESOLVED_INSTANCE;
        }
        return new PluginPlatformInfo(PlatformResolveStatus.GRADLE, null, number);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginXmlDomElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/util/PluginPlatformInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "forDomElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "forModule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "_forModule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum PlatformResolveStatus {
        UNRESOLVED,
        DEVKIT,
        DEVKIT_NO_MAIN,
        DEVKIT_NO_SINCE_BUILD,
        GRADLE;

    }
}

