/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.With;
import org.jetbrains.idea.devkit.dom.index.ExtensionPointClassIndex;
import org.jetbrains.idea.devkit.util.ExtensionPointCandidate;
import org.jetbrains.idea.devkit.util.PluginRelatedLocatorsUtils;

public final class ExtensionPointLocator {
    private final PsiClass myPsiClass;

    public ExtensionPointLocator(PsiClass psiClass) {
        this.myPsiClass = psiClass;
    }

    public Set<ExtensionPointCandidate> findDirectCandidates() {
        HashSet<ExtensionPointCandidate> candidates = new HashSet<ExtensionPointCandidate>();
        ExtensionPointLocator.findExtensionPointCandidates(this.myPsiClass, candidates);
        return candidates;
    }

    public Set<ExtensionPointCandidate> findSuperCandidates() {
        HashSet<ExtensionPointCandidate> candidates = new HashSet<ExtensionPointCandidate>();
        ExtensionPointLocator.findExtensionPointCandidatesInHierarchy(this.myPsiClass, candidates, new HashSet());
        return candidates;
    }

    private static void findExtensionPointCandidatesInHierarchy(PsiClass psiClass, Set<? super ExtensionPointCandidate> candidates, HashSet<? super PsiClass> processed) {
        for (PsiClass superClass : psiClass.getSupers()) {
            if (!processed.add((PsiClass)superClass) || "java.lang.Object".equals(superClass.getQualifiedName())) continue;
            ExtensionPointLocator.findExtensionPointCandidates(superClass, candidates);
            ExtensionPointLocator.findExtensionPointCandidatesInHierarchy(superClass, candidates, processed);
        }
    }

    private static void findExtensionPointCandidates(PsiClass psiClass, Set<? super ExtensionPointCandidate> candidates) {
        Project project = psiClass.getProject();
        SmartPointerManager instance = SmartPointerManager.getInstance((Project)project);
        List<ExtensionPoint> extensionPoints2 = ExtensionPointClassIndex.getExtensionPointsByClass(project, psiClass, PluginRelatedLocatorsUtils.getCandidatesScope(project));
        for (ExtensionPoint point : extensionPoints2) {
            SmartPsiElementPointer pointer = instance.createSmartPsiElementPointer((PsiElement)point.getXmlTag());
            String effectiveQualifiedName = point.getEffectiveQualifiedName();
            if (DomUtil.hasXml(point.getInterface())) {
                candidates.add(new ExtensionPointCandidate((SmartPsiElementPointer<XmlTag>)pointer, effectiveQualifiedName));
                continue;
            }
            String tagName = null;
            String attributeName = null;
            for (With element : point.getWithElements()) {
                if (!psiClass.equals(element.getImplements().getValue())) continue;
                tagName = element.getTag().getStringValue();
                attributeName = element.getAttribute().getStringValue();
                break;
            }
            ExtensionPointCandidate candidate = new ExtensionPointCandidate((SmartPsiElementPointer<XmlTag>)pointer, effectiveQualifiedName, attributeName, tagName, point.getBeanClass().getStringValue());
            candidates.add(candidate);
        }
    }
}

