/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.util.Collections;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.util.ExtensionByExtensionPointLocator;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocator;
import org.jetbrains.idea.devkit.util.PluginRelatedLocatorsUtils;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0006\u001a,\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00062\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u000e\u001a\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012\u001a<\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0016\u001a\u00020\u00172\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00170\u0019H\u0000\u001a8\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u001a\b\u0004\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00170\u0019H\u0080\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001d\u00b2\u0006\u0012\u0010\u001e\u001a\n  *\u0004\u0018\u00010\u001f0\u001fX\u008a\u0084\u0002"}, d2={"findExtensionsByClassName", "", "Lorg/jetbrains/idea/devkit/util/ExtensionCandidate;", "project", "Lcom/intellij/openapi/project/Project;", "className", "", "locateExtensionsByExtensionPoint", "extensionPoint", "Lorg/jetbrains/idea/devkit/dom/ExtensionPoint;", "locateExtensionsByExtensionPointAndId", "Lorg/jetbrains/idea/devkit/util/ExtensionLocator;", "extensionId", "extensionIdFunction", "Lkotlin/Function1;", "Lorg/jetbrains/idea/devkit/dom/Extension;", "locateExtensionsByPsiClass", "psiClass", "Lcom/intellij/psi/PsiClass;", "processExtensionDeclarations", "", "name", "strictMatch", "", "callback", "Lkotlin/Function2;", "Lcom/intellij/psi/xml/XmlTag;", "processExtensionsByClassName", "processor", "intellij.devkit.core", "smartPointerManager", "Lcom/intellij/psi/SmartPointerManager;", "kotlin.jvm.PlatformType"})
@SourceDebugExtension(value={"SMAP\nExtensionLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionLocator.kt\norg/jetbrains/idea/devkit/util/ExtensionLocatorKt\n*L\n1#1,131:1\n81#1,4:132\n*S KotlinDebug\n*F\n+ 1 ExtensionLocator.kt\norg/jetbrains/idea/devkit/util/ExtensionLocatorKt\n*L\n71#1:132,4\n*E\n"})
public final class ExtensionLocatorKt {
    @NotNull
    public static final List<ExtensionCandidate> locateExtensionsByPsiClass(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Project project = psiClass.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiClass.project");
        String string = ClassUtil.getJVMClassName((PsiClass)psiClass);
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        return ExtensionLocatorKt.findExtensionsByClassName(project, string);
    }

    @NotNull
    public static final List<ExtensionCandidate> locateExtensionsByExtensionPoint(@NotNull ExtensionPoint extensionPoint) {
        Intrinsics.checkNotNullParameter((Object)extensionPoint, (String)"extensionPoint");
        Project project = extensionPoint.getXmlTag().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"extensionPoint.xmlTag.project");
        return new ExtensionByExtensionPointLocator(project, extensionPoint, null, null, 8, null).findCandidates();
    }

    @NotNull
    public static final ExtensionLocator locateExtensionsByExtensionPointAndId(@NotNull ExtensionPoint extensionPoint, @NotNull String extensionId) {
        Intrinsics.checkNotNullParameter((Object)extensionPoint, (String)"extensionPoint");
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        Project project = extensionPoint.getXmlTag().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"extensionPoint.xmlTag.project");
        return new ExtensionByExtensionPointLocator(project, extensionPoint, extensionId, null, 8, null);
    }

    @NotNull
    public static final ExtensionLocator locateExtensionsByExtensionPointAndId(@NotNull ExtensionPoint extensionPoint, @NotNull String extensionId, @NotNull Function1<? super Extension, String> extensionIdFunction) {
        Intrinsics.checkNotNullParameter((Object)extensionPoint, (String)"extensionPoint");
        Intrinsics.checkNotNullParameter((Object)extensionId, (String)"extensionId");
        Intrinsics.checkNotNullParameter(extensionIdFunction, (String)"extensionIdFunction");
        Project project = extensionPoint.getXmlTag().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"extensionPoint.xmlTag.project");
        return new ExtensionByExtensionPointLocator(project, extensionPoint, extensionId, extensionIdFunction);
    }

    public static final void processExtensionDeclarations(@NotNull String name, @NotNull Project project, boolean strictMatch, @NotNull Function2<? super Extension, ? super XmlTag, Boolean> callback) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        GlobalSearchScope globalSearchScope = PluginRelatedLocatorsUtils.getCandidatesScope(project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getCandidatesScope(project)");
        GlobalSearchScope scope = globalSearchScope;
        String searchWord = StringsKt.substringBeforeLast$default((String)name, (char)'$', null, (int)2, null);
        if (((CharSequence)searchWord).length() == 0) {
            return;
        }
        PsiSearchHelper.getInstance((Project)project).processElementsWithWord((arg_0, arg_1) -> ExtensionLocatorKt.processExtensionDeclarations$lambda$0(strictMatch, name, project, callback, arg_0, arg_1), (SearchScope)scope, searchWord, (short)8, true);
    }

    public static /* synthetic */ void processExtensionDeclarations$default(String string, Project project, boolean bl, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        ExtensionLocatorKt.processExtensionDeclarations(string, project, bl, (Function2<? super Extension, ? super XmlTag, Boolean>)function2);
    }

    private static final List<ExtensionCandidate> findExtensionsByClassName(Project project, String className) {
        List<ExtensionCandidate> result = Collections.synchronizedList((List)new SmartList());
        Lazy smartPointerManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SmartPointerManager>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(0);
            }

            public final SmartPointerManager invoke() {
                return SmartPointerManager.getInstance((Project)this.$project);
            }
        }));
        boolean $i$f$processExtensionsByClassName = false;
        ExtensionLocatorKt.processExtensionDeclarations$default(className, project, false, (Function2)new Function2<Extension, XmlTag, Boolean>(result, smartPointerManager$delegate){
            final /* synthetic */ List $result$inlined;
            final /* synthetic */ Lazy $smartPointerManager$delegate$inlined;
            {
                this.$result$inlined = list;
                this.$smartPointerManager$delegate$inlined = lazy;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull Extension extension, @NotNull XmlTag tag) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                ExtensionPoint extensionPoint = extension.getExtensionPoint();
                if (extensionPoint != null) {
                    ExtensionPoint it = extensionPoint;
                    boolean bl2 = false;
                    XmlTag tag2 = tag;
                    boolean bl3 = false;
                    this.$result$inlined.add(new ExtensionCandidate((SmartPsiElementPointer<XmlTag>)ExtensionLocatorKt.access$findExtensionsByClassName$lambda$1(this.$smartPointerManager$delegate$inlined).createSmartPsiElementPointer((PsiElement)tag2)));
                    bl = true;
                } else {
                    bl = true;
                }
                return bl;
            }
        }, 4, null);
        Intrinsics.checkNotNullExpressionValue(result, (String)"result");
        return result;
    }

    public static final void processExtensionsByClassName(@NotNull Project project, @NotNull String className, @NotNull Function2<? super XmlTag, ? super ExtensionPoint, Boolean> processor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        boolean $i$f$processExtensionsByClassName = false;
        ExtensionLocatorKt.processExtensionDeclarations$default(className, project, false, (Function2)new Function2<Extension, XmlTag, Boolean>(processor){
            final /* synthetic */ Function2<XmlTag, ExtensionPoint, Boolean> $processor;
            {
                this.$processor = $processor;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull Extension extension, @NotNull XmlTag tag) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                ExtensionPoint extensionPoint = extension.getExtensionPoint();
                if (extensionPoint != null) {
                    ExtensionPoint extensionPoint2 = extensionPoint;
                    Function2<XmlTag, ExtensionPoint, Boolean> function2 = this.$processor;
                    ExtensionPoint it = extensionPoint2;
                    boolean bl2 = false;
                    bl = (Boolean)function2.invoke((Object)tag, (Object)it);
                } else {
                    bl = true;
                }
                return bl;
            }
        }, 4, null);
    }

    private static final boolean processExtensionDeclarations$lambda$0(boolean $strictMatch, String $name, Project $project, Function2 $callback, PsiElement element, int offsetInElement) {
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        XmlTag xmlTag = element instanceof XmlTag ? (XmlTag)element : null;
        if (xmlTag == null || (xmlTag = xmlTag.findElementAt(offsetInElement)) == null) {
            return true;
        }
        XmlTag elementAtOffset = xmlTag;
        if ($strictMatch ? !elementAtOffset.textMatches((CharSequence)$name) : !StringUtil.contains((CharSequence)elementAtOffset.getText(), (CharSequence)$name)) {
            return true;
        }
        DomElement domElement = DomManager.getDomManager((Project)$project).getDomElement((XmlTag)element);
        Extension extension = domElement instanceof Extension ? (Extension)domElement : null;
        if (extension == null) {
            return true;
        }
        Extension extension2 = extension;
        return (Boolean)$callback.invoke((Object)extension2, (Object)element);
    }

    private static final SmartPointerManager findExtensionsByClassName$lambda$1(Lazy<? extends SmartPointerManager> $smartPointerManager$delegate) {
        Lazy<? extends SmartPointerManager> lazy = $smartPointerManager$delegate;
        return (SmartPointerManager)lazy.getValue();
    }

    public static final /* synthetic */ SmartPointerManager access$findExtensionsByClassName$lambda$1(Lazy $smartPointerManager$delegate) {
        return ExtensionLocatorKt.findExtensionsByClassName$lambda$1((Lazy<? extends SmartPointerManager>)$smartPointerManager$delegate);
    }
}

