/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.kotlin.inspections;

import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.UtilKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.kotlin.DevKitKotlinBundle;
import org.jetbrains.idea.devkit.kotlin.inspections.BlockingContextFunctionBodyVisitor;
import org.jetbrains.idea.devkit.kotlin.inspections.BlockingContextKt;
import org.jetbrains.idea.devkit.kotlin.inspections.ForbiddenInSuspectContextMethodInspectionKt;
import org.jetbrains.idea.devkit.util.BlockingContextInspectionsKt;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotated;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotatedKt;
import org.jetbrains.kotlin.analysis.api.calls.KtCallInfo;
import org.jetbrains.kotlin.analysis.api.calls.KtCallKt;
import org.jetbrains.kotlin.analysis.api.calls.KtFunctionCall;
import org.jetbrains.kotlin.analysis.api.calls.KtPartiallyAppliedSymbol;
import org.jetbrains.kotlin.analysis.api.components.KtTypeProviderMixIn;
import org.jetbrains.kotlin.analysis.api.lifetime.KtDefaultLifetimeTokenProvider;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KtNamedSymbol;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.analysis.api.types.KtUsualClassType;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.idea.util.ImportInsertHelperImpl;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b\u00b2\u0006\n\u0010\f\u001a\u00020\rX\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/idea/devkit/kotlin/inspections/ForbiddenInSuspectContextMethodInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "createFileVisitor", "BlockingContextMethodsCallsVisitor", "intellij.kotlin.devkit", "blockingContextCallsVisitor", "Lorg/jetbrains/idea/devkit/kotlin/inspections/ForbiddenInSuspectContextMethodInspection$BlockingContextMethodsCallsVisitor;"})
public final class ForbiddenInSuspectContextMethodInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (BlockingContextInspectionsKt.isInspectionForBlockingContextAvailable(holder)) {
            psiElementVisitor = this.createFileVisitor(holder);
        } else {
            PsiElementVisitor psiElementVisitor2 = PsiElementVisitor.EMPTY_VISITOR;
            psiElementVisitor = psiElementVisitor2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor2, (String)"{\n      PsiElementVisitor.EMPTY_VISITOR\n    }");
        }
        return psiElementVisitor;
    }

    private final PsiElementVisitor createFileVisitor(ProblemsHolder holder) {
        Lazy blockingContextCallsVisitor$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<BlockingContextMethodsCallsVisitor>(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
                super(0);
            }

            @NotNull
            public final BlockingContextMethodsCallsVisitor invoke() {
                return new BlockingContextMethodsCallsVisitor(this.$holder);
            }
        }));
        return (PsiElementVisitor)new KtTreeVisitorVoid((Lazy<BlockingContextMethodsCallsVisitor>)blockingContextCallsVisitor$delegate){
            final /* synthetic */ Lazy<BlockingContextMethodsCallsVisitor> $blockingContextCallsVisitor$delegate;
            {
                this.$blockingContextCallsVisitor$delegate = $blockingContextCallsVisitor$delegate;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            }

            public void visitNamedFunction(@NotNull KtNamedFunction function) {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                if (function.hasModifier(KtTokens.SUSPEND_KEYWORD) && !ForbiddenInSuspectContextMethodInspectionKt.access$isSuspensionRestricted(function)) {
                    KtExpression ktExpression = function.getBodyExpression();
                    if (ktExpression != null) {
                        ktExpression.accept((PsiElementVisitor)ForbiddenInSuspectContextMethodInspection.access$createFileVisitor$lambda$0(this.$blockingContextCallsVisitor$delegate));
                    }
                    return;
                }
                super.visitNamedFunction(function);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
                void this_$iv$iv$iv;
                void this_$iv$iv;
                Intrinsics.checkNotNullParameter((Object)lambdaExpression, (String)"lambdaExpression");
                Lazy<BlockingContextMethodsCallsVisitor> lazy = this.$blockingContextCallsVisitor$delegate;
                Object nonDefaultLifetimeTokenFactory$iv = null;
                boolean $i$f$analyze = false;
                Project project = ((KtElement)lambdaExpression).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KtAnalysisSessionProvider ktAnalysisSessionProvider = KtAnalysisSessionProvider.Companion.getInstance(project);
                boolean $i$f$analyse = false;
                KtLifetimeTokenFactory factory$iv$iv = KtDefaultLifetimeTokenProvider.Companion.getService(this_$iv$iv.getProject()).getDefaultLifetimeTokenFactory();
                void var8_8 = this_$iv$iv;
                KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)lambdaExpression, factory$iv$iv);
                boolean $i$f$analyse2 = false;
                this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
                factory$iv$iv.beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
                try {
                    KtType type;
                    KtAnalysisSession $this$visitLambdaExpression_u24lambda_u240 = analysisSession$iv$iv$iv;
                    boolean bl = false;
                    KtType ktType = type = $this$visitLambdaExpression_u24lambda_u240.getKtType((KtExpression)lambdaExpression);
                    boolean bl2 = ktType != null ? $this$visitLambdaExpression_u24lambda_u240.isSuspendFunctionType(ktType) : false;
                    if (bl2 && !ForbiddenInSuspectContextMethodInspectionKt.access$isSuspensionRestricted($this$visitLambdaExpression_u24lambda_u240, type)) {
                        KtBlockExpression ktBlockExpression = lambdaExpression.getBodyExpression();
                        if (ktBlockExpression != null) {
                            ktBlockExpression.accept((PsiElementVisitor)ForbiddenInSuspectContextMethodInspection.access$createFileVisitor$lambda$0(lazy));
                        }
                        return;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    factory$iv$iv.afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
                    this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
                }
                super.visitLambdaExpression(lambdaExpression);
            }
        };
    }

    private static final BlockingContextMethodsCallsVisitor createFileVisitor$lambda$0(Lazy<BlockingContextMethodsCallsVisitor> $blockingContextCallsVisitor$delegate) {
        Lazy<BlockingContextMethodsCallsVisitor> lazy = $blockingContextCallsVisitor$delegate;
        return (BlockingContextMethodsCallsVisitor)((Object)lazy.getValue());
    }

    public static final /* synthetic */ BlockingContextMethodsCallsVisitor access$createFileVisitor$lambda$0(Lazy $blockingContextCallsVisitor$delegate) {
        return ForbiddenInSuspectContextMethodInspection.createFileVisitor$lambda$0((Lazy<BlockingContextMethodsCallsVisitor>)$blockingContextCallsVisitor$delegate);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001:\u0005\u001c\u001d\u001e\u001f B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a2\u0006\u0002\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015H\u0082\bJ\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0006H\u0016J\u001f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u001bR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/idea/devkit/kotlin/inspections/ForbiddenInSuspectContextMethodInspection$BlockingContextMethodsCallsVisitor;", "Lorg/jetbrains/idea/devkit/kotlin/inspections/BlockingContextFunctionBodyVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "callingElement", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitedSymbols", "", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtSymbol;", "checkCalledFunction", "", "call", "calledSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtFunctionSymbol;", "generalFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "()[Lcom/intellij/codeInspection/LocalQuickFix;", "ifInSuspend", "fix", "Lkotlin/Function0;", "visitCallExpression", "expression", "provideFixesForInvokeLater", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "callExpression", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtCallExpression;)[Lcom/intellij/codeInspection/LocalQuickFix;", "NavigateToCallInSuspendFunction", "ReplaceInvokeAndWaitWithWithContextQuickFix", "ReplaceInvokeLaterWithLaunchQuickFix", "ReplaceInvokeLaterWithWithContextQuickFix", "ReplaceProgressManagerCheckCanceledQuickFix", "intellij.kotlin.devkit"})
    @SourceDebugExtension(value={"SMAP\nForbiddenInSuspectContextMethodInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForbiddenInSuspectContextMethodInspection.kt\norg/jetbrains/idea/devkit/kotlin/inspections/ForbiddenInSuspectContextMethodInspection$BlockingContextMethodsCallsVisitor\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KtAnalysisSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,370:1\n189#1:389\n189#1:391\n32#2,7:371\n55#3:378\n54#3,3:379\n75#3,7:382\n82#3:393\n1#4:390\n1#4:392\n1#4:394\n1747#5,2:395\n1747#5,3:397\n1749#5:400\n*S KotlinDebug\n*F\n+ 1 ForbiddenInSuspectContextMethodInspection.kt\norg/jetbrains/idea/devkit/kotlin/inspections/ForbiddenInSuspectContextMethodInspection$BlockingContextMethodsCallsVisitor\n*L\n131#1:389\n139#1:391\n108#1:371,7\n108#1:378\n108#1:379,3\n108#1:382,7\n108#1:393\n131#1:390\n139#1:392\n204#1:395,2\n208#1:397,3\n204#1:400\n*E\n"})
    private static final class BlockingContextMethodsCallsVisitor
    extends BlockingContextFunctionBodyVisitor {
        @NotNull
        private final ProblemsHolder holder;
        @NotNull
        private final Set<KtSymbol> visitedSymbols;
        @Nullable
        private KtCallExpression callingElement;

        public BlockingContextMethodsCallsVisitor(@NotNull ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
            this.visitedSymbols = new LinkedHashSet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void visitCallExpression(@NotNull KtCallExpression expression) {
            void this_$iv$iv$iv;
            void this_$iv$iv;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Object nonDefaultLifetimeTokenFactory$iv = null;
            boolean $i$f$analyze = false;
            Project project = ((KtElement)expression).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KtAnalysisSessionProvider ktAnalysisSessionProvider = KtAnalysisSessionProvider.Companion.getInstance(project);
            boolean $i$f$analyse = false;
            KtLifetimeTokenFactory factory$iv$iv = KtDefaultLifetimeTokenProvider.Companion.getService(this_$iv$iv.getProject()).getDefaultLifetimeTokenFactory();
            void var7_7 = this_$iv$iv;
            KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)expression, factory$iv$iv);
            boolean $i$f$analyse2 = false;
            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
            factory$iv$iv.beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
            try {
                FqName fqName;
                KtFunctionLikeSymbol calledSymbol;
                KtAnalysisSession $this$visitCallExpression_u24lambda_u242 = analysisSession$iv$iv$iv;
                boolean bl = false;
                KtCallInfo ktCallInfo = $this$visitCallExpression_u24lambda_u242.resolveCall((KtElement)expression);
                Object functionCall = ktCallInfo != null ? KtCallKt.singleFunctionCallOrNull((KtCallInfo)ktCallInfo) : null;
                KtFunctionCall ktFunctionCall = functionCall;
                KtFunctionLikeSymbol ktFunctionLikeSymbol = ktFunctionCall != null && (ktFunctionCall = ktFunctionCall.getPartiallyAppliedSymbol()) != null ? (KtFunctionLikeSymbol)KtCallKt.getSymbol((KtPartiallyAppliedSymbol)ktFunctionCall) : (calledSymbol = null);
                if (!(calledSymbol instanceof KtNamedSymbol)) {
                    return;
                }
                boolean hasAnnotation = KtAnnotatedKt.hasAnnotation$default((KtAnnotated)((KtAnnotated)calledSymbol), (ClassId)BlockingContextKt.getRequiresBlockingContextAnnotationId(), null, (int)2, null);
                if (!hasAnnotation) {
                    if (calledSymbol instanceof KtFunctionSymbol) {
                        this.checkCalledFunction(expression, (KtFunctionSymbol)calledSymbol);
                    }
                    if (calledSymbol instanceof KtFunctionSymbol && ((KtFunctionSymbol)calledSymbol).isInline()) {
                        this.checkInlineLambdaArguments((KtFunctionCall<?>)functionCall);
                    }
                    super.visitCallExpression(expression);
                    return;
                }
                CallableId callableId = calledSymbol.getCallableIdIfNonLocal();
                Object object = fqName = callableId != null ? callableId.asSingleFqName() : null;
                if (Intrinsics.areEqual((Object)fqName, (Object)ForbiddenInSuspectContextMethodInspectionKt.access$getProgressManagerCheckedCanceledName$p())) {
                    LocalQuickFix localQuickFix;
                    LocalQuickFix[] localQuickFixArray;
                    ProblemsHolder problemsHolder = this.holder;
                    PsiElement psiElement = (PsiElement)BlockingContextKt.extractElementToHighlight(expression);
                    String string = DevKitKotlinBundle.INSTANCE.message("inspections.forbidden.method.in.suspend.context.check.canceled.text", new Object[0]);
                    ProblemHighlightType problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                    LocalQuickFix[] localQuickFixArray2 = localQuickFixArray = new LocalQuickFix[1];
                    int n = 0;
                    BlockingContextMethodsCallsVisitor this_$iv = this;
                    boolean $i$f$ifInSuspend = false;
                    KtCallExpression ktCallExpression = this_$iv.callingElement;
                    if (ktCallExpression != null) {
                        KtCallExpression it$iv = ktCallExpression;
                        boolean bl2 = false;
                        localQuickFix = (LocalQuickFix)new NavigateToCallInSuspendFunction(it$iv);
                    } else {
                        int n2 = n;
                        LocalQuickFix[] localQuickFixArray3 = localQuickFixArray2;
                        ProblemHighlightType problemHighlightType2 = problemHighlightType;
                        String string2 = string;
                        PsiElement psiElement2 = psiElement;
                        ProblemsHolder problemsHolder2 = problemsHolder;
                        boolean bl3 = false;
                        LocalQuickFix localQuickFix2 = (LocalQuickFix)new ReplaceProgressManagerCheckCanceledQuickFix((PsiElement)expression);
                        problemsHolder = problemsHolder2;
                        psiElement = psiElement2;
                        string = string2;
                        problemHighlightType = problemHighlightType2;
                        localQuickFixArray2 = localQuickFixArray3;
                        n = n2;
                        localQuickFix = localQuickFix2;
                    }
                    localQuickFixArray2[n] = localQuickFix;
                    problemsHolder.registerProblem(psiElement, string, problemHighlightType, localQuickFixArray);
                } else if (Intrinsics.areEqual((Object)fqName, (Object)ForbiddenInSuspectContextMethodInspectionKt.access$getApplicationInvokeAndWaitName$p()) ? true : Intrinsics.areEqual((Object)fqName, (Object)ForbiddenInSuspectContextMethodInspectionKt.access$getInvokeAndWaitIfNeeded$p())) {
                    LocalQuickFix localQuickFix;
                    LocalQuickFix[] localQuickFixArray;
                    ProblemsHolder problemsHolder = this.holder;
                    PsiElement psiElement = (PsiElement)BlockingContextKt.extractElementToHighlight(expression);
                    String string = DevKitKotlinBundle.INSTANCE.message("inspections.forbidden.method.in.suspend.context.invoke.and.wait.text", new Object[0]);
                    ProblemHighlightType problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                    LocalQuickFix[] localQuickFixArray4 = localQuickFixArray = new LocalQuickFix[1];
                    int n = 0;
                    BlockingContextMethodsCallsVisitor this_$iv = this;
                    boolean $i$f$ifInSuspend = false;
                    KtCallExpression ktCallExpression = this_$iv.callingElement;
                    if (ktCallExpression != null) {
                        KtCallExpression it$iv = ktCallExpression;
                        boolean bl4 = false;
                        localQuickFix = (LocalQuickFix)new NavigateToCallInSuspendFunction(it$iv);
                    } else {
                        int n3 = n;
                        LocalQuickFix[] localQuickFixArray5 = localQuickFixArray4;
                        ProblemHighlightType problemHighlightType3 = problemHighlightType;
                        String string3 = string;
                        PsiElement psiElement3 = psiElement;
                        ProblemsHolder problemsHolder3 = problemsHolder;
                        boolean bl5 = false;
                        LocalQuickFix localQuickFix3 = (LocalQuickFix)new ReplaceInvokeAndWaitWithWithContextQuickFix((PsiElement)expression);
                        problemsHolder = problemsHolder3;
                        psiElement = psiElement3;
                        string = string3;
                        problemHighlightType = problemHighlightType3;
                        localQuickFixArray4 = localQuickFixArray5;
                        n = n3;
                        localQuickFix = localQuickFix3;
                    }
                    localQuickFixArray4[n] = localQuickFix;
                    problemsHolder.registerProblem(psiElement, string, problemHighlightType, localQuickFixArray);
                } else if (Intrinsics.areEqual((Object)fqName, (Object)ForbiddenInSuspectContextMethodInspectionKt.access$getApplicationGetDefaultModalityState$p()) ? true : Intrinsics.areEqual((Object)fqName, (Object)ForbiddenInSuspectContextMethodInspectionKt.access$getModalityStateDefaultModalityState$p())) {
                    this.holder.registerProblem((PsiElement)BlockingContextKt.extractElementToHighlight(expression), DevKitKotlinBundle.INSTANCE.message("inspections.forbidden.method.in.suspend.context.default.modality.state.text", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                } else if (Intrinsics.areEqual((Object)fqName, (Object)ForbiddenInSuspectContextMethodInspectionKt.access$getApplicationInvokeLater$p()) ? true : Intrinsics.areEqual((Object)fqName, (Object)ForbiddenInSuspectContextMethodInspectionKt.access$getInvokeLaterKt$p())) {
                    LocalQuickFix[] localQuickFixArray = this.provideFixesForInvokeLater($this$visitCallExpression_u24lambda_u242, expression);
                    this.holder.registerProblem((PsiElement)BlockingContextKt.extractElementToHighlight(expression), DevKitKotlinBundle.INSTANCE.message("inspections.forbidden.method.in.suspend.context.invoke.later.text", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                } else {
                    PsiElement psiElement = (PsiElement)BlockingContextKt.extractElementToHighlight(expression);
                    Object[] objectArray = new Object[1];
                    Intrinsics.checkNotNullExpressionValue((Object)((KtNamedSymbol)calledSymbol).getName().asString(), (String)"calledSymbol.name.asString()");
                    String string = DevKitKotlinBundle.INSTANCE.message("inspections.forbidden.method.in.suspend.context.text", objectArray);
                    objectArray = this.generalFixes();
                    this.holder.registerProblem(psiElement, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                factory$iv$iv.afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
                this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void checkCalledFunction(KtCallExpression call, KtFunctionSymbol calledSymbol) {
            PsiElement psiElement = calledSymbol.getPsi();
            if (Intrinsics.areEqual((Object)(psiElement != null ? psiElement.getContainingFile() : null), (Object)this.holder.getFile()) && !calledSymbol.isSuspend() && !this.visitedSymbols.contains(calledSymbol) && this.callingElement == null) {
                try {
                    ((Collection)this.visitedSymbols).add(calledSymbol);
                    this.callingElement = call;
                    PsiElement psiElement2 = calledSymbol.getPsi();
                    KtNamedFunction ktNamedFunction = psiElement2 instanceof KtNamedFunction ? (KtNamedFunction)psiElement2 : null;
                    if (ktNamedFunction != null && (ktNamedFunction = ktNamedFunction.getBodyExpression()) != null) {
                        ktNamedFunction.accept((PsiElementVisitor)this);
                    }
                }
                finally {
                    this.callingElement = null;
                }
            }
        }

        private final LocalQuickFix ifInSuspend(Function0<? extends LocalQuickFix> fix) {
            LocalQuickFix localQuickFix;
            boolean $i$f$ifInSuspend = false;
            KtCallExpression ktCallExpression = this.callingElement;
            if (ktCallExpression != null) {
                KtCallExpression it = ktCallExpression;
                boolean bl = false;
                localQuickFix = (LocalQuickFix)new NavigateToCallInSuspendFunction(it);
            } else {
                localQuickFix = (LocalQuickFix)fix.invoke();
            }
            return localQuickFix;
        }

        private final LocalQuickFix[] generalFixes() {
            LocalQuickFix[] localQuickFixArray;
            KtCallExpression ktCallExpression = this.callingElement;
            if (ktCallExpression != null) {
                KtCallExpression it = ktCallExpression;
                boolean bl = false;
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[]{new NavigateToCallInSuspendFunction(it)};
                localQuickFixArray = localQuickFixArray2;
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                Intrinsics.checkNotNullExpressionValue((Object)LocalQuickFix.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            }
            return localQuickFixArray;
        }

        /*
         * Enabled aggressive block sorting
         */
        private final LocalQuickFix[] provideFixesForInvokeLater(KtAnalysisSession $this$provideFixesForInvokeLater, KtCallExpression callExpression) {
            boolean hasCoroutineScope;
            Object $this$provideFixesForInvokeLater_u24lambda_u248;
            Object object;
            block7: {
                boolean bl;
                boolean bl2;
                Iterable $this$any$iv;
                ClassId coroutineScopeClass;
                block9: {
                    object = this.callingElement;
                    if (object != null) {
                        KtCallExpression it = object;
                        boolean bl3 = false;
                        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new NavigateToCallInSuspendFunction(it)};
                        return localQuickFixArray;
                    }
                    $this$provideFixesForInvokeLater_u24lambda_u248 = object = CollectionsKt.createListBuilder();
                    boolean bl4 = false;
                    $this$provideFixesForInvokeLater_u24lambda_u248.add(new ReplaceInvokeLaterWithWithContextQuickFix((PsiElement)callExpression));
                    List implicitReceiverTypesAtPosition = $this$provideFixesForInvokeLater.getImplicitReceiverTypesAtPosition((KtElement)callExpression);
                    ClassId classId = ClassId.topLevel((FqName)new FqName("kotlinx.coroutines.CoroutineScope"));
                    Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(FqName(COROUTINE_SCOPE))");
                    coroutineScopeClass = classId;
                    $this$any$iv = implicitReceiverTypesAtPosition;
                    boolean $i$f$any = false;
                    if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block9;
                    bl2 = false;
                    break block7;
                }
                Iterator iterator = $this$any$iv.iterator();
                do {
                    block11: {
                        block12: {
                            boolean bl5;
                            block8: {
                                Iterator iterator2;
                                block14: {
                                    block10: {
                                        Iterable $this$any$iv2;
                                        block13: {
                                            if (!iterator.hasNext()) break block10;
                                            Object element$iv = iterator.next();
                                            KtType type = (KtType)element$iv;
                                            boolean bl6 = false;
                                            if (!(type instanceof KtUsualClassType)) break block11;
                                            if (Intrinsics.areEqual((Object)((KtUsualClassType)type).getClassId(), (Object)coroutineScopeClass)) break block12;
                                            $this$any$iv2 = KtTypeProviderMixIn.getAllSuperTypes$default((KtTypeProviderMixIn)((KtTypeProviderMixIn)$this$provideFixesForInvokeLater), (KtType)type, (boolean)false, (int)1, null);
                                            boolean $i$f$any = false;
                                            if (!($this$any$iv2 instanceof Collection) || !((Collection)$this$any$iv2).isEmpty()) break block13;
                                            bl5 = false;
                                            break block8;
                                        }
                                        iterator2 = $this$any$iv2.iterator();
                                        break block14;
                                    }
                                    bl2 = false;
                                    break block7;
                                }
                                while (iterator2.hasNext()) {
                                    Object element$iv = iterator2.next();
                                    KtType superType = (KtType)element$iv;
                                    boolean bl7 = false;
                                    if (!(superType instanceof KtUsualClassType && Intrinsics.areEqual((Object)((KtUsualClassType)superType).getClassId(), (Object)coroutineScopeClass))) continue;
                                    bl5 = true;
                                    break block8;
                                }
                                bl5 = false;
                            }
                            if (!bl5) break block11;
                        }
                        bl = true;
                        continue;
                    }
                    bl = false;
                } while (!bl);
                bl2 = hasCoroutineScope = true;
            }
            if (hasCoroutineScope) {
                $this$provideFixesForInvokeLater_u24lambda_u248.add(new ReplaceInvokeLaterWithLaunchQuickFix((PsiElement)callExpression));
            }
            Collection collection = CollectionsKt.build((List)object);
            Intrinsics.checkNotNullExpressionValue((Object)LocalQuickFix.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return (LocalQuickFix[])UtilKt.toArray((Collection)collection, (Object[])LocalQuickFix.EMPTY_ARRAY);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/idea/devkit/kotlin/inspections/ForbiddenInSuspectContextMethodInspection$BlockingContextMethodsCallsVisitor$NavigateToCallInSuspendFunction;", "Lcom/intellij/codeInspection/IntentionAndQuickFixAction;", "callingElement", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;)V", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getFamilyName", "", "getName", "isAvailable", "", "startInWriteAction", "intellij.kotlin.devkit"})
        private static final class NavigateToCallInSuspendFunction
        extends IntentionAndQuickFixAction {
            @NotNull
            private final SmartPsiElementPointer<KtCallExpression> pointer;

            public NavigateToCallInSuspendFunction(@NotNull KtCallExpression callingElement) {
                Intrinsics.checkNotNullParameter((Object)callingElement, (String)"callingElement");
                SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)callingElement));
                Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(callingElement)");
                this.pointer = smartPsiElementPointer;
            }

            @NotNull
            public String getFamilyName() {
                return DevKitKotlinBundle.INSTANCE.message("inspections.forbidden.method.in.suspend.context.navigate.to.suspend.context", new Object[0]);
            }

            public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return editor != null && this.pointer.getElement() != null;
            }

            public void applyFix(@NotNull Project project, @Nullable PsiFile file, @Nullable Editor editor) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                PsiElement psiElement = this.pointer.getElement();
                Intrinsics.checkNotNull((Object)psiElement);
                BlockingContextKt.extractElementToHighlight((KtCallExpression)psiElement).navigate(true);
            }

            public boolean startInWriteAction() {
                return false;
            }

            @NotNull
            public String getName() {
                return this.getFamilyName();
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J3\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0096\u0002J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/devkit/kotlin/inspections/ForbiddenInSuspectContextMethodInspection$BlockingContextMethodsCallsVisitor$ReplaceInvokeAndWaitWithWithContextQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "endElement", "isAvailable", "", "intellij.kotlin.devkit"})
        private static class ReplaceInvokeAndWaitWithWithContextQuickFix
        extends LocalQuickFixAndIntentionActionOnPsiElement {
            public ReplaceInvokeAndWaitWithWithContextQuickFix(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                super(element);
            }

            @NotNull
            public String getFamilyName() {
                return DevKitKotlinBundle.INSTANCE.message("inspections.forbidden.method.in.suspend.context.invoke.and.wait.fix.text", new Object[0]);
            }

            @NotNull
            public String getText() {
                return this.getFamilyName();
            }

            public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
                Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
                KtCallExpression ktCallExpression = ForbiddenInSuspectContextMethodInspectionKt.access$getCallExpression(startElement);
                if (ktCallExpression == null) {
                    return false;
                }
                KtCallExpression callExpression = ktCallExpression;
                return ForbiddenInSuspectContextMethodInspectionKt.access$getLambdaArgumentExpression(callExpression) != null;
            }

            public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
                Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
                KtCallExpression ktCallExpression = ForbiddenInSuspectContextMethodInspectionKt.access$getCallExpression(startElement);
                Intrinsics.checkNotNull((Object)ktCallExpression);
                KtCallExpression callExpression = ktCallExpression;
                FqName fqName = ForbiddenInSuspectContextMethodInspectionKt.access$getIntelliJEdtDispatcher$p();
                KtFile ktFile = callExpression.getContainingKtFile();
                Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"callExpression.containingKtFile");
                if (!ForbiddenInSuspectContextMethodInspectionKt.access$isImported(fqName, ktFile)) {
                    KtFile ktFile2 = callExpression.getContainingKtFile();
                    Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"callExpression.containingKtFile");
                    ImportInsertHelperImpl.Companion.addImport$default((ImportInsertHelperImpl.Companion)ImportInsertHelperImpl.Companion, (Project)project, (KtFile)ktFile2, (FqName)ForbiddenInSuspectContextMethodInspectionKt.access$getIntelliJEdtDispatcher$p(), (boolean)false, null, (int)24, null);
                }
                ForbiddenInSuspectContextMethodInspectionKt.access$replaceMethodInCallWithLambda(callExpression, "kotlinx.coroutines.withContext(kotlinx.coroutines.Dispatchers." + ForbiddenInSuspectContextMethodInspectionKt.access$getIntelliJEdtDispatcher$p().shortName().asString() + ") {}");
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J3\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0096\u0002J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/devkit/kotlin/inspections/ForbiddenInSuspectContextMethodInspection$BlockingContextMethodsCallsVisitor$ReplaceInvokeLaterWithLaunchQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "endElement", "isAvailable", "", "intellij.kotlin.devkit"})
        private static final class ReplaceInvokeLaterWithLaunchQuickFix
        extends LocalQuickFixAndIntentionActionOnPsiElement {
            public ReplaceInvokeLaterWithLaunchQuickFix(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                super(element);
            }

            @NotNull
            public String getFamilyName() {
                return DevKitKotlinBundle.INSTANCE.message("inspections.forbidden.method.in.suspend.context.invoke.later.fix.launch.text", new Object[0]);
            }

            @NotNull
            public String getText() {
                return this.getFamilyName();
            }

            public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
                Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
                KtCallExpression ktCallExpression = ForbiddenInSuspectContextMethodInspectionKt.access$getCallExpression(startElement);
                if (ktCallExpression == null) {
                    return false;
                }
                KtCallExpression callExpression = ktCallExpression;
                return ForbiddenInSuspectContextMethodInspectionKt.access$getLambdaArgumentExpression(callExpression) != null;
            }

            public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
                Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
                KtCallExpression ktCallExpression = ForbiddenInSuspectContextMethodInspectionKt.access$getCallExpression(startElement);
                Intrinsics.checkNotNull((Object)ktCallExpression);
                KtCallExpression callExpression = ktCallExpression;
                FqName fqName = ForbiddenInSuspectContextMethodInspectionKt.access$getIntelliJEdtDispatcher$p();
                KtFile ktFile = callExpression.getContainingKtFile();
                Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"callExpression.containingKtFile");
                if (!ForbiddenInSuspectContextMethodInspectionKt.access$isImported(fqName, ktFile)) {
                    KtFile ktFile2 = callExpression.getContainingKtFile();
                    Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"callExpression.containingKtFile");
                    ImportInsertHelperImpl.Companion.addImport$default((ImportInsertHelperImpl.Companion)ImportInsertHelperImpl.Companion, (Project)project, (KtFile)ktFile2, (FqName)ForbiddenInSuspectContextMethodInspectionKt.access$getIntelliJEdtDispatcher$p(), (boolean)false, null, (int)24, null);
                }
                FqName fqName2 = ForbiddenInSuspectContextMethodInspectionKt.access$getCoroutinesLaunch$p();
                KtFile ktFile3 = callExpression.getContainingKtFile();
                Intrinsics.checkNotNullExpressionValue((Object)ktFile3, (String)"callExpression.containingKtFile");
                if (!ForbiddenInSuspectContextMethodInspectionKt.access$isImported(fqName2, ktFile3)) {
                    KtFile ktFile4 = callExpression.getContainingKtFile();
                    Intrinsics.checkNotNullExpressionValue((Object)ktFile4, (String)"callExpression.containingKtFile");
                    ImportInsertHelperImpl.Companion.addImport$default((ImportInsertHelperImpl.Companion)ImportInsertHelperImpl.Companion, (Project)project, (KtFile)ktFile4, (FqName)ForbiddenInSuspectContextMethodInspectionKt.access$getCoroutinesLaunch$p(), (boolean)false, null, (int)24, null);
                }
                ForbiddenInSuspectContextMethodInspectionKt.access$replaceMethodInCallWithLambda(callExpression, ForbiddenInSuspectContextMethodInspectionKt.access$getCoroutinesLaunch$p().shortName() + "(kotlinx.coroutines.Dispatchers." + ForbiddenInSuspectContextMethodInspectionKt.access$getIntelliJEdtDispatcher$p().shortName() + ") {}");
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/idea/devkit/kotlin/inspections/ForbiddenInSuspectContextMethodInspection$BlockingContextMethodsCallsVisitor$ReplaceInvokeLaterWithWithContextQuickFix;", "Lorg/jetbrains/idea/devkit/kotlin/inspections/ForbiddenInSuspectContextMethodInspection$BlockingContextMethodsCallsVisitor$ReplaceInvokeAndWaitWithWithContextQuickFix;", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)V", "getFamilyName", "", "intellij.kotlin.devkit"})
        private static final class ReplaceInvokeLaterWithWithContextQuickFix
        extends ReplaceInvokeAndWaitWithWithContextQuickFix {
            public ReplaceInvokeLaterWithWithContextQuickFix(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                super(element);
            }

            @Override
            @NotNull
            public String getFamilyName() {
                return DevKitKotlinBundle.INSTANCE.message("inspections.forbidden.method.in.suspend.context.invoke.later.fix.with.context.text", new Object[0]);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J3\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0096\u0002J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/devkit/kotlin/inspections/ForbiddenInSuspectContextMethodInspection$BlockingContextMethodsCallsVisitor$ReplaceProgressManagerCheckCanceledQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "endElement", "isAvailable", "", "intellij.kotlin.devkit"})
        private static final class ReplaceProgressManagerCheckCanceledQuickFix
        extends LocalQuickFixAndIntentionActionOnPsiElement {
            public ReplaceProgressManagerCheckCanceledQuickFix(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                super(element);
            }

            @NotNull
            public String getFamilyName() {
                return DevKitKotlinBundle.INSTANCE.message("inspections.forbidden.method.in.suspend.context.check.canceled.fix.text", new Object[0]);
            }

            @NotNull
            public String getText() {
                return this.getFamilyName();
            }

            public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
                Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
                return ForbiddenInSuspectContextMethodInspectionKt.access$getCallExpression(startElement) != null;
            }

            public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                KtQualifiedExpression qualifiedExpression;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
                Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
                KtCallExpression ktCallExpression = ForbiddenInSuspectContextMethodInspectionKt.access$getCallExpression(startElement);
                Intrinsics.checkNotNull((Object)ktCallExpression);
                KtCallExpression callExpression = ktCallExpression;
                KtPsiFactory factory = new KtPsiFactory(project, false, 2, null);
                KtExpression suspendAwareCheckCanceled = factory.createExpression("com.intellij.openapi.progress.checkCancelled()");
                KtQualifiedExpression ktQualifiedExpression = qualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)callExpression));
                KtExpression expressionToReplace = ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : (KtExpression)callExpression;
                PsiElement resultExpression = expressionToReplace.replace((PsiElement)suspendAwareCheckCanceled);
                ShortenReferencesFacility shortenReferencesFacility = ShortenReferencesFacility.Companion.getInstance();
                Intrinsics.checkNotNull((Object)resultExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                shortenReferencesFacility.shorten((KtElement)resultExpression);
            }
        }
    }
}

