/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0016J)\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0096\u0002J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/idea/devkit/inspections/quickfix/InsertCancellationCheckFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "cancellationCheckCallFqn", "", "loopKeyword", "Lcom/intellij/psi/PsiElement;", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "endElement", "isAvailable", "", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nCancellationCheckInLoopsFixProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CancellationCheckInLoopsFixProvider.kt\norg/jetbrains/idea/devkit/inspections/quickfix/InsertCancellationCheckFix\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,73:1\n57#2,2:74\n57#2,2:76\n58#2:78\n*S KotlinDebug\n*F\n+ 1 CancellationCheckInLoopsFixProvider.kt\norg/jetbrains/idea/devkit/inspections/quickfix/InsertCancellationCheckFix\n*L\n52#1:74,2\n56#1:76,2\n63#1:78\n*E\n"})
public final class InsertCancellationCheckFix
extends LocalQuickFixOnPsiElement {
    @NotNull
    private final String cancellationCheckCallFqn;

    public InsertCancellationCheckFix(@NotNull String cancellationCheckCallFqn, @NotNull PsiElement loopKeyword) {
        Intrinsics.checkNotNullParameter((Object)cancellationCheckCallFqn, (String)"cancellationCheckCallFqn");
        Intrinsics.checkNotNullParameter((Object)loopKeyword, (String)"loopKeyword");
        super(loopKeyword);
        this.cancellationCheckCallFqn = cancellationCheckCallFqn;
    }

    @NotNull
    public String getFamilyName() {
        String string = DevKitBundle.message("inspection.insert.cancellation.check.fix.message", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"inspection.inse\u2026ation.check.fix.message\")");
        return string;
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        PsiElement $this$parentOfType_u24default$iv = startElement;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        return PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PsiLoopStatement.class, (boolean)true) != null;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        block2: {
            PsiElement insertedElement;
            void $this$parentOfType$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            PsiElement $this$parentOfType_u24default$iv = startElement;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            PsiLoopStatement psiLoopStatement = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PsiLoopStatement.class, (boolean)true);
            if (psiLoopStatement == null) {
                return;
            }
            PsiLoopStatement loopStatement = psiLoopStatement;
            PsiElementFactory factory = PsiElementFactory.getInstance((Project)project);
            String cancellationCheckText = this.cancellationCheckCallFqn + "();";
            PsiStatement psiStatement = factory.createStatementFromText(cancellationCheckText, (PsiElement)loopStatement);
            Intrinsics.checkNotNullExpressionValue((Object)psiStatement, (String)"factory.createStatementF\u2026CheckText, loopStatement)");
            PsiStatement cancellationCheckStatement = psiStatement;
            PsiStatement psiStatement2 = loopStatement.getBody();
            if (psiStatement2 == null) {
                return;
            }
            PsiStatement body = psiStatement2;
            PsiStatement psiStatement3 = BlockUtils.expandSingleStatementToBlockStatement((PsiStatement)body);
            Intrinsics.checkNotNullExpressionValue((Object)psiStatement3, (String)"expandSingleStatementToBlockStatement(body)");
            PsiElement psiElement = (PsiElement)psiStatement3;
            boolean withSelf$iv2 = true;
            boolean $i$f$parentOfType2 = false;
            PsiBlockStatement bodyBlock = (PsiBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, PsiBlockStatement.class, (boolean)false);
            PsiBlockStatement psiBlockStatement = bodyBlock;
            PsiElement psiElement2 = insertedElement = psiBlockStatement != null && (psiBlockStatement = psiBlockStatement.getCodeBlock()) != null ? psiBlockStatement.addBefore((PsiElement)cancellationCheckStatement, bodyBlock.getCodeBlock().getFirstBodyElement()) : null;
            if (psiElement2 == null) break block2;
            PsiElement it = psiElement2;
            boolean bl = false;
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(it);
        }
    }
}

