/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.jvm.DefaultJvmElementVisitor;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmElementVisitor;
import com.intellij.lang.jvm.inspection.JvmLocalInspection;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.inspections.DevKitJvmInspection;
import org.jetbrains.idea.devkit.inspections.quickfix.RegisterExtensionFix;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;
import org.jetbrains.idea.devkit.util.ExtensionPointCandidate;
import org.jetbrains.idea.devkit.util.ExtensionPointLocator;

public class StatisticsCollectorNotRegisteredInspection
extends DevKitJvmInspection {
    public static final String FEATURE_USAGES_COLLECTOR = "com.intellij.internal.statistic.service.fus.collectors.FeatureUsagesCollector";

    @Nullable
    protected JvmElementVisitor<Boolean> buildVisitor(final @NotNull Project project, final @NotNull JvmLocalInspection.HighlightSink sink, boolean isOnTheFly) {
        if (project == null) {
            StatisticsCollectorNotRegisteredInspection.$$$reportNull$$$0(0);
        }
        if (sink == null) {
            StatisticsCollectorNotRegisteredInspection.$$$reportNull$$$0(1);
        }
        return new DefaultJvmElementVisitor<Boolean>(){

            public Boolean visitClass(@NotNull JvmClass clazz) {
                PsiElement sourceElement;
                if (clazz == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!((sourceElement = clazz.getSourceElement()) instanceof PsiClass)) {
                    return null;
                }
                StatisticsCollectorNotRegisteredInspection.checkClass(project, (PsiClass)sourceElement, sink);
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/idea/devkit/inspections/internal/StatisticsCollectorNotRegisteredInspection$1", "visitClass"));
            }
        };
    }

    private static void checkClass(@NotNull Project project, @NotNull PsiClass checkedClass, @NotNull JvmLocalInspection.HighlightSink sink) {
        if (project == null) {
            StatisticsCollectorNotRegisteredInspection.$$$reportNull$$$0(2);
        }
        if (checkedClass == null) {
            StatisticsCollectorNotRegisteredInspection.$$$reportNull$$$0(3);
        }
        if (sink == null) {
            StatisticsCollectorNotRegisteredInspection.$$$reportNull$$$0(4);
        }
        if (checkedClass.getQualifiedName() == null || checkedClass.getContainingFile().getVirtualFile() == null || checkedClass.hasModifierProperty("abstract") || checkedClass.isEnum()) {
            return;
        }
        GlobalSearchScope scope = checkedClass.getResolveScope();
        PsiClass featureUsageCollectorClass = JavaPsiFacade.getInstance((Project)project).findClass(FEATURE_USAGES_COLLECTOR, scope);
        if (featureUsageCollectorClass != null && checkedClass.isInheritor(featureUsageCollectorClass, true)) {
            for (StatisticsCollectorType collectorType : StatisticsCollectorType.values()) {
                if (!InheritanceUtil.isInheritor((PsiClass)checkedClass, (String)collectorType.getClassName())) continue;
                StatisticsCollectorNotRegisteredInspection.checkCollectorRegistration(project, checkedClass, sink, collectorType);
                return;
            }
        }
    }

    private static void checkCollectorRegistration(@NotNull Project project, @NotNull PsiClass checkedClass, @NotNull JvmLocalInspection.HighlightSink sink, @NotNull StatisticsCollectorType collectorType) {
        String qualifiedName;
        if (project == null) {
            StatisticsCollectorNotRegisteredInspection.$$$reportNull$$$0(5);
        }
        if (checkedClass == null) {
            StatisticsCollectorNotRegisteredInspection.$$$reportNull$$$0(6);
        }
        if (sink == null) {
            StatisticsCollectorNotRegisteredInspection.$$$reportNull$$$0(7);
        }
        if (collectorType == null) {
            StatisticsCollectorNotRegisteredInspection.$$$reportNull$$$0(8);
        }
        if ((qualifiedName = ClassUtil.getJVMClassName((PsiClass)checkedClass)) == null) {
            return;
        }
        AtomicBoolean isCollectorRegistered = new AtomicBoolean(false);
        ExtensionLocatorKt.processExtensionDeclarations(StatisticsCollectorNotRegisteredInspection.getNameToSearch(checkedClass, qualifiedName), project, false, (Function2<? super Extension, ? super XmlTag, Boolean>)((Function2)(extension, tag) -> {
            ExtensionPoint point = extension.getExtensionPoint();
            if (point != null && point.getEffectiveQualifiedName().equals(collectorType.getExtensionPoint()) && ContainerUtil.exists((Object[])tag.getAttributes(), it -> Objects.equals(it.getValue(), qualifiedName))) {
                isCollectorRegistered.set(true);
                return false;
            }
            return true;
        }));
        if (isCollectorRegistered.get()) {
            return;
        }
        ExtensionPointLocator extensionPointLocator = new ExtensionPointLocator(checkedClass);
        Set<ExtensionPointCandidate> candidateList = extensionPointLocator.findSuperCandidates();
        if (!candidateList.isEmpty()) {
            RegisterExtensionFix fix = new RegisterExtensionFix(checkedClass, candidateList);
            sink.highlight(DevKitBundle.message("inspections.statistics.collector.not.registered.message", new Object[0]), new LocalQuickFix[]{fix});
        }
    }

    @NotNull
    private static String getNameToSearch(@NotNull PsiClass checkedClass, String qualifiedName) {
        PsiClass parentClass;
        if (checkedClass == null) {
            StatisticsCollectorNotRegisteredInspection.$$$reportNull$$$0(9);
        }
        if ((parentClass = (PsiClass)ObjectUtils.tryCast((Object)checkedClass.getParent(), PsiClass.class)) == null) {
            String string = qualifiedName;
            if (string == null) {
                StatisticsCollectorNotRegisteredInspection.$$$reportNull$$$0(10);
            }
            return string;
        }
        String parentQualifiedName = parentClass.getQualifiedName();
        String string = parentQualifiedName != null ? parentQualifiedName : qualifiedName;
        if (string == null) {
            StatisticsCollectorNotRegisteredInspection.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectorType";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/internal/StatisticsCollectorNotRegisteredInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/StatisticsCollectorNotRegisteredInspection";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameToSearch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkCollectorRegistration";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNameToSearch";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11 -> new IllegalStateException(string);
        };
    }

    private static enum StatisticsCollectorType {
        COUNTER("com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector", "com.intellij.statistics.counterUsagesCollector"),
        PROJECT("com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector", "com.intellij.statistics.projectUsagesCollector"),
        APPLICATION("com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector", "com.intellij.statistics.applicationUsagesCollector");

        private final String myClassName;
        private final String myExtensionPoint;

        private StatisticsCollectorType(String className, String extensionPoint) {
            this.myClassName = className;
            this.myExtensionPoint = extensionPoint;
        }

        public String getClassName() {
            return this.myClassName;
        }

        public String getExtensionPoint() {
            return this.myExtensionPoint;
        }
    }
}

