/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PsiNavigateUtil;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.RegistryPropertiesAnnotatorKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/devkit/inspections/RegistryPropertiesAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "PLUGIN_GROUP_NAMES", "", "", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "AddDescriptionKeyIntention", "ShowEPDeclarationIntention", "intellij.devkit.core"})
public final class RegistryPropertiesAnnotator
implements Annotator {
    @NonNls
    @NotNull
    private final Set<String> PLUGIN_GROUP_NAMES;

    public RegistryPropertiesAnnotator() {
        Object[] objectArray = new String[]{"appcode", "cidr", "clion", "cvs", "git", "github", "svn", "hg4idea", "tfs", "dart", "markdown", "java", "javac", "uast", "junit4", "dsm", "js", "javascript", "typescript", "nodejs", "eslint", "jest", "ruby", "rubymine", "groovy", "grails", "python", "php", "kotlin"};
        this.PLUGIN_GROUP_NAMES = SetsKt.setOf((Object[])objectArray);
    }

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        PropertiesFile propertiesFile2;
        IProperty descriptionProperty;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!(element instanceof PropertyKeyImpl)) {
            return;
        }
        PsiFile psiFile = holder.getCurrentAnnotationSession().getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"holder.currentAnnotationSession.file");
        PsiFile file = psiFile;
        if (!RegistryPropertiesAnnotatorKt.isRegistryPropertiesFile(file)) {
            return;
        }
        String string = ((PropertyKeyImpl)element).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
        String propertyName = string;
        if (RegistryPropertiesAnnotatorKt.isImplicitUsageKey(propertyName)) {
            return;
        }
        String string2 = StringsKt.substringBefore$default((String)propertyName, (char)'.', null, (int)2, null);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        String groupName = string3;
        if (this.PLUGIN_GROUP_NAMES.contains(groupName) || StringsKt.startsWith$default((String)propertyName, (String)"editor.config.", (boolean)false, (int)2, null)) {
            holder.newAnnotation(HighlightSeverity.ERROR, DevKitBundle.message("registry.properties.annotator.plugin.keys.use.ep", new Object[0])).withFix((IntentionAction)new ShowEPDeclarationIntention(propertyName)).create();
        }
        if ((descriptionProperty = (propertiesFile2 = (PropertiesFile)file).findPropertyByKey(propertyName + ".description")) == null) {
            Object[] objectArray = new Object[]{propertyName};
            holder.newAnnotation(HighlightSeverity.WARNING, DevKitBundle.message("registry.properties.annotator.key.no.description.key", objectArray)).withFix((IntentionAction)new AddDescriptionKeyIntention(propertyName)).create();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0017J\b\u0010\u0006\u001a\u00020\u0003H\u0017J!\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/idea/devkit/inspections/RegistryPropertiesAnnotator$AddDescriptionKeyIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "myPropertyName", "", "(Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "startInWriteAction", "intellij.devkit.core"})
    private static final class AddDescriptionKeyIntention
    implements IntentionAction {
        @NotNull
        private final String myPropertyName;

        public AddDescriptionKeyIntention(@NotNull String myPropertyName) {
            Intrinsics.checkNotNullParameter((Object)myPropertyName, (String)"myPropertyName");
            this.myPropertyName = myPropertyName;
        }

        @Nls
        @NotNull
        public String getText() {
            Object[] objectArray = new Object[]{this.myPropertyName};
            String string = DevKitBundle.message("registry.properties.annotator.add.description.text", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"registry.proper\u2026on.text\", myPropertyName)");
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = DevKitBundle.message("registry.properties.annotator.add.description.family.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"registry.proper\u2026description.family.name\")");
            return string;
        }

        public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return true;
        }

        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            PropertiesFile propertiesFile2 = (PropertiesFile)file;
            PropertyImpl originalProperty = (PropertyImpl)propertiesFile2.findPropertyByKey(this.myPropertyName);
            IProperty iProperty = propertiesFile2.addPropertyAfter(this.myPropertyName + ".description", "Description", (IProperty)originalProperty);
            Intrinsics.checkNotNullExpressionValue((Object)iProperty, (String)"propertiesFile.addProper\u2026ption\", originalProperty)");
            IProperty descriptionProperty = iProperty;
            PsiElement psiElement = descriptionProperty.getPsiElement();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.lang.properties.psi.impl.PropertyImpl");
            ASTNode aSTNode = ((PropertyImpl)psiElement).getValueNode();
            Intrinsics.checkNotNull((Object)aSTNode);
            ASTNode valueNode = aSTNode;
            if (!IntentionPreviewUtils.isPreviewElement((PsiElement)valueNode.getPsi())) {
                PsiNavigateUtil.navigate((PsiElement)valueNode.getPsi());
            }
        }

        public boolean startInWriteAction() {
            return true;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J%\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J$\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/devkit/inspections/RegistryPropertiesAnnotator$ShowEPDeclarationIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "propertyName", "", "(Ljava/lang/String;)V", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getFamilyName", "getText", "invoke", "", "isAvailable", "", "startInWriteAction", "intellij.devkit.core"})
    private static final class ShowEPDeclarationIntention
    implements IntentionAction {
        @NotNull
        private final String propertyName;

        public ShowEPDeclarationIntention(@NotNull String propertyName) {
            Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
            this.propertyName = propertyName;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }

        @NotNull
        public String getFamilyName() {
            String string = DevKitBundle.message("registry.properties.annotator.show.ep.family.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"registry.proper\u2026tor.show.ep.family.name\")");
            return string;
        }

        public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return true;
        }

        @NotNull
        public String getText() {
            Object[] objectArray = new Object[]{this.propertyName};
            String string = DevKitBundle.message("registry.properties.annotator.show.ep.name", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"registry.proper\u2026w.ep.name\", propertyName)");
            return string;
        }

        public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNull((Object)file, (String)"null cannot be cast to non-null type com.intellij.lang.properties.psi.PropertiesFile");
            PropertiesFile propertiesFile2 = (PropertiesFile)file;
            IProperty iProperty = propertiesFile2.findPropertyByKey(this.propertyName);
            Intrinsics.checkNotNull((Object)iProperty);
            String defaultValue = iProperty.getValue();
            IProperty iProperty2 = propertiesFile2.findPropertyByKey(this.propertyName + ".description");
            String description2 = iProperty2 != null ? iProperty2.getValue() : null;
            String restartRequiredText = "";
            if (propertiesFile2.findPropertyByKey(this.propertyName + ".restartRequired") != null) {
                restartRequiredText = "restartRequired=\"true\"";
            }
            String epText = StringsKt.trimIndent((String)("\n        <registryKey key=\"" + this.propertyName + "\" defaultValue=\"" + defaultValue + "\" " + restartRequiredText + "\n                     description=\"" + description2 + "\"/>\n      "));
            Messages.showMultilineInputDialog((Project)project, (String)DevKitBundle.message("registry.properties.annotator.show.ep.message", new Object[0]), (String)DevKitBundle.message("registry.properties.annotator.show.ep.title", new Object[0]), (String)epText, null, null);
        }
    }
}

