/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.lang.LanguageExtension;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.ExtensionPoints;
import org.jetbrains.idea.devkit.inspections.DummyUsageTarget;
import org.jetbrains.idea.devkit.inspections.EPElementUsage;
import org.jetbrains.idea.devkit.inspections.EPUsageTarget;
import org.jetbrains.idea.devkit.inspections.ExtensionPointUsageAnalyzerKt;
import org.jetbrains.idea.devkit.inspections.Leak;
import org.jetbrains.idea.devkit.inspections.LeakSearchContext;
import org.jetbrains.idea.devkit.inspections.QualifiedCall;
import org.jetbrains.idea.devkit.util.ExtensionPointCandidate;
import org.jetbrains.idea.devkit.util.ExtensionPointLocator;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a2\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a(\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a(\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u001a\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002\u001a\u001c\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0002\u001a\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0003H\u0002\u001a&\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0002\u00a8\u0006'"}, d2={"analyze", "", "elementAtCaret", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "ignoreSafeClasses", "", "analyzeEPFieldUsages", "target", "Lorg/jetbrains/uast/UField;", "epName", "", "analyzeEPTagUsages", "xmlTag", "Lcom/intellij/psi/xml/XmlTag;", "batchAnalyzeEPTagUsages", "findEPField", "Lcom/intellij/psi/PsiField;", "effectiveClass", "Lcom/intellij/psi/PsiClass;", "epClass", "findQualifiedCall", "Lorg/jetbrains/idea/devkit/inspections/QualifiedCall;", "element", "Lorg/jetbrains/uast/UElement;", "isEPField", "field", "isInPluginModule", "showEPElementUsages", "project", "Lcom/intellij/openapi/project/Project;", "usageTarget", "Lcom/intellij/usages/UsageTarget;", "usages", "", "Lorg/jetbrains/idea/devkit/inspections/EPElementUsage;", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nExtensionPointUsageAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionPointUsageAnalyzer.kt\norg/jetbrains/idea/devkit/inspections/ExtensionPointUsageAnalyzerKt\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n+ 3 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,683:1\n18#2:684\n18#2:685\n205#3:686\n169#3:689\n37#4,2:687\n1#5:690\n*S KotlinDebug\n*F\n+ 1 ExtensionPointUsageAnalyzer.kt\norg/jetbrains/idea/devkit/inspections/ExtensionPointUsageAnalyzerKt\n*L\n61#1:684\n66#1:685\n393#1:686\n497#1:689\n464#1:687,2\n*E\n"})
public final class ExtensionPointUsageAnalyzerKt {
    private static final QualifiedCall findQualifiedCall(UElement element) {
        UExpression selector;
        UQualifiedReferenceExpression qualifiedExpression;
        UCallExpression callExpression;
        UElement uElement = element;
        if (uElement != null) {
            UElement $this$getParentOfType_u24default$iv = uElement;
            boolean strict$iv = true;
            UElement $this$getParentOfType$iv$iv = $this$getParentOfType_u24default$iv;
            boolean $i$f$getParentOfType = false;
            v1 = (UCallExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv$iv, UCallExpression.class, (boolean)strict$iv);
        } else {
            v1 = callExpression = null;
        }
        if (callExpression != null && Intrinsics.areEqual((Object)element, (Object)callExpression.getReceiver())) {
            return new QualifiedCall(callExpression, (UExpression)callExpression);
        }
        UElement uElement2 = element;
        if (uElement2 != null) {
            UElement $this$getParentOfType_u24default$iv = uElement2;
            boolean strict$iv = true;
            UElement $this$getParentOfType$iv$iv = $this$getParentOfType_u24default$iv;
            boolean $i$f$getParentOfType = false;
            v3 = (UQualifiedReferenceExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv$iv, UQualifiedReferenceExpression.class, (boolean)strict$iv);
        } else {
            v3 = qualifiedExpression = null;
        }
        if (qualifiedExpression != null && Intrinsics.areEqual((Object)qualifiedExpression.getReceiver(), (Object)element) && (selector = qualifiedExpression.getSelector()) instanceof UCallExpression) {
            return new QualifiedCall((UCallExpression)selector, (UExpression)qualifiedExpression);
        }
        return null;
    }

    private static final void analyze(PsiElement elementAtCaret, PsiFile file, Editor editor, boolean ignoreSafeClasses) {
        XmlTag xmlTag;
        PsiElement $this$getUastParentOfType_u24default$iv = elementAtCaret;
        boolean strict$iv2 = false;
        boolean $i$f$getUastParentOfType = false;
        UField target = (UField)UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType_u24default$iv, UField.class, (boolean)strict$iv2);
        if (target != null) {
            PsiField psiField;
            PsiElement strict$iv2 = target.getJavaPsi();
            PsiField psiField2 = psiField = strict$iv2 instanceof PsiField ? (PsiField)strict$iv2 : null;
            PsiClass psiClass = psiField2 != null ? psiField2.getContainingClass() : null;
            String epName = null;
            if (psiClass != null) {
                ExtensionPointCandidate extensionPointCandidate = (ExtensionPointCandidate)ContainerUtil.getOnlyItem((Collection)new ExtensionPointLocator(psiClass).findDirectCandidates());
                String string = epName = extensionPointCandidate != null ? extensionPointCandidate.epName : null;
            }
            if (!ExtensionPointUsageAnalyzerKt.isEPField(psiField, null)) {
                HintManager.getInstance().showErrorHint(editor, DevKitBundle.message("extension.point.analyzer.not.extension.point.name", new Object[0]));
                return;
            }
            ExtensionPointUsageAnalyzerKt.analyzeEPFieldUsages(target, file, editor, epName, ignoreSafeClasses);
        }
        if ((xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, XmlTag.class)) != null) {
            if (Intrinsics.areEqual((Object)xmlTag.getName(), (Object)"extensionPoint")) {
                ExtensionPointUsageAnalyzerKt.analyzeEPTagUsages(xmlTag, file, editor, ignoreSafeClasses);
            } else if (Intrinsics.areEqual((Object)xmlTag.getName(), (Object)"extensionPoints")) {
                ExtensionPointUsageAnalyzerKt.batchAnalyzeEPTagUsages(xmlTag, file, editor, ignoreSafeClasses);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isEPField(PsiField field, PsiClass epClass) {
        PsiField psiField = field;
        PsiType psiType = psiField != null ? psiField.getType() : null;
        if (!(psiType instanceof PsiClassReferenceType)) return false;
        PsiClassReferenceType psiClassReferenceType = (PsiClassReferenceType)psiType;
        if (psiClassReferenceType == null) {
            return false;
        }
        PsiClassReferenceType referenceType = psiClassReferenceType;
        PsiType[] psiTypeArray = referenceType.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"referenceType.parameters");
        PsiType[] parameters = psiTypeArray;
        if (!referenceType.isRaw() && parameters.length != 1) {
            return false;
        }
        PsiClassType psiClassType = referenceType.rawType();
        Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"referenceType.rawType()");
        PsiClassType fieldRawType = psiClassType;
        if (!Intrinsics.areEqual((Object)fieldRawType.getCanonicalText(), (Object)ExtensionPointName.class.getName()) && !Intrinsics.areEqual((Object)fieldRawType.getCanonicalText(), (Object)ProjectExtensionPointName.class.getName())) {
            if (!Intrinsics.areEqual((Object)fieldRawType.getCanonicalText(), (Object)LanguageExtension.class.getName())) return false;
        }
        if (parameters.length != 1) return true;
        if (epClass == null) return true;
        PsiType psiType2 = parameters[0];
        PsiClassReferenceType psiClassReferenceType2 = psiType2 instanceof PsiClassReferenceType ? (PsiClassReferenceType)psiType2 : null;
        if (!Intrinsics.areEqual((Object)epClass, (Object)(psiClassReferenceType2 != null ? psiClassReferenceType2.resolve() : null))) return false;
        return true;
    }

    private static final void analyzeEPFieldUsages(UField target, PsiFile file, Editor editor, String epName, boolean ignoreSafeClasses) {
        PsiElement psiElement = target.getSourcePsi();
        if (psiElement == null) {
            return;
        }
        PsiElement sourcePsi = psiElement;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
        LeakSearchContext context = new LeakSearchContext(project, epName, ignoreSafeClasses);
        Project project2 = file.getProject();
        String string = DevKitBundle.message("extension.point.analyzer.analyze.title", new Object[0]);
        Task.Backgroundable task2 = new Task.Backgroundable(context, sourcePsi, editor, file, target, project2, string){
            final /* synthetic */ LeakSearchContext $context;
            final /* synthetic */ PsiElement $sourcePsi;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ UField $target;
            {
                this.$context = $context;
                this.$sourcePsi = $sourcePsi;
                this.$editor = $editor;
                this.$file = $file;
                this.$target = $target;
                super($super_call_param$1, $super_call_param$2);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                this.$context.processEPFieldUsages(this.$sourcePsi);
                ApplicationManager.getApplication().invokeLater(() -> analyzeEPFieldUsages.task.1.run$lambda$1(this.$context, this.$editor, this.$file, this.$target));
            }

            /*
             * WARNING - void declaration
             */
            private static final void run$lambda$1(LeakSearchContext $context, Editor $editor, PsiFile $file, UField $target) {
                Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
                Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
                Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
                Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
                if ($context.getUnsafeUsages().isEmpty()) {
                    if ($context.getSafeUsages().isEmpty()) {
                        HintManager.getInstance().showErrorHint($editor, DevKitBundle.message("extension.point.analyzer.analyze.no.usages", new Object[0]));
                    } else {
                        HintManager.getInstance().showInformationHint($editor, DevKitBundle.message("extension.point.analyzer.analyze.usage.all.safe", new Object[0]));
                    }
                } else {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = $context.getUnsafeUsages();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Pair pair = (Pair)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        PsiElement psiElement = ((Leak)it.getSecond()).getTargetElement();
                        if (psiElement == null) {
                            PsiElement psiElement2 = ((PsiReference)it.getFirst()).getElement();
                            psiElement = psiElement2;
                            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"it.first.element");
                        }
                        collection.add(new EPElementUsage(psiElement, ((Leak)it.getSecond()).getReason()));
                    }
                    List usages = (List)destination$iv$iv;
                    Project project = $file.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
                    PsiElement psiElement = $target.getSourcePsi();
                    Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiNamedElement");
                    ExtensionPointUsageAnalyzerKt.access$showEPElementUsages(project, new EPUsageTarget((PsiNamedElement)psiElement), usages);
                }
            }
        };
        ProgressManager.getInstance().run((Task)task2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void showEPElementUsages(Project project, UsageTarget usageTarget, List<EPElementUsage> usages) {
        void $this$showEPElementUsages_u24lambda_u240;
        UsageViewPresentation usageViewPresentation = new UsageViewPresentation[]{usageTarget};
        UsageViewPresentation usageViewPresentation2 = usageViewPresentation;
        Collection $this$toTypedArray$iv = usages;
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        UsageViewPresentation $i$f$toTypedArray22 = usageViewPresentation = new UsageViewPresentation();
        Usage[] usageArray = (Usage[])thisCollection$iv.toArray(new EPElementUsage[0]);
        UsageViewPresentation usageViewPresentation3 = usageViewPresentation2;
        UsageViewManager usageViewManager = UsageViewManager.getInstance((Project)project);
        boolean bl = false;
        ItemPresentation itemPresentation = usageTarget.getPresentation();
        Intrinsics.checkNotNull((Object)itemPresentation);
        $this$showEPElementUsages_u24lambda_u240.setTabText(itemPresentation.getPresentableText());
        $this$showEPElementUsages_u24lambda_u240.setOpenInNewTab(true);
        Unit unit = Unit.INSTANCE;
        usageViewManager.showUsages((UsageTarget[])usageViewPresentation3, usageArray, usageViewPresentation);
    }

    private static final void analyzeEPTagUsages(XmlTag xmlTag, PsiFile file, Editor editor, boolean ignoreSafeClasses) {
        ExtensionPoint domElement;
        DomElement domElement2 = DomManager.getDomManager((Project)file.getProject()).getDomElement(xmlTag);
        ExtensionPoint extensionPoint = domElement = domElement2 instanceof ExtensionPoint ? (ExtensionPoint)domElement2 : null;
        if (domElement == null) {
            HintManager.getInstance().showErrorHint(editor, DevKitBundle.message("extension.point.analyzer.analyze.xml.not.extension.point", new Object[0]));
            return;
        }
        PsiClass psiClass = domElement.getEffectiveClass();
        if (psiClass == null) {
            boolean bl = false;
            HintManager.getInstance().showErrorHint(editor, DevKitBundle.message("extension.point.analyzer.analyze.xml.cannot.resolve.ep.class", new Object[0]));
            return;
        }
        PsiClass effectiveClass = psiClass;
        if (Intrinsics.areEqual((Object)effectiveClass.getQualifiedName(), (Object)"com.intellij.lang.LanguageExtensionPoint")) {
            PsiClass psiClass2;
            GenericAttributeValue<PsiClass> genericAttributeValue = (GenericAttributeValue<PsiClass>)ContainerUtil.getOnlyItem((Collection)domElement.getWithElements());
            PsiClass psiClass3 = genericAttributeValue != null && (genericAttributeValue = genericAttributeValue.getImplements()) != null ? (PsiClass)genericAttributeValue.getValue() : (psiClass2 = null);
            if (psiClass2 == null) {
                boolean bl = false;
                HintManager.getInstance().showErrorHint(editor, DevKitBundle.message("extension.point.analyzer.analyze.xml.no.implementation.language.extension.point", new Object[0]));
                return;
            }
            effectiveClass = psiClass2;
        }
        PsiField psiField = ExtensionPointUsageAnalyzerKt.findEPField(effectiveClass, effectiveClass);
        if (psiField == null) {
            boolean bl = false;
            HintManager.getInstance().showErrorHint(editor, DevKitBundle.message("extension.point.analyzer.analyze.xml.no.extension.point.name.field", new Object[0]));
            return;
        }
        PsiField epField = psiField;
        PsiElement $this$toUElementOfType$iv = (PsiElement)epField;
        boolean $i$f$toUElementOfType = false;
        UField uField = (UField)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UField.class);
        if (uField == null) {
            return;
        }
        UField epUField = uField;
        ExtensionPointUsageAnalyzerKt.analyzeEPFieldUsages(epUField, file, editor, domElement.getEffectiveQualifiedName(), ignoreSafeClasses);
    }

    private static final void batchAnalyzeEPTagUsages(XmlTag xmlTag, PsiFile file, Editor editor, boolean ignoreSafeClasses) {
        ExtensionPoints domElement;
        DomElement domElement2 = DomManager.getDomManager((Project)file.getProject()).getDomElement(xmlTag);
        ExtensionPoints extensionPoints2 = domElement = domElement2 instanceof ExtensionPoints ? (ExtensionPoints)domElement2 : null;
        if (domElement == null) {
            HintManager.getInstance().showErrorHint(editor, DevKitBundle.message("extension.point.analyzer.analyze.xml.batch.not.extension.points", new Object[0]));
            return;
        }
        List safeEPs = new ArrayList();
        List allUnsafeUsages = new ArrayList();
        Project project = file.getProject();
        String string = DevKitBundle.message("extension.point.analyzer.analyze.xml.batch.title", new Object[0]);
        Task.Backgroundable task2 = new Task.Backgroundable(domElement, allUnsafeUsages, file, ignoreSafeClasses, safeEPs, project, string){
            final /* synthetic */ ExtensionPoints $domElement;
            final /* synthetic */ List<EPElementUsage> $allUnsafeUsages;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ boolean $ignoreSafeClasses;
            final /* synthetic */ List<ExtensionPoint> $safeEPs;
            {
                this.$domElement = $domElement;
                this.$allUnsafeUsages = $allUnsafeUsages;
                this.$file = $file;
                this.$ignoreSafeClasses = $ignoreSafeClasses;
                this.$safeEPs = $safeEPs;
                super($super_call_param$1, $super_call_param$2);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Object object = ActionsKt.runReadAction((Function0)((Function0)new Function0<List<? extends ExtensionPoint>>(this.$domElement){
                    final /* synthetic */ ExtensionPoints $domElement;
                    {
                        this.$domElement = $domElement;
                        super(0);
                    }

                    @NotNull
                    public final List<? extends ExtensionPoint> invoke() {
                        return this.$domElement.getExtensionPoints();
                    }
                }));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"domElement = DomManager.\u2026Element.extensionPoints }");
                List extensionPoints2 = (List)object;
                for (ExtensionPoint extensionPoint : extensionPoints2) {
                    ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(extensionPoint, indicator, this.$allUnsafeUsages, this.$file, this.$ignoreSafeClasses, this.$safeEPs){
                        final /* synthetic */ ExtensionPoint $extensionPoint;
                        final /* synthetic */ ProgressIndicator $indicator;
                        final /* synthetic */ List<EPElementUsage> $allUnsafeUsages;
                        final /* synthetic */ PsiFile $file;
                        final /* synthetic */ boolean $ignoreSafeClasses;
                        final /* synthetic */ List<ExtensionPoint> $safeEPs;
                        {
                            this.$extensionPoint = $extensionPoint;
                            this.$indicator = $indicator;
                            this.$allUnsafeUsages = $allUnsafeUsages;
                            this.$file = $file;
                            this.$ignoreSafeClasses = $ignoreSafeClasses;
                            this.$safeEPs = $safeEPs;
                            super(0);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke() {
                            if (this.$extensionPoint.getDynamic().getValue() != null) {
                                return;
                            }
                            this.$indicator.setText(this.$extensionPoint.getEffectiveQualifiedName());
                            XmlAttributeValue xmlAttributeValue = this.$extensionPoint.getName().getXmlAttributeValue();
                            if (xmlAttributeValue == null) {
                                return;
                            }
                            XmlAttributeValue epName = xmlAttributeValue;
                            if (!ReferencesSearch.search((PsiElement)((PsiElement)epName)).anyMatch(arg_0 -> batchAnalyzeEPTagUsages.task.run.1.invoke$lambda$0(batchAnalyzeEPTagUsages.task.run.1.INSTANCE, arg_0))) {
                                System.out.println((Object)("Skipping EP with no extensions in plugins: " + this.$extensionPoint.getEffectiveQualifiedName()));
                                return;
                            }
                            PsiClass psiClass = this.$extensionPoint.getEffectiveClass();
                            if (psiClass == null) {
                                return;
                            }
                            PsiClass effectiveClass = psiClass;
                            PsiField epField = ExtensionPointUsageAnalyzerKt.access$findEPField(effectiveClass, effectiveClass);
                            if (epField == null) {
                                PsiElement psiElement = (PsiElement)effectiveClass;
                                String string = DevKitBundle.message("extension.point.analyzer.reason.no.ep.field", new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"extension.point\u2026yzer.reason.no.ep.field\")");
                                this.$allUnsafeUsages.add(new EPElementUsage(psiElement, string));
                                return;
                            }
                            Project project = this.$file.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
                            LeakSearchContext context = new LeakSearchContext(project, this.$extensionPoint.getEffectiveQualifiedName(), this.$ignoreSafeClasses);
                            context.processEPFieldUsages((PsiElement)epField);
                            if (!((Collection)context.getSafeUsages()).isEmpty() && context.getUnsafeUsages().isEmpty()) {
                                ExtensionPoint extensionPoint = this.$extensionPoint;
                                Intrinsics.checkNotNullExpressionValue((Object)extensionPoint, (String)"extensionPoint");
                                this.$safeEPs.add(extensionPoint);
                            } else {
                                void $this$mapTo$iv;
                                Iterable iterable = context.getUnsafeUsages();
                                Collection destination$iv = this.$allUnsafeUsages;
                                boolean $i$f$mapTo = false;
                                for (T item$iv : $this$mapTo$iv) {
                                    void it;
                                    Pair pair = (Pair)item$iv;
                                    Collection collection = destination$iv;
                                    boolean bl = false;
                                    PsiElement psiElement = ((Leak)it.getSecond()).getTargetElement();
                                    if (psiElement == null) {
                                        PsiElement psiElement2 = ((PsiReference)it.getFirst()).getElement();
                                        psiElement = psiElement2;
                                        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"it.first.element");
                                    }
                                    collection.add(new EPElementUsage(psiElement, ((Leak)it.getSecond()).getReason()));
                                }
                            }
                        }

                        private static final boolean invoke$lambda$0(Function1 $tmp0, Object p0) {
                            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                            return (Boolean)$tmp0.invoke(p0);
                        }
                    }));
                }
                ApplicationManager.getApplication().invokeLater(() -> batchAnalyzeEPTagUsages.task.1.run$lambda$2(this.$file, this.$safeEPs, this.$allUnsafeUsages));
            }

            /*
             * WARNING - void declaration
             */
            private static final void run$lambda$2(PsiFile $file, List $safeEPs, List $allUnsafeUsages) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv;
                Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
                Intrinsics.checkNotNullParameter((Object)$safeEPs, (String)"$safeEPs");
                Intrinsics.checkNotNullParameter((Object)$allUnsafeUsages, (String)"$allUnsafeUsages");
                Project project = $file.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
                String string = DevKitBundle.message("extension.point.analyzer.usage.safe.eps", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"extension.point.analyzer.usage.safe.eps\")");
                Iterable iterable = $safeEPs;
                UsageTarget usageTarget = new DummyUsageTarget(string);
                Project project2 = project;
                boolean $i$f$mapNotNull = false;
                void var5_7 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                XmlElement xmlElement = $this$forEach$iv$iv$iv.iterator();
                while (xmlElement.hasNext()) {
                    XmlElement it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = xmlElement.next();
                    boolean bl = false;
                    ExtensionPoint it = (ExtensionPoint)element$iv$iv;
                    boolean bl2 = false;
                    if (it.getXmlElement() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Collection<EPElementUsage> collection = (List)destination$iv$iv;
                $this$mapNotNull$iv = collection;
                boolean $i$f$map = false;
                $this$mapNotNullTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    xmlElement = (XmlElement)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    collection.add(new EPElementUsage((PsiElement)it, null, 2, null));
                }
                collection = (List)destination$iv$iv;
                ExtensionPointUsageAnalyzerKt.access$showEPElementUsages(project2, usageTarget, (List)collection);
                Project project3 = $file.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"file.project");
                String string2 = DevKitBundle.message("extension.point.analyzer.usage.unsafe.eps", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"extension.point\u2026alyzer.usage.unsafe.eps\")");
                ExtensionPointUsageAnalyzerKt.access$showEPElementUsages(project3, new DummyUsageTarget(string2), $allUnsafeUsages);
            }
        };
        ProgressManager.getInstance().run((Task)task2);
    }

    private static final PsiField findEPField(PsiClass effectiveClass, PsiClass epClass) {
        PsiField epField;
        boolean bl;
        PsiField it;
        block4: {
            PsiField psiField;
            PsiField[] fields;
            PsiField[] psiFieldArray = effectiveClass.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"effectiveClass.fields");
            PsiField[] objectArray = fields = psiFieldArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                PsiField psiField2;
                it = psiField2 = objectArray[i];
                bl = false;
                if (!ExtensionPointUsageAnalyzerKt.isEPField(it, epClass)) continue;
                psiField = psiField2;
                break block4;
            }
            psiField = epField = null;
        }
        if (epField != null) {
            return epField;
        }
        PsiClass[] psiClassArray = effectiveClass.getInnerClasses();
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"effectiveClass.innerClasses");
        for (Object object : (Object[])psiClassArray) {
            it = (PsiClass)object;
            bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            PsiField nestedField = ExtensionPointUsageAnalyzerKt.findEPField((PsiClass)it, epClass);
            if (nestedField != null) {
                return nestedField;
            }
            if (false) break;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isInPluginModule(PsiElement element) {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return false;
        }
        Module module2 = module;
        String string = module2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.name");
        if (StringsKt.startsWith$default((String)string, (String)"intellij.platform", (boolean)false, (int)2, null)) return false;
        String string2 = module2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"module.name");
        if (StringsKt.startsWith$default((String)string2, (String)"intellij.clion", (boolean)false, (int)2, null)) return false;
        String string3 = module2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"module.name");
        if (StringsKt.startsWith$default((String)string3, (String)"intellij.appcode", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public static final /* synthetic */ QualifiedCall access$findQualifiedCall(UElement element) {
        return ExtensionPointUsageAnalyzerKt.findQualifiedCall(element);
    }

    public static final /* synthetic */ void access$analyze(PsiElement elementAtCaret, PsiFile file, Editor editor, boolean ignoreSafeClasses) {
        ExtensionPointUsageAnalyzerKt.analyze(elementAtCaret, file, editor, ignoreSafeClasses);
    }

    public static final /* synthetic */ void access$showEPElementUsages(Project project, UsageTarget usageTarget, List usages) {
        ExtensionPointUsageAnalyzerKt.showEPElementUsages(project, usageTarget, usages);
    }

    public static final /* synthetic */ boolean access$isInPluginModule(PsiElement element) {
        return ExtensionPointUsageAnalyzerKt.isInPluginModule(element);
    }

    public static final /* synthetic */ PsiField access$findEPField(PsiClass effectiveClass, PsiClass epClass) {
        return ExtensionPointUsageAnalyzerKt.findEPField(effectiveClass, epClass);
    }
}

