/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.impl.PluginPsiClassConverter;
import org.jetbrains.idea.devkit.inspections.PluginXmlDomInspection;
import org.jetbrains.idea.devkit.util.PsiUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001!B5\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019J\u0012\u0010 \u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/idea/devkit/inspections/ComponentModuleRegistrationChecker;", "", "moduleToModuleSet", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "", "", "Lorg/jetbrains/idea/devkit/inspections/PluginXmlDomInspection$PluginModuleSet;", "ignoredClasses", "", "annotationHolder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "(Lcom/intellij/util/concurrency/SynchronizedClearableLazy;Ljava/util/List;Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;)V", "checkProperModule", "", "extensionPoint", "Lorg/jetbrains/idea/devkit/dom/ExtensionPoint;", "checkProperXmlFileForClass", "", "element", "Lcom/intellij/util/xml/DomElement;", "psiClass", "Lcom/intellij/psi/PsiClass;", "checkProperXmlFileForExtension", "Lorg/jetbrains/idea/devkit/dom/Extension;", "findMatchingImplModule", "Lcom/intellij/openapi/module/Module;", "module", "findModulePluginXmlFile", "Lcom/intellij/psi/xml/XmlFile;", "getExtensionPointClass", "Lcom/intellij/psi/PsiElement;", "isIdeaPlatformModule", "shouldCheckExtensionPointClassAttribute", "MoveRegistrationQuickFix", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nComponentModuleRegistrationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComponentModuleRegistrationChecker.kt\norg/jetbrains/idea/devkit/inspections/ComponentModuleRegistrationChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,234:1\n1#2:235\n13579#3,2:236\n*S KotlinDebug\n*F\n+ 1 ComponentModuleRegistrationChecker.kt\norg/jetbrains/idea/devkit/inspections/ComponentModuleRegistrationChecker\n*L\n122#1:236,2\n*E\n"})
public final class ComponentModuleRegistrationChecker {
    @NotNull
    private final SynchronizedClearableLazy<Map<String, PluginXmlDomInspection.PluginModuleSet>> moduleToModuleSet;
    @NotNull
    private final List<String> ignoredClasses;
    @NotNull
    private final DomElementAnnotationHolder annotationHolder;

    public ComponentModuleRegistrationChecker(@NotNull SynchronizedClearableLazy<Map<String, PluginXmlDomInspection.PluginModuleSet>> moduleToModuleSet, @NotNull List<String> ignoredClasses, @NotNull DomElementAnnotationHolder annotationHolder) {
        Intrinsics.checkNotNullParameter(moduleToModuleSet, (String)"moduleToModuleSet");
        Intrinsics.checkNotNullParameter(ignoredClasses, (String)"ignoredClasses");
        Intrinsics.checkNotNullParameter((Object)annotationHolder, (String)"annotationHolder");
        this.moduleToModuleSet = moduleToModuleSet;
        this.ignoredClasses = ignoredClasses;
        this.annotationHolder = annotationHolder;
    }

    public final void checkProperModule(@NotNull ExtensionPoint extensionPoint) {
        block2: {
            Module module;
            Intrinsics.checkNotNullParameter((Object)extensionPoint, (String)"extensionPoint");
            PsiClass effectiveEpClass = extensionPoint.getEffectiveClass();
            if (this.shouldCheckExtensionPointClassAttribute(effectiveEpClass) && this.checkProperXmlFileForClass(extensionPoint, effectiveEpClass)) {
                return;
            }
            String string = extensionPoint.getEffectiveQualifiedName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extensionPoint.effectiveQualifiedName");
            String shortName = StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null);
            Module module2 = module = extensionPoint.getModule();
            Intrinsics.checkNotNull((Object)module2);
            Project project = module2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module!!.project");
            Project project2 = project;
            PsiSearchHelper psiSearchHelper = PsiSearchHelper.getInstance((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)psiSearchHelper, (String)"getInstance(project)");
            PsiSearchHelper psiSearchHelper2 = psiSearchHelper;
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(project)");
            GlobalSearchScope scope = globalSearchScope;
            if (psiSearchHelper2.isCheapEnoughToSearch(shortName, scope, null, null) != PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES) break block2;
            Ref.ObjectRef extensionPointClass = new Ref.ObjectRef();
            psiSearchHelper2.processElementsWithWord((arg_0, arg_1) -> ComponentModuleRegistrationChecker.checkProperModule$lambda$0(extensionPointClass, this, arg_0, arg_1), (SearchScope)scope, shortName, (short)4, true, false);
            PsiClass psiClass = (PsiClass)extensionPointClass.element;
            if (psiClass != null) {
                PsiClass it = psiClass;
                boolean bl = false;
                this.checkProperXmlFileForClass(extensionPoint, it);
            }
        }
    }

    private final PsiClass getExtensionPointClass(PsiElement element) {
        PsiField psiField = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
        if (psiField == null) {
            return null;
        }
        PsiField epName = psiField;
        PsiType psiType = epName.getType();
        PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        if (psiClassType == null || (psiClassType = psiClassType.resolve()) == null) {
            return null;
        }
        PsiClassType psiClass = psiClassType;
        if (Intrinsics.areEqual((Object)psiClass.getQualifiedName(), (Object)"com.intellij.openapi.extensions.ExtensionPointName")) {
            return epName.getContainingClass();
        }
        return null;
    }

    public final void checkProperXmlFileForExtension(@NotNull Extension element) {
        CharSequence beanClass;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Iterator iterator = element.getXmlTag().getAttributeValue("language");
        if (!(iterator == null || iterator.length() == 0)) {
            GenericAttributeValue<PsiClass> genericAttributeValue = element.getExtensionPoint();
            Object object = genericAttributeValue != null && (genericAttributeValue = genericAttributeValue.getBeanClass()) != null ? (PsiClass)genericAttributeValue.getValue() : (beanClass = null);
            if (beanClass != null && InheritanceUtil.isInheritor((PsiClass)beanClass, (String)"com.intellij.lang.LanguageExtensionPoint")) {
                return;
            }
        }
        if (!((beanClass = (CharSequence)element.getXmlTag().getAttributeValue("filetype")) == null || beanClass.length() == 0)) {
            GenericAttributeValue<PsiClass> genericAttributeValue = element.getExtensionPoint();
            Object object = genericAttributeValue != null && (genericAttributeValue = genericAttributeValue.getBeanClass()) != null ? (PsiClass)genericAttributeValue.getValue() : (beanClass = null);
            if (beanClass != null && InheritanceUtil.isInheritor((PsiClass)beanClass, (String)"com.intellij.openapi.fileTypes.FileTypeExtensionPoint")) {
                return;
            }
        }
        for (DomAttributeChildDescription attributeDescription : element.getGenericInfo().getAttributeChildrenDescriptions()) {
            PsiClass psiClass;
            GenericAttributeValue attributeValue;
            String attributeName = attributeDescription.getName();
            if (Intrinsics.areEqual((Object)attributeName, (Object)"forClass") || Intrinsics.areEqual((Object)attributeName, (Object)"serviceInterface") && Intrinsics.areEqual((Object)element.getXmlTag().getAttributeValue("overrides"), (Object)"true") || (attributeValue = attributeDescription.getDomAttributeValue((DomElement)element)) == null || !DomUtil.hasXml((DomElement)((DomElement)attributeValue)) || !(attributeValue.getConverter() instanceof PluginPsiClassConverter) || (PsiClass)attributeValue.getValue() == null || !this.checkProperXmlFileForClass(element, psiClass)) continue;
            return;
        }
        for (DomFixedChildDescription childDescription : element.getGenericInfo().getFixedChildrenDescriptions()) {
            Project project;
            XmlTag tag;
            DomElement domElement;
            List list = childDescription.getValues((DomElement)element);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"childDescription.getValues(element)");
            if ((DomElement)CollectionsKt.firstOrNull((List)list) == null || domElement.getXmlTag() == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)tag.getProject(), (String)"tag.project");
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(tag.getValue().getText(), GlobalSearchScope.projectScope((Project)project));
            if (psiClass == null || !this.checkProperXmlFileForClass(element, psiClass)) continue;
            return;
        }
    }

    private final boolean shouldCheckExtensionPointClassAttribute(PsiClass psiClass) {
        block1: {
            PsiField[] psiFieldArray = psiClass;
            if (psiClass == null || (psiFieldArray = psiFieldArray.getFields()) == null) break block1;
            PsiField[] $this$forEach$iv = psiFieldArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                PsiField element$iv;
                PsiField field = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (!TypeUtils.typeEquals((String)ExtensionPointName.class.getCanonicalName(), (PsiType)field.getType())) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean checkProperXmlFileForClass(@NotNull DomElement element, @Nullable PsiClass psiClass) {
        MoveRegistrationQuickFix moveRegistrationQuickFix;
        Module implModule;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (psiClass == null) {
            return false;
        }
        if (CollectionsKt.contains((Iterable)this.ignoredClasses, (Object)psiClass.getQualifiedName())) {
            return false;
        }
        PsiClass it = psiClass;
        boolean bl = false;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)it));
        if (module == null) {
            return false;
        }
        Module definingModule = module;
        Module elementModule = element.getModule();
        if (elementModule == null || Intrinsics.areEqual((Object)definingModule, (Object)elementModule)) {
            return false;
        }
        PluginXmlDomInspection.PluginModuleSet definingPlugin = (PluginXmlDomInspection.PluginModuleSet)((Map)this.moduleToModuleSet.getValue()).get(definingModule.getName());
        PluginXmlDomInspection.PluginModuleSet elementPlugin = (PluginXmlDomInspection.PluginModuleSet)((Map)this.moduleToModuleSet.getValue()).get(elementModule.getName());
        if (definingPlugin != null && definingPlugin == elementPlugin) {
            return false;
        }
        Module pluginXmlModule = definingModule;
        XmlFile modulePluginXmlFile = this.findModulePluginXmlFile(pluginXmlModule);
        if (modulePluginXmlFile == null && (implModule = this.findMatchingImplModule(pluginXmlModule)) != null) {
            pluginXmlModule = implModule;
            modulePluginXmlFile = this.findModulePluginXmlFile(implModule);
        }
        if (modulePluginXmlFile != null) {
            String string = modulePluginXmlFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"modulePluginXmlFile.name");
            moveRegistrationQuickFix = new MoveRegistrationQuickFix(pluginXmlModule, string);
        } else {
            moveRegistrationQuickFix = null;
        }
        MoveRegistrationQuickFix fix = moveRegistrationQuickFix;
        Object[] objectArray = new Object[]{definingModule.getName(), psiClass.getQualifiedName()};
        String string = DevKitBundle.message("inspections.plugin.xml.ComponentModuleRegistrationChecker.element.registered.wrong.module", objectArray);
        objectArray = LocalQuickFix.notNullElements((LocalQuickFix)fix);
        this.annotationHolder.createProblem(element, ProblemHighlightType.WARNING, string, null, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
        return true;
    }

    public final boolean isIdeaPlatformModule(@Nullable Module module) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (module == null || !PsiUtil.isIdeaProject(module.getProject())) {
            return false;
        }
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module).getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getInstance(module).contentRoots");
        VirtualFile[] contentRoots = virtualFileArray;
        if (contentRoots.length == 0) {
            return false;
        }
        for (VirtualFile parent = contentRoots[0].getParent(); parent != null; parent = parent.getParent()) {
            if (Intrinsics.areEqual((Object)parent.getName(), (Object)"plugins")) {
                return false;
            }
            if (parent.findChild(".idea") == null) continue;
            return true;
        }
        return true;
    }

    private final Module findMatchingImplModule(Module module) {
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        return ModuleManager.Companion.getInstance(project).findModuleByName(module.getName() + ".impl");
    }

    private final XmlFile findModulePluginXmlFile(Module module) {
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module).getSourceRoots(false);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getInstance(module).getSourceRoots(false)");
        for (VirtualFile sourceRoot : virtualFileArray) {
            VirtualFile[] virtualFileArray2;
            VirtualFile metaInf = sourceRoot.findChild("META-INF");
            if (metaInf == null || !metaInf.isDirectory()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)metaInf.getChildren(), (String)"metaInf.children");
            for (VirtualFile file : virtualFileArray2) {
                PsiFile psiFile;
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                if (!StringsKt.endsWith$default((String)string, (String)"Plugin.xml", (boolean)false, (int)2, null) || !((psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(file)) instanceof XmlFile)) continue;
                return (XmlFile)psiFile;
            }
        }
        return null;
    }

    private static final boolean checkProperModule$lambda$0(Ref.ObjectRef $extensionPointClass, ComponentModuleRegistrationChecker this$0, PsiElement element, int n) {
        Intrinsics.checkNotNullParameter((Object)$extensionPointClass, (String)"$extensionPointClass");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        $extensionPointClass.element = this$0.getExtensionPointClass(element);
        return $extensionPointClass.element == null;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0017J\b\u0010\u0011\u001a\u00020\u0005H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/idea/devkit/inspections/ComponentModuleRegistrationChecker$MoveRegistrationQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "myTargetModule", "Lcom/intellij/openapi/module/Module;", "myTargetFileName", "", "(Lorg/jetbrains/idea/devkit/inspections/ComponentModuleRegistrationChecker;Lcom/intellij/openapi/module/Module;Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "getFamilyName", "getName", "intellij.devkit.core"})
    @SourceDebugExtension(value={"SMAP\nComponentModuleRegistrationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComponentModuleRegistrationChecker.kt\norg/jetbrains/idea/devkit/inspections/ComponentModuleRegistrationChecker$MoveRegistrationQuickFix\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,234:1\n2298#2,5:235\n1#3:240\n*S KotlinDebug\n*F\n+ 1 ComponentModuleRegistrationChecker.kt\norg/jetbrains/idea/devkit/inspections/ComponentModuleRegistrationChecker$MoveRegistrationQuickFix\n*L\n228#1:235,5\n*E\n"})
    public final class MoveRegistrationQuickFix
    implements LocalQuickFix {
        @NotNull
        private final Module myTargetModule;
        @NotNull
        private final String myTargetFileName;

        public MoveRegistrationQuickFix(@NotNull Module myTargetModule, String myTargetFileName) {
            Intrinsics.checkNotNullParameter((Object)myTargetModule, (String)"myTargetModule");
            Intrinsics.checkNotNullParameter((Object)myTargetFileName, (String)"myTargetFileName");
            this.myTargetModule = myTargetModule;
            this.myTargetFileName = myTargetFileName;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }

        @Nls
        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.myTargetFileName};
            String string = DevKitBundle.message("inspections.plugin.xml.ComponentModuleRegistrationChecker.fix.move.registration.name", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"inspections.plu\u2026.name\", myTargetFileName)");
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = DevKitBundle.message("inspections.plugin.xml.ComponentModuleRegistrationChecker.fix.move.registration.family.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"inspections.plu\u2026egistration.family.name\")");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            block15: {
                XmlTag xmlTag;
                XmlTag tag;
                block14: {
                    XmlTag newParentTag;
                    block13: {
                        XmlTag anchor;
                        Object object;
                        block12: {
                            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                            XmlTag xmlTag2 = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), XmlTag.class, (boolean)false);
                            if (xmlTag2 == null) {
                                return;
                            }
                            tag = xmlTag2;
                            XmlTag xmlTag3 = tag.getParentTag();
                            if (xmlTag3 == null) {
                                return;
                            }
                            XmlTag parentTag = xmlTag3;
                            XmlFile xmlFile = ComponentModuleRegistrationChecker.this.findModulePluginXmlFile(this.myTargetModule);
                            if (xmlFile == null) {
                                return;
                            }
                            XmlFile targetFile = xmlFile;
                            XmlTag xmlTag4 = targetFile.getRootTag();
                            if (xmlTag4 == null) {
                                return;
                            }
                            XmlTag rootTag = xmlTag4;
                            XmlTag xmlTag5 = tag.getParentTag();
                            Intrinsics.checkNotNull((Object)xmlTag5);
                            Object[] objectArray = rootTag.findSubTags(xmlTag5.getName());
                            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"rootTag.findSubTags(tag.parentTag!!.name)");
                            Object[] subTags = objectArray;
                            XmlTag xmlTag6 = (XmlTag)ArraysKt.firstOrNull((Object[])subTags);
                            if (xmlTag6 == null) {
                                XmlTag xmlTag7;
                                XmlTag $this$applyFix_u24lambda_u240 = xmlTag7 = rootTag.addSubTag(rootTag.createChildTag(parentTag.getLocalName(), "", null, false), false);
                                boolean bl = false;
                                XmlAttribute[] xmlAttributeArray = parentTag.getAttributes();
                                Intrinsics.checkNotNullExpressionValue((Object)xmlAttributeArray, (String)"parentTag.attributes");
                                for (XmlAttribute attribute : xmlAttributeArray) {
                                    $this$applyFix_u24lambda_u240.setAttribute(attribute.getName(), attribute.getValue());
                                }
                                xmlTag6 = xmlTag7;
                            }
                            newParentTag = xmlTag6;
                            XmlTag[] xmlTagArray = newParentTag.getSubTags();
                            Intrinsics.checkNotNullExpressionValue((Object)xmlTagArray, (String)"newParentTag.subTags");
                            Object[] $this$lastOrNull$iv = xmlTagArray;
                            boolean $i$f$lastOrNull = false;
                            int n = $this$lastOrNull$iv.length + -1;
                            if (0 <= n) {
                                do {
                                    int index$iv = n--;
                                    Object element$iv = $this$lastOrNull$iv[index$iv];
                                    XmlTag it = (XmlTag)element$iv;
                                    boolean bl = false;
                                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)tag.getName())) continue;
                                    object = element$iv;
                                    break block12;
                                } while (0 <= n);
                            }
                            object = null;
                        }
                        if ((xmlTag = (anchor = (XmlTag)object)) == null) break block13;
                        XmlTag it = xmlTag;
                        boolean bl = false;
                        PsiElement psiElement = newParentTag.addAfter((PsiElement)tag, (PsiElement)anchor);
                        xmlTag = psiElement;
                        if (psiElement != null) break block14;
                    }
                    xmlTag = (PsiElement)newParentTag.addSubTag(tag, false);
                }
                XmlTag newTag = xmlTag;
                tag.delete();
                Navigatable navigatable = newTag instanceof Navigatable ? (Navigatable)newTag : null;
                if (navigatable == null) break block15;
                navigatable.navigate(true);
            }
        }
    }
}

