/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.uast.UastHintedVisitorAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.VisitorProviders;
import org.jetbrains.idea.devkit.util.BlockingContextInspectionsKt;
import org.jetbrains.idea.devkit.util.QuickFixWithReferenceToElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0005\t\n\u000b\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/devkit/inspections/CallingMethodShouldBeRequiresBlockingContextInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "AnnotateFix", "MethodBodyVisitor", "MethodVisitor", "VisitorProvider", "VisitorProviderForJava", "intellij.devkit.core"})
public final class CallingMethodShouldBeRequiresBlockingContextInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (BlockingContextInspectionsKt.isInspectionForBlockingContextAvailable(holder)) {
            Language language = holder.getFile().getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"holder.file.language");
            Class[] classArray = new Class[]{UMethod.class};
            psiElementVisitor = UastHintedVisitorAdapter.Companion.create$default((UastHintedVisitorAdapter.Companion)UastHintedVisitorAdapter.Companion, (Language)language, (AbstractUastNonRecursiveVisitor)new MethodVisitor(holder), (Class[])classArray, (boolean)false, (int)8, null);
        } else {
            PsiElementVisitor psiElementVisitor2 = PsiElementVisitor.EMPTY_VISITOR;
            psiElementVisitor = psiElementVisitor2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor2, (String)"{\n      PsiElementVisitor.EMPTY_VISITOR\n    }");
        }
        return psiElementVisitor;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J3\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0096\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/devkit/inspections/CallingMethodShouldBeRequiresBlockingContextInspection$AnnotateFix;", "Lorg/jetbrains/idea/devkit/util/QuickFixWithReferenceToElement;", "Lcom/intellij/psi/PsiMethod;", "element", "Lcom/intellij/psi/PsiElement;", "method", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiMethod;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "endElement", "intellij.devkit.core"})
    private static final class AnnotateFix
    extends QuickFixWithReferenceToElement<PsiMethod> {
        public AnnotateFix(@NotNull PsiElement element, @NotNull PsiMethod method) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            super(element, (PsiElement)method);
        }

        @NotNull
        public String getFamilyName() {
            String string = DevKitBundle.message("inspections.calling.method.should.be.rbc.annotated.annotate.fix", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"inspections.cal\u2026.annotated.annotate.fix\")");
            return string;
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            String string = BlockingContextInspectionsKt.getREQUIRES_BLOCKING_CONTEXT_ANNOTATION();
            PsiElement psiElement = this.getReferencedElement().getElement();
            Intrinsics.checkNotNull((Object)psiElement);
            new AddAnnotationFix(string, (PsiModifierListOwner)psiElement, new String[0]).applyFix();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/idea/devkit/inspections/CallingMethodShouldBeRequiresBlockingContextInspection$MethodBodyVisitor;", "Lcom/intellij/psi/JavaRecursiveElementWalkingVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "currentMethod", "Lcom/intellij/psi/PsiMethod;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/psi/PsiMethod;)V", "visitCallExpression", "", "callExpression", "Lcom/intellij/psi/PsiCallExpression;", "visitClass", "aClass", "Lcom/intellij/psi/PsiClass;", "visitLambdaExpression", "expression", "Lcom/intellij/psi/PsiLambdaExpression;", "visitMethod", "method", "intellij.devkit.core"})
    private static final class MethodBodyVisitor
    extends JavaRecursiveElementWalkingVisitor {
        @NotNull
        private final ProblemsHolder holder;
        @NotNull
        private final PsiMethod currentMethod;

        public MethodBodyVisitor(@NotNull ProblemsHolder holder, @NotNull PsiMethod currentMethod) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)currentMethod, (String)"currentMethod");
            this.holder = holder;
            this.currentMethod = currentMethod;
        }

        public void visitCallExpression(@NotNull PsiCallExpression callExpression) {
            PsiElement psiElement;
            Object object;
            Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
            PsiMethod method = callExpression.resolveMethod();
            if (method == null || !AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)method), (String)BlockingContextInspectionsKt.getREQUIRES_BLOCKING_CONTEXT_ANNOTATION(), (int)0)) {
                super.visitCallExpression(callExpression);
                return;
            }
            PsiCallExpression psiCallExpression = callExpression;
            if (psiCallExpression instanceof PsiMethodCallExpression) {
                object = ((PsiMethodCallExpression)callExpression).getMethodExpression().getReferenceNameElement();
            } else if (psiCallExpression instanceof PsiNewExpression) {
                PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = ((PsiNewExpression)callExpression).getClassOrAnonymousClassReference();
                object = psiJavaCodeReferenceElement != null ? psiJavaCodeReferenceElement.getReferenceNameElement() : null;
            } else {
                object = psiElement = null;
            }
            if (object == null) {
                psiElement = (PsiElement)callExpression;
            }
            PsiElement elementToHighlight = psiElement;
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new AnnotateFix((PsiElement)callExpression, this.currentMethod)};
            this.holder.registerProblem(elementToHighlight, DevKitBundle.message("inspections.calling.method.should.be.rbc.annotated.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, localQuickFixArray);
        }

        public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        }

        public void visitClass(@NotNull PsiClass aClass) {
            Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
        }

        public void visitMethod(@NotNull PsiMethod method) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/idea/devkit/inspections/CallingMethodShouldBeRequiresBlockingContextInspection$MethodVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "visitMethod", "", "node", "Lorg/jetbrains/uast/UMethod;", "intellij.devkit.core"})
    private static final class MethodVisitor
    extends AbstractUastNonRecursiveVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public MethodVisitor(@NotNull ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        public boolean visitMethod(@NotNull UMethod node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiElement psiElement = node.getSourcePsi();
            if (psiElement == null) {
                return true;
            }
            PsiElement psiElementForMethod = psiElement;
            UExpression uExpression = node.getUastBody();
            if (uExpression == null || (uExpression = uExpression.getSourcePsi()) == null) {
                return true;
            }
            UExpression bodyPsi = uExpression;
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)node.getJavaPsi()), (String)BlockingContextInspectionsKt.getREQUIRES_BLOCKING_CONTEXT_ANNOTATION(), (int)1)) {
                VisitorProvider visitorProvider = (VisitorProvider)VisitorProviders.INSTANCE.forLanguage(psiElementForMethod.getLanguage());
                if (visitorProvider == null || (visitorProvider = visitorProvider.provideVisitorForBody(psiElementForMethod, this.holder)) == null) {
                    return true;
                }
                VisitorProvider visitor = visitorProvider;
                bodyPsi.accept((PsiElementVisitor)visitor);
            }
            return true;
        }
    }

    @IntellijInternalApi
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/idea/devkit/inspections/CallingMethodShouldBeRequiresBlockingContextInspection$VisitorProvider;", "", "provideVisitorForBody", "Lcom/intellij/psi/PsiElementVisitor;", "method", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "intellij.devkit.core"})
    @ApiStatus.Internal
    public static interface VisitorProvider {
        @Nullable
        public PsiElementVisitor provideVisitorForBody(@NotNull PsiElement var1, @NotNull ProblemsHolder var2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/idea/devkit/inspections/CallingMethodShouldBeRequiresBlockingContextInspection$VisitorProviderForJava;", "Lorg/jetbrains/idea/devkit/inspections/CallingMethodShouldBeRequiresBlockingContextInspection$VisitorProvider;", "()V", "provideVisitorForBody", "Lcom/intellij/psi/PsiElementVisitor;", "method", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "intellij.devkit.core"})
    public static final class VisitorProviderForJava
    implements VisitorProvider {
        @Override
        @Nullable
        public PsiElementVisitor provideVisitorForBody(@NotNull PsiElement method, @NotNull ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            PsiMethod psiMethod = method instanceof PsiMethod ? (PsiMethod)method : null;
            if (psiMethod == null) {
                return null;
            }
            PsiMethod javaMethod = psiMethod;
            return (PsiElementVisitor)new MethodBodyVisitor(holder, javaMethod);
        }
    }
}

