/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.idea.devkit.inspections.LevelType;
import org.jetbrains.idea.devkit.inspections.ServiceUtil;
import org.jetbrains.idea.devkit.inspections.quickfix.AppServiceAsStaticFinalFieldFixProvider;
import org.jetbrains.idea.devkit.inspections.quickfix.AppServiceAsStaticFinalFieldQuickFixProviders;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/devkit/inspections/ApplicationServiceAsStaticFinalFieldInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitUastInspectionBase;", "()V", "buildInternalVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isExplicitConstructorCall", "field", "Lorg/jetbrains/uast/UField;", "intellij.devkit.core"})
public final class ApplicationServiceAsStaticFinalFieldInspection
extends DevKitUastInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildInternalVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Language language = holder.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"holder.file.language");
        Class[] classArray = new Class[]{UField.class};
        return UastHintedVisitorAdapter.Companion.create$default((UastHintedVisitorAdapter.Companion)UastHintedVisitorAdapter.Companion, (Language)language, (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(this, holder){
            final /* synthetic */ ApplicationServiceAsStaticFinalFieldInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public boolean visitField(@NotNull UField node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (!node.isStatic() || !node.isFinal()) {
                    return true;
                }
                if (ApplicationServiceAsStaticFinalFieldInspection.access$isExplicitConstructorCall(this.this$0, node)) {
                    return true;
                }
                PsiElement $this$toUElementOfType$iv = (PsiElement)PsiTypesUtil.getPsiClass((PsiType)node.getType());
                boolean $i$f$toUElementOfType = false;
                UClass uClass = (UClass)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UClass.class);
                if (uClass == null) {
                    return true;
                }
                UClass fieldTypeUClass = uClass;
                Project project = this.$holder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"holder.project");
                LevelType serviceLevel = ServiceUtil.getLevelType(project, fieldTypeUClass);
                if (serviceLevel == null || !serviceLevel.isApp()) {
                    return true;
                }
                PsiElement psiElement = node.getSourcePsi();
                if (psiElement == null) {
                    return true;
                }
                PsiElement sourcePsi = psiElement;
                Object object = (AppServiceAsStaticFinalFieldFixProvider)AppServiceAsStaticFinalFieldQuickFixProviders.INSTANCE.forLanguage(this.$holder.getFile().getLanguage());
                if (object == null || (object = object.getFixes(sourcePsi)) == null) {
                    object = CollectionsKt.emptyList();
                }
                List<LocalQuickFix> fixes = object;
                UDeclaration uDeclaration = (UDeclaration)node;
                String string = DevKitBundle.message("inspections.application.service.as.static.final.field.message", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"inspections.app\u2026tic.final.field.message\")");
                Collection $this$toTypedArray$iv = fixes;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
                ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.$holder, (UDeclaration)uDeclaration, (String)string, (LocalQuickFix[])Arrays.copyOf(localQuickFixArray, localQuickFixArray.length), null, (int)8, null);
                return true;
            }
        }, (Class[])classArray, (boolean)false, (int)8, null);
    }

    private final boolean isExplicitConstructorCall(UField field) {
        UExpression initializer = field.getUastInitializer();
        return initializer instanceof UCallExpression && ((UCallExpression)initializer).hasKind(UastCallKind.CONSTRUCTOR_CALL);
    }

    public static final /* synthetic */ boolean access$isExplicitConstructorCall(ApplicationServiceAsStaticFinalFieldInspection $this, UField field) {
        return $this.isExplicitConstructorCall(field);
    }
}

