/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.i18n;

import com.intellij.codeInsight.intention.impl.config.IntentionManagerImpl;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.ResourceBundleManager;
import com.intellij.lang.properties.references.I18nUtil;
import com.intellij.notification.impl.NotificationGroupEP;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.SchemeConvertorEPBase;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.NameUtilCore;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Action;
import org.jetbrains.idea.devkit.dom.ActionOrGroup;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.OverrideText;
import org.jetbrains.idea.devkit.dom.Separator;
import org.jetbrains.idea.devkit.i18n.DevKitI18nBundle;
import org.jetbrains.idea.devkit.inspections.DevKitPluginXmlInspectionBase;
import org.jetbrains.idea.devkit.util.DescriptorI18nUtil;
import org.jetbrains.idea.devkit.util.DevKitDomUtil;
import org.jetbrains.idea.devkit.util.PluginPlatformInfo;
import org.jetbrains.uast.UExpression;

final class PluginXmlI18nInspection
extends DevKitPluginXmlInspectionBase {
    private static final Logger LOG = Logger.getInstance(PluginXmlI18nInspection.class);

    PluginXmlI18nInspection() {
    }

    protected void checkDomElement(@NotNull DomElement element, @NotNull DomElementAnnotationHolder holder, @NotNull DomHighlightingHelper helper) {
        if (element == null) {
            PluginXmlI18nInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            PluginXmlI18nInspection.$$$reportNull$$$0(1);
        }
        if (helper == null) {
            PluginXmlI18nInspection.$$$reportNull$$$0(2);
        }
        if (!this.isAllowed(holder)) {
            return;
        }
        if (element instanceof ActionOrGroup) {
            PluginXmlI18nInspection.highlightActionOrGroup(holder, (ActionOrGroup)element);
        } else if (element instanceof Separator) {
            PluginXmlI18nInspection.highlightSeparator(holder, (Separator)element);
        } else if (element instanceof OverrideText) {
            PluginXmlI18nInspection.highlightOverrideText(holder, (OverrideText)element);
        } else if (element instanceof Extension) {
            PluginXmlI18nInspection.highlightExtension(holder, (Extension)element);
        }
    }

    private static void highlightExtension(DomElementAnnotationHolder holder, Extension extension) {
        GenericAttributeValue<?> value;
        ExtensionPoint extensionPoint = extension.getExtensionPoint();
        if (extensionPoint == null) {
            return;
        }
        PsiClass beanClass = (PsiClass)extensionPoint.getBeanClass().getValue();
        if (beanClass == null) {
            return;
        }
        String epName = extensionPoint.getEffectiveQualifiedName();
        if (LocalInspectionEP.LOCAL_INSPECTION.getName().equals(epName) || InspectionEP.GLOBAL_INSPECTION.getName().equals(epName)) {
            if (PluginXmlI18nInspection.isInternal(extension, "isInternal")) {
                return;
            }
            GenericAttributeValue<?> implementationClass = DevKitDomUtil.getAttribute(extension, "implementationClass");
            if (implementationClass == null || implementationClass.getStringValue() == null) {
                return;
            }
            PluginXmlI18nInspection.checkNonLocalizableAttribute(holder, extension, "displayName", new InspectionI18NQuickFix());
            PluginXmlI18nInspection.checkNonLocalizableAttribute(holder, extension, "groupName", null);
        } else if (IntentionManagerImpl.EP_INTENTION_ACTIONS.getName().equals(epName)) {
            PluginXmlI18nInspection.checkNonLocalizableTag(holder, extension, "category", null);
        } else if (InheritanceUtil.isInheritor((PsiClass)beanClass, (String)ConfigurableEP.class.getName())) {
            PluginXmlI18nInspection.checkNonLocalizableAttribute(holder, extension, "displayName", null);
            for (DomElement nestedConfigurable : DomUtil.getDefinedChildren((DomElement)extension, (boolean)true, (boolean)false)) {
                PluginXmlI18nInspection.checkNonLocalizableAttribute(holder, nestedConfigurable, "displayName", null);
            }
        } else if (InheritanceUtil.isInheritor((PsiClass)beanClass, (String)SchemeConvertorEPBase.class.getName())) {
            PluginXmlI18nInspection.checkNonLocalizableAttribute(holder, extension, "name", null);
        } else if (NotificationGroupEP.class.getName().equals(beanClass.getQualifiedName()) && PluginXmlI18nInspection.hasMissingAttribute(extension, "key") && ((value = DevKitDomUtil.getAttribute(extension, "hideFromSettings")) == null || !Boolean.parseBoolean(value.getStringValue()))) {
            holder.createProblem((DomElement)extension, DevKitI18nBundle.message("inspections.plugin.xml.i18n.name", new Object[0]), new LocalQuickFix[]{new NotificationGroupI18NQuickFix()});
        }
    }

    private static void checkNonLocalizableAttribute(DomElementAnnotationHolder holder, DomElement element, @NonNls String attributeName, @Nullable LocalQuickFix fix) {
        PluginXmlI18nInspection.highlightNonLocalizableElement(holder, DevKitDomUtil.getAttribute(element, attributeName), attributeName, fix);
    }

    private static void checkNonLocalizableTag(DomElementAnnotationHolder holder, DomElement element, String tagName, @Nullable LocalQuickFix quickFix) {
        PluginXmlI18nInspection.highlightNonLocalizableElement(holder, DevKitDomUtil.getTag(element, tagName), tagName, quickFix);
    }

    private static void highlightNonLocalizableElement(DomElementAnnotationHolder holder, GenericDomValue<?> valueElement, @NonNls String valueElementName, @Nullable LocalQuickFix fix) {
        if (valueElement != null && valueElement.getStringValue() != null) {
            holder.createProblem(valueElement, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, DevKitI18nBundle.message("inspections.plugin.xml.i18n.inspection.tag.family.name", valueElementName), null, new LocalQuickFix[]{fix});
        }
    }

    private static void highlightSeparator(DomElementAnnotationHolder holder, Separator separator) {
        if (!DomUtil.hasXml(separator.getText())) {
            return;
        }
        BuildNumber buildNumber = PluginPlatformInfo.forDomElement((DomElement)separator).getSinceBuildNumber();
        if (buildNumber != null && buildNumber.getBaselineVersion() >= 202) {
            holder.createProblem((DomElement)separator, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, DevKitI18nBundle.message("inspections.plugin.xml.i18n.key", new Object[0]), null, new LocalQuickFix[]{new SeparatorKeyI18nQuickFix()});
        }
    }

    private static void highlightOverrideText(DomElementAnnotationHolder holder, OverrideText overrideText) {
        if (!DomUtil.hasXml(overrideText.getText())) {
            return;
        }
        DomElement parent = overrideText.getParent();
        PropertiesFile propertiesFile2 = DescriptorI18nUtil.findBundlePropertiesFile(parent);
        holder.createProblem((DomElement)overrideText, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, DevKitI18nBundle.message("inspections.plugin.xml.i18n.name", new Object[0]), null, new LocalQuickFix[]{new ActionOrGroupQuickFixAction(propertiesFile2 != null ? propertiesFile2.getVirtualFile() : null, parent instanceof Action)});
    }

    private static void highlightActionOrGroup(@NotNull DomElementAnnotationHolder holder, @NotNull ActionOrGroup actionOrGroup) {
        String id;
        if (holder == null) {
            PluginXmlI18nInspection.$$$reportNull$$$0(3);
        }
        if (actionOrGroup == null) {
            PluginXmlI18nInspection.$$$reportNull$$$0(4);
        }
        if ((id = actionOrGroup.getId().getStringValue()) == null) {
            return;
        }
        String text = actionOrGroup.getText().getStringValue();
        String desc = actionOrGroup.getDescription().getStringValue();
        if (text == null && desc == null) {
            return;
        }
        if (PluginXmlI18nInspection.isInternal(actionOrGroup, "internal")) {
            return;
        }
        PropertiesFile propertiesFile2 = DescriptorI18nUtil.findBundlePropertiesFile(actionOrGroup);
        holder.createProblem((DomElement)actionOrGroup, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, DevKitI18nBundle.message("inspections.plugin.xml.i18n.name", new Object[0]), null, new LocalQuickFix[]{new ActionOrGroupQuickFixAction(propertiesFile2 != null ? propertiesFile2.getVirtualFile() : null, actionOrGroup instanceof Action)});
    }

    private static boolean isInternal(@NotNull DomElement action, String internalAttributeName) {
        GenericAttributeValue<?> internalAttribute;
        if (action == null) {
            PluginXmlI18nInspection.$$$reportNull$$$0(5);
        }
        return (internalAttribute = DevKitDomUtil.getAttribute(action, internalAttributeName)) != null && "true".equals(internalAttribute.getStringValue());
    }

    private static void choosePropertiesFileAndExtract(Project project, List<XmlTag> tags, Consumer<String> doFixConsumer) {
        ResourceBundleManager resourceBundleManager;
        try {
            resourceBundleManager = ResourceBundleManager.getManager((Collection)ContainerUtil.map(tags, x -> x.getContainingFile()), (Project)project);
        }
        catch (ResourceBundleManager.ResourceBundleNotFoundException e) {
            resourceBundleManager = null;
        }
        @NotNull Set contextModules = ContainerUtil.map2Set(tags, x -> ModuleUtilCore.findModuleForPsiElement((PsiElement)x));
        ResourceBundleManager finalResourceBundleManager = resourceBundleManager;
        List files = (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> (List)ReadAction.compute(() -> finalResourceBundleManager != null ? finalResourceBundleManager.suggestPropertiesFiles(contextModules) : I18nUtil.defaultSuggestPropertiesFiles((Project)project, (Set)contextModules)), DevKitBundle.message("progress.title.calculate.target.properties.file", new Object[0]), true, project);
        if (files == null || files.isEmpty()) {
            return;
        }
        if (files.size() == 1) {
            doFixConsumer.accept((String)files.get(0));
            return;
        }
        IPopupChooserBuilder builder = JBPopupFactory.getInstance().createPopupChooserBuilder(files).setNamerForFiltering(x -> x).setTitle(DevKitI18nBundle.message("inspections.plugin.xml.i18n.choose.bundle.4inspections.title", new Object[0])).setItemChosenCallback(selected -> doFixConsumer.accept((String)selected));
        builder.createPopup().showCenteredInCurrentWindow(project);
    }

    @NotNull
    private static String getBundleQName(@NotNull Project project, PropertiesFile propertiesFile2) {
        String relativePath;
        if (project == null) {
            PluginXmlI18nInspection.$$$reportNull$$$0(6);
        }
        String baseName = propertiesFile2.getResourceBundle().getBaseName();
        VirtualFile virtualFile = propertiesFile2.getVirtualFile();
        VirtualFile sourceRootForFile = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(virtualFile);
        if (sourceRootForFile != null && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)sourceRootForFile, (char)'.')) != null) {
            String string = FileUtil.getNameWithoutExtension((String)relativePath);
            if (string == null) {
                PluginXmlI18nInspection.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = baseName;
        if (string == null) {
            PluginXmlI18nInspection.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static List<XmlTag> getTags(List<CommonProblemDescriptor> descriptors) {
        ArrayList<XmlTag> tags = new ArrayList<XmlTag>();
        for (CommonProblemDescriptor d : descriptors) {
            PsiElement parent;
            if (!(d instanceof ProblemDescriptor)) continue;
            PsiElement e = ((ProblemDescriptor)d).getPsiElement();
            if (e instanceof XmlTag) {
                tags.add((XmlTag)e);
                continue;
            }
            if (!(e instanceof XmlAttributeValue) || !((parent = e.getParent()) instanceof XmlAttribute)) continue;
            ContainerUtil.addIfNotNull(tags, (Object)((XmlAttribute)parent).getParent());
        }
        return tags;
    }

    @Nullable
    private static PropertiesFile findPropertiesFile(Project project, String propertiesFilePath) {
        VirtualFile propertiesVFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)propertiesFilePath));
        if (propertiesVFile != null) {
            return PropertiesImplUtil.getPropertiesFile((PsiFile)PsiManager.getInstance((Project)project).findFile(propertiesVFile));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionOrGroup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/i18n/PluginXmlI18nInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/i18n/PluginXmlI18nInspection";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundleQName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkDomElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "highlightActionOrGroup";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInternal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBundleQName";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }

    private static class InspectionI18NQuickFix
    implements LocalQuickFix,
    BatchQuickFix {
        private InspectionI18NQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = DevKitI18nBundle.message("inspections.plugin.xml.i18n.inspection.tag.family.name", "displayName");
            if (string == null) {
                InspectionI18NQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                InspectionI18NQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                InspectionI18NQuickFix.$$$reportNull$$$0(2);
            }
            PsiElement element = descriptor.getPsiElement();
            XmlTag xml = null;
            if (element instanceof XmlTag) {
                xml = (XmlTag)element;
            } else if (element instanceof XmlAttributeValue) {
                PsiElement parent = element.getParent();
                XmlTag xmlTag = xml = parent instanceof XmlAttribute ? ((XmlAttribute)parent).getParent() : null;
            }
            if (xml == null) {
                return;
            }
            InspectionI18NQuickFix.doFix(project, Collections.singletonList(xml));
        }

        public void applyFix(@NotNull Project project, CommonProblemDescriptor @NotNull [] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
            if (project == null) {
                InspectionI18NQuickFix.$$$reportNull$$$0(3);
            }
            if (psiElementsToIgnore == null) {
                InspectionI18NQuickFix.$$$reportNull$$$0(4);
            }
            if (descriptors == null) {
                InspectionI18NQuickFix.$$$reportNull$$$0(5);
            }
            InspectionI18NQuickFix.doFix(project, PluginXmlI18nInspection.getTags(Arrays.asList(descriptors)));
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static void doFix(@NotNull Project project, List<XmlTag> tags) {
            if (project == null) {
                InspectionI18NQuickFix.$$$reportNull$$$0(6);
            }
            PluginXmlI18nInspection.choosePropertiesFileAndExtract(project, tags, selection -> {
                PropertiesFile propertiesFile2 = PluginXmlI18nInspection.findPropertiesFile(project, selection);
                if (propertiesFile2 != null) {
                    ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>();
                    psiFiles.add(propertiesFile2.getContainingFile());
                    for (XmlTag tag : tags) {
                        psiFiles.add(tag.getContainingFile());
                    }
                    WriteCommandAction.runWriteCommandAction((Project)project, (String)DevKitI18nBundle.message("inspections.plugin.xml.i18n.inspection.tag.command.name", "displayName"), null, () -> {
                        for (XmlTag tag : tags) {
                            InspectionI18NQuickFix.registerPropertyKey(project, tag, propertiesFile2);
                        }
                    }, (PsiFile[])psiFiles.toArray(PsiFile.EMPTY_ARRAY));
                }
            });
        }

        private static void registerPropertyKey(@NotNull Project project, XmlTag xml, PropertiesFile propertiesFile2) {
            String displayName;
            if (project == null) {
                InspectionI18NQuickFix.$$$reportNull$$$0(7);
            }
            if ((displayName = xml.getAttributeValue("displayName")) == null) {
                return;
            }
            xml.setAttribute("displayName", null);
            String shortName = xml.getAttributeValue("shortName");
            if (shortName == null) {
                String implementationClass = xml.getAttributeValue("implementationClass");
                if (implementationClass == null) {
                    return;
                }
                shortName = InspectionProfileEntry.getShortName((String)StringUtil.getShortName((String)implementationClass));
            }
            @NonNls String key = "inspection." + StringUtil.join((Object[])NameUtilCore.splitNameIntoWords((String)shortName), s -> StringUtil.decapitalize((String)s), (String)".") + ".display.name";
            xml.setAttribute("key", key);
            XmlTag rootTag = ((XmlFile)xml.getContainingFile()).getRootTag();
            XmlTag resourceBundle = rootTag != null ? rootTag.findFirstSubTag("resource-bundle") : null;
            String bundleQName = PluginXmlI18nInspection.getBundleQName(project, propertiesFile2);
            if (resourceBundle == null || !bundleQName.equals(resourceBundle.getValue().getTrimmedText())) {
                xml.setAttribute("bundle", bundleQName);
            }
            JavaI18nUtil.DEFAULT_PROPERTY_CREATION_HANDLER.createProperty(project, Collections.singletonList(propertiesFile2), key, StringUtil.unescapeXmlEntities((String)displayName), new UExpression[0]);
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                InspectionI18NQuickFix.$$$reportNull$$$0(8);
            }
            if (previewDescriptor == null) {
                InspectionI18NQuickFix.$$$reportNull$$$0(9);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                InspectionI18NQuickFix.$$$reportNull$$$0(10);
            }
            return intentionPreviewInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/i18n/PluginXmlI18nInspection$InspectionI18NQuickFix";
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElementsToIgnore";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/i18n/PluginXmlI18nInspection$InspectionI18NQuickFix";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "registerPropertyKey";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class NotificationGroupI18NQuickFix
    implements LocalQuickFix {
        private NotificationGroupI18NQuickFix() {
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                NotificationGroupI18NQuickFix.$$$reportNull$$$0(0);
            }
            if (previewDescriptor == null) {
                NotificationGroupI18NQuickFix.$$$reportNull$$$0(1);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                NotificationGroupI18NQuickFix.$$$reportNull$$$0(2);
            }
            return intentionPreviewInfo;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = DevKitI18nBundle.message("inspections.plugin.xml.i18n.inspection.tag.family.name", "key");
            if (string == null) {
                NotificationGroupI18NQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement psiElement;
            if (project == null) {
                NotificationGroupI18NQuickFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                NotificationGroupI18NQuickFix.$$$reportNull$$$0(5);
            }
            if (!((psiElement = descriptor.getPsiElement()) instanceof XmlTag)) {
                return;
            }
            XmlTag xmlTag = (XmlTag)psiElement;
            PluginXmlI18nInspection.choosePropertiesFileAndExtract(project, Collections.singletonList(xmlTag), selection -> {
                PropertiesFile propertiesFile2 = PluginXmlI18nInspection.findPropertiesFile(project, selection);
                if (propertiesFile2 != null) {
                    WriteCommandAction.runWriteCommandAction((Project)project, (String)DevKitI18nBundle.message("inspections.plugin.xml.i18n.key.command.name", new Object[0]), null, () -> {
                        XmlAttribute bundleAttribute = xmlTag.getAttribute("bundle");
                        String bundleQName = PluginXmlI18nInspection.getBundleQName(project, propertiesFile2);
                        if (bundleAttribute == null || !bundleQName.equals(bundleAttribute.getValue())) {
                            xmlTag.setAttribute("bundle", bundleQName);
                        }
                        String escapedId = StringUtil.defaultIfEmpty((String)StringUtil.toLowerCase((String)xmlTag.getAttributeValue("id")), (String)"notification.id").replace(' ', '.');
                        String messageKey = "notification.group." + escapedId;
                        xmlTag.setAttribute("key", messageKey);
                        JavaI18nUtil.DEFAULT_PROPERTY_CREATION_HANDLER.createProperty(project, Collections.singletonList(propertiesFile2), messageKey, "", new UExpression[0]);
                        IProperty createdProperty = propertiesFile2.findPropertyByKey(messageKey);
                        if (createdProperty != null) {
                            createdProperty.navigate(true);
                        }
                    }, (PsiFile[])new PsiFile[]{psiElement.getContainingFile(), propertiesFile2.getContainingFile()});
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/i18n/PluginXmlI18nInspection$NotificationGroupI18NQuickFix";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/i18n/PluginXmlI18nInspection$NotificationGroupI18NQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class SeparatorKeyI18nQuickFix
    implements LocalQuickFix,
    BatchQuickFix {
        private SeparatorKeyI18nQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = DevKitI18nBundle.message("inspections.plugin.xml.i18n.key", new Object[0]);
            if (string == null) {
                SeparatorKeyI18nQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            XmlTag xml;
            if (project == null) {
                SeparatorKeyI18nQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                SeparatorKeyI18nQuickFix.$$$reportNull$$$0(2);
            }
            if ((xml = (XmlTag)descriptor.getPsiElement()) == null) {
                return;
            }
            SeparatorKeyI18nQuickFix.doFix(project, Collections.singletonList(xml));
        }

        public void applyFix(@NotNull Project project, CommonProblemDescriptor @NotNull [] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
            if (project == null) {
                SeparatorKeyI18nQuickFix.$$$reportNull$$$0(3);
            }
            if (psiElementsToIgnore == null) {
                SeparatorKeyI18nQuickFix.$$$reportNull$$$0(4);
            }
            if (descriptors == null) {
                SeparatorKeyI18nQuickFix.$$$reportNull$$$0(5);
            }
            SeparatorKeyI18nQuickFix.doFix(project, PluginXmlI18nInspection.getTags(Arrays.asList(descriptors)));
        }

        private static void doFix(@NotNull Project project, List<XmlTag> tags) {
            if (project == null) {
                SeparatorKeyI18nQuickFix.$$$reportNull$$$0(6);
            }
            PluginXmlI18nInspection.choosePropertiesFileAndExtract(project, tags, selection -> {
                PropertiesFile propertiesFile2 = PluginXmlI18nInspection.findPropertiesFile(project, selection);
                if (propertiesFile2 != null) {
                    ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>();
                    psiFiles.add(propertiesFile2.getContainingFile());
                    for (XmlTag tag : tags) {
                        psiFiles.add(tag.getContainingFile());
                    }
                    WriteCommandAction.runWriteCommandAction((Project)project, (String)DevKitI18nBundle.message("inspections.plugin.xml.i18n.key.command.name", new Object[0]), null, () -> {
                        for (XmlTag tag : tags) {
                            SeparatorKeyI18nQuickFix.registerPropertyKey(project, tag, propertiesFile2);
                        }
                    }, (PsiFile[])psiFiles.toArray(PsiFile.EMPTY_ARRAY));
                }
            });
        }

        private static void registerPropertyKey(@NotNull Project project, XmlTag xml, PropertiesFile propertiesFile2) {
            if (project == null) {
                SeparatorKeyI18nQuickFix.$$$reportNull$$$0(7);
            }
            DomElement domElement = DomUtil.getDomElement((PsiElement)xml);
            assert (domElement instanceof Separator);
            Separator separator = (Separator)domElement;
            String text = StringUtil.defaultIfEmpty((String)separator.getText().getStringValue(), (String)"noText");
            @NonNls String key = "separator." + StringUtil.join((Object[])NameUtilCore.splitNameIntoWords((String)text), s -> StringUtil.trim((String)StringUtil.decapitalize((String)s)), (String)".");
            JavaI18nUtil.DEFAULT_PROPERTY_CREATION_HANDLER.createProperty(project, Collections.singletonList(propertiesFile2), key, StringUtil.unescapeXmlEntities((String)text), new UExpression[0]);
            separator.getText().undefine();
            separator.getKey().setValue((Object)key);
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                SeparatorKeyI18nQuickFix.$$$reportNull$$$0(8);
            }
            if (previewDescriptor == null) {
                SeparatorKeyI18nQuickFix.$$$reportNull$$$0(9);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                SeparatorKeyI18nQuickFix.$$$reportNull$$$0(10);
            }
            return intentionPreviewInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/i18n/PluginXmlI18nInspection$SeparatorKeyI18nQuickFix";
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElementsToIgnore";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/i18n/PluginXmlI18nInspection$SeparatorKeyI18nQuickFix";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "registerPropertyKey";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class ActionOrGroupQuickFixAction
    implements LocalQuickFix,
    BatchQuickFix {
        private final VirtualFile myPropertiesFile;
        private final boolean myIsAction;

        private ActionOrGroupQuickFixAction(VirtualFile file, boolean isAction) {
            this.myPropertiesFile = file;
            this.myIsAction = isAction;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = DevKitI18nBundle.message("inspections.plugin.xml.i18n.name", new Object[0]);
            if (string == null) {
                ActionOrGroupQuickFixAction.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, CommonProblemDescriptor @NotNull [] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
            if (project == null) {
                ActionOrGroupQuickFixAction.$$$reportNull$$$0(1);
            }
            if (psiElementsToIgnore == null) {
                ActionOrGroupQuickFixAction.$$$reportNull$$$0(2);
            }
            if (descriptors == null) {
                ActionOrGroupQuickFixAction.$$$reportNull$$$0(3);
            }
            LightVirtualFile nullValue = new LightVirtualFile();
            Map<VirtualFile, List<CommonProblemDescriptor>> byPropertyFiles = Arrays.stream(descriptors).filter(d -> d instanceof ProblemDescriptor).collect(Collectors.groupingBy(arg_0 -> ActionOrGroupQuickFixAction.lambda$applyFix$1((VirtualFile)nullValue, arg_0)));
            for (Map.Entry<VirtualFile, List<CommonProblemDescriptor>> entry : byPropertyFiles.entrySet()) {
                VirtualFile propertyFile = entry.getKey().equals(nullValue) ? null : entry.getKey();
                this.doFix(project, propertyFile, PluginXmlI18nInspection.getTags(entry.getValue()));
            }
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                ActionOrGroupQuickFixAction.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                ActionOrGroupQuickFixAction.$$$reportNull$$$0(5);
            }
            if (!((element = descriptor.getPsiElement()) instanceof XmlTag)) {
                return;
            }
            XmlTag tag = (XmlTag)element;
            this.doFix(project, this.myPropertiesFile, Collections.singletonList(tag));
        }

        public boolean startInWriteAction() {
            return false;
        }

        private void doFix(@NotNull Project project, VirtualFile file, List<XmlTag> tags) {
            if (project == null) {
                ActionOrGroupQuickFixAction.$$$reportNull$$$0(6);
            }
            if (file == null) {
                PluginXmlI18nInspection.choosePropertiesFileAndExtract(project, tags, selection -> {
                    PropertiesFile propertiesFile2 = PluginXmlI18nInspection.findPropertiesFile(project, selection);
                    this.doFix(project, tags, propertiesFile2, true);
                });
            } else {
                PropertiesFile propertiesFile2 = PropertiesImplUtil.getPropertiesFile((PsiFile)PsiManager.getInstance((Project)project).findFile(file));
                this.doFix(project, tags, propertiesFile2, false);
            }
        }

        private void doFix(@NotNull Project project, List<XmlTag> tags, PropertiesFile propertiesFile2, boolean attachResourceBundle) {
            if (project == null) {
                ActionOrGroupQuickFixAction.$$$reportNull$$$0(7);
            }
            if (propertiesFile2 != null) {
                ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>();
                psiFiles.add(propertiesFile2.getContainingFile());
                for (XmlTag t : tags) {
                    psiFiles.add(t.getContainingFile());
                }
                WriteCommandAction.runWriteCommandAction((Project)project, (String)DevKitI18nBundle.message("inspections.plugin.xml.i18n.command.name", new Object[0]), null, () -> {
                    if (attachResourceBundle) {
                        ActionOrGroupQuickFixAction.createResourceBundleTag(project, tags, propertiesFile2);
                    }
                    ActionOrGroupQuickFixAction.extractTextAndDescription(project, tags, propertiesFile2, this.myIsAction);
                }, (PsiFile[])psiFiles.toArray(PsiFile.EMPTY_ARRAY));
            }
        }

        private static void createResourceBundleTag(@NotNull Project project, List<XmlTag> tags, PropertiesFile propertiesFile2) {
            if (project == null) {
                ActionOrGroupQuickFixAction.$$$reportNull$$$0(8);
            }
            for (XmlTag tag : tags) {
                XmlTag rootTag = ((XmlFile)tag.getContainingFile()).getRootTag();
                LOG.assertTrue(rootTag != null);
                if (rootTag.findFirstSubTag("resource-bundle") != null) continue;
                XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)project);
                XmlTag rbTag = elementFactory.createTagFromText((CharSequence)("<resource-bundle>" + PluginXmlI18nInspection.getBundleQName(project, propertiesFile2) + "</resource-bundle>"));
                rootTag.addSubTag(rbTag, false);
            }
        }

        private static void extractTextAndDescription(@NotNull Project project, Collection<XmlTag> tags, PropertiesFile propertiesFile2, boolean isAction) {
            if (project == null) {
                ActionOrGroupQuickFixAction.$$$reportNull$$$0(9);
            }
            for (XmlTag tag : tags) {
                String actionOrGroupPrefix;
                String text = tag.getAttributeValue("text");
                tag.setAttribute("text", null);
                String description2 = tag.getAttributeValue("description");
                tag.setAttribute("description", null);
                Object id = tag.getName().equals("override-text") ? Objects.requireNonNull(tag.getParentTag()).getAttributeValue("id") + "." + tag.getAttributeValue("place") : tag.getAttributeValue("id");
                List<PropertiesFile> propertiesFiles = Collections.singletonList(propertiesFile2);
                String string = actionOrGroupPrefix = isAction ? "action." : "group.";
                if (text != null) {
                    JavaI18nUtil.DEFAULT_PROPERTY_CREATION_HANDLER.createProperty(project, propertiesFiles, actionOrGroupPrefix + (String)id + ".text", text, new UExpression[0]);
                }
                if (description2 != null) {
                    JavaI18nUtil.DEFAULT_PROPERTY_CREATION_HANDLER.createProperty(project, propertiesFiles, actionOrGroupPrefix + (String)id + ".description", description2, new UExpression[0]);
                }
                tag.processElements(element -> {
                    IElementType type;
                    PsiElement next;
                    if (element instanceof PsiWhiteSpace && element.textContains('\n') && (next = element.getNextSibling()) instanceof LeafPsiElement && ((type = ((LeafPsiElement)next).getElementType()) == XmlTokenType.XML_TAG_END || type == XmlTokenType.XML_EMPTY_ELEMENT_END)) {
                        element.delete();
                        return false;
                    }
                    return true;
                }, tag.getFirstChild());
            }
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                ActionOrGroupQuickFixAction.$$$reportNull$$$0(10);
            }
            if (previewDescriptor == null) {
                ActionOrGroupQuickFixAction.$$$reportNull$$$0(11);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                ActionOrGroupQuickFixAction.$$$reportNull$$$0(12);
            }
            return intentionPreviewInfo;
        }

        private static /* synthetic */ VirtualFile lambda$applyFix$1(VirtualFile nullValue, CommonProblemDescriptor cd) {
            return (VirtualFile)ObjectUtils.notNull((Object)((ActionOrGroupQuickFixAction)cd.getFixes()[0]).myPropertiesFile, (Object)nullValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/i18n/PluginXmlI18nInspection$ActionOrGroupQuickFixAction";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElementsToIgnore";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/i18n/PluginXmlI18nInspection$ActionOrGroupQuickFixAction";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createResourceBundleTag";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "extractTextAndDescription";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalArgumentException(string);
            };
        }
    }
}

