/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.xml.DomUtil;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;

public abstract class IdeaPluginImpl
implements IdeaPlugin {
    private final NullableLazyValue<String> myPluginId = NullableLazyValue.volatileLazyNullable(() -> {
        String pluginId = null;
        if (DomUtil.hasXml(this.getId())) {
            pluginId = this.getId().getStringValue();
        } else if (DomUtil.hasXml(this.getName())) {
            pluginId = this.getName().getStringValue();
        }
        return pluginId != null ? pluginId.trim() : null;
    });

    @Override
    @Nullable
    @NlsSafe
    public String getPluginId() {
        return (String)this.myPluginId.getValue();
    }

    public String toString() {
        XmlElement xml = this.getXmlElement();
        return xml != null ? xml.getContainingFile().getViewProvider().getVirtualFile().getPath() : null;
    }
}

