/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.devkit.workspaceModel.codegen.writer;

import com.intellij.analysis.problemsView.FileProblem;
import com.intellij.analysis.problemsView.Problem;
import com.intellij.analysis.problemsView.ProblemsCollector;
import com.intellij.analysis.problemsView.ProblemsProvider;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewToolWindowUtils;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.devkit.workspaceModel.metaModel.ObjMetaElementWithSource;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.workspaceModel.codegen.deft.meta.ObjClass;
import com.intellij.workspaceModel.codegen.deft.meta.ObjProperty;
import com.intellij.workspaceModel.codegen.engine.GenerationProblem;
import com.intellij.workspaceModel.codegen.engine.ProblemLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0003\u000f\u0010\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006J\u0010\u0010\u000e\u001a\u00060\u0007R\u00020\u0000*\u00020\rH\u0002R\u0018\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0007R\u00020\u00000\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/intellij/devkit/workspaceModel/codegen/writer/WorkspaceCodegenProblemsProvider;", "Lcom/intellij/analysis/problemsView/ProblemsProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "currentProblems", "", "Lcom/intellij/devkit/workspaceModel/codegen/writer/WorkspaceCodegenProblemsProvider$WorkspaceModelCodeGenerationProblem;", "getProject", "()Lcom/intellij/openapi/project/Project;", "reportProblems", "", "generationProblems", "Lcom/intellij/workspaceModel/codegen/engine/GenerationProblem;", "toProblem", "Companion", "WorkspaceModelCodeGenerationProblem", "WorkspaceModelCodeGenerationProblemInFile", "intellij.devkit.workspaceModel"})
@SourceDebugExtension(value={"SMAP\nWorkspaceCodegenProblemsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceCodegenProblemsProvider.kt\ncom/intellij/devkit/workspaceModel/codegen/writer/WorkspaceCodegenProblemsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n1549#2:89\n1620#2,3:90\n*S KotlinDebug\n*F\n+ 1 WorkspaceCodegenProblemsProvider.kt\ncom/intellij/devkit/workspaceModel/codegen/writer/WorkspaceCodegenProblemsProvider\n*L\n38#1:89\n38#1:90,3\n*E\n"})
public final class WorkspaceCodegenProblemsProvider
implements ProblemsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private List<? extends WorkspaceModelCodeGenerationProblem> currentProblems;

    public WorkspaceCodegenProblemsProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.currentProblems = CollectionsKt.emptyList();
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    public final void reportProblems(@NotNull List<GenerationProblem> generationProblems) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(generationProblems, (String)"generationProblems");
        if (!((Collection)generationProblems).isEmpty() && ApplicationManager.getApplication().isUnitTestMode()) {
            GenerationProblem problem = (GenerationProblem)CollectionsKt.first(generationProblems);
            throw new IllegalStateException(("Failed to generate code for " + problem.getLocation() + ": " + problem.getMessage()).toString());
        }
        Iterable $this$map$iv = generationProblems;
        boolean bl = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GenerationProblem generationProblem = (GenerationProblem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(this.toProblem((GenerationProblem)it));
        }
        List problems = (List)destination$iv$iv;
        for (WorkspaceModelCodeGenerationProblem workspaceModelCodeGenerationProblem : this.currentProblems) {
            ProblemsCollector.Companion.getInstance(this.getProject()).problemDisappeared((Problem)workspaceModelCodeGenerationProblem);
        }
        this.currentProblems = problems;
        for (WorkspaceModelCodeGenerationProblem workspaceModelCodeGenerationProblem : problems) {
            ProblemsCollector.Companion.getInstance(this.getProject()).problemAppeared((Problem)workspaceModelCodeGenerationProblem);
        }
        if (!((Collection)problems).isEmpty()) {
            ProblemsViewToolWindowUtils.selectProjectErrorsTab((Project)this.getProject());
        }
    }

    private final WorkspaceModelCodeGenerationProblem toProblem(GenerationProblem $this$toProblem) {
        SourceElement sourceElement;
        ProblemLocation problemLocation = $this$toProblem.getLocation();
        if (problemLocation instanceof ProblemLocation.Class) {
            ObjClass<?> objClass = ((ProblemLocation.Class)problemLocation).getObjClass();
            Intrinsics.checkNotNull(objClass, (String)"null cannot be cast to non-null type com.intellij.devkit.workspaceModel.metaModel.ObjMetaElementWithSource");
            sourceElement = ((ObjMetaElementWithSource)((Object)objClass)).getSourceElement();
        } else if (problemLocation instanceof ProblemLocation.Property) {
            ObjProperty<?, ?> objProperty = ((ProblemLocation.Property)problemLocation).getProperty();
            Intrinsics.checkNotNull(objProperty, (String)"null cannot be cast to non-null type com.intellij.devkit.workspaceModel.metaModel.ObjMetaElementWithSource");
            sourceElement = ((ObjMetaElementWithSource)((Object)objProperty)).getSourceElement();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        SourceElement sourceElement2 = sourceElement;
        PsiElement psiElement = PsiSourceElementKt.getPsi((SourceElement)sourceElement2);
        if (psiElement == null) {
            return new WorkspaceModelCodeGenerationProblem($this$toProblem);
        }
        PsiElement psiElement2 = psiElement;
        PsiNameIdentifierOwner psiNameIdentifierOwner = psiElement2 instanceof PsiNameIdentifierOwner ? (PsiNameIdentifierOwner)psiElement2 : null;
        if (psiNameIdentifierOwner == null || (psiNameIdentifierOwner = psiNameIdentifierOwner.getNameIdentifier()) == null) {
            psiNameIdentifierOwner = psiElement2;
        }
        PsiNameIdentifierOwner psiToHighlight = psiNameIdentifierOwner;
        VirtualFile file = psiToHighlight.getContainingFile().getVirtualFile();
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return new WorkspaceModelCodeGenerationProblem($this$toProblem);
        }
        Document document2 = document;
        int offset = UtilsKt.getStartOffset((PsiElement)psiToHighlight);
        int line = document2.getLineNumber(offset);
        int column = offset - document2.getLineStartOffset(line);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
        return new WorkspaceModelCodeGenerationProblemInFile($this$toProblem, file, line, column);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/devkit/workspaceModel/codegen/writer/WorkspaceCodegenProblemsProvider$Companion;", "", "()V", "getInstance", "Lcom/intellij/devkit/workspaceModel/codegen/writer/WorkspaceCodegenProblemsProvider;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.devkit.workspaceModel"})
    @SourceDebugExtension(value={"SMAP\nWorkspaceCodegenProblemsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceCodegenProblemsProvider.kt\ncom/intellij/devkit/workspaceModel/codegen/writer/WorkspaceCodegenProblemsProvider$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,88:1\n29#2,3:89\n*S KotlinDebug\n*F\n+ 1 WorkspaceCodegenProblemsProvider.kt\ncom/intellij/devkit/workspaceModel/codegen/writer/WorkspaceCodegenProblemsProvider$Companion\n*L\n29#1:89,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WorkspaceCodegenProblemsProvider getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<WorkspaceCodegenProblemsProvider> serviceClass$iv = WorkspaceCodegenProblemsProvider.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (WorkspaceCodegenProblemsProvider)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0092\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/devkit/workspaceModel/codegen/writer/WorkspaceCodegenProblemsProvider$WorkspaceModelCodeGenerationProblem;", "Lcom/intellij/analysis/problemsView/Problem;", "originalProblem", "Lcom/intellij/workspaceModel/codegen/engine/GenerationProblem;", "(Lcom/intellij/devkit/workspaceModel/codegen/writer/WorkspaceCodegenProblemsProvider;Lcom/intellij/workspaceModel/codegen/engine/GenerationProblem;)V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "provider", "Lcom/intellij/analysis/problemsView/ProblemsProvider;", "getProvider", "()Lcom/intellij/analysis/problemsView/ProblemsProvider;", "text", "", "getText", "()Ljava/lang/String;", "intellij.devkit.workspaceModel"})
    private class WorkspaceModelCodeGenerationProblem
    implements Problem {
        @NotNull
        private final GenerationProblem originalProblem;

        public WorkspaceModelCodeGenerationProblem(GenerationProblem originalProblem) {
            Intrinsics.checkNotNullParameter((Object)originalProblem, (String)"originalProblem");
            this.originalProblem = originalProblem;
        }

        @NotNull
        public ProblemsProvider getProvider() {
            return WorkspaceCodegenProblemsProvider.this;
        }

        @NotNull
        public String getText() {
            return this.originalProblem.getMessage();
        }

        @NotNull
        public Icon getIcon() {
            Icon icon;
            switch (WhenMappings.$EnumSwitchMapping$0[this.originalProblem.getLevel().ordinal()]) {
                case 1: {
                    Icon icon2 = HighlightDisplayLevel.ERROR.getIcon();
                    icon = icon2;
                    Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ERROR.icon");
                    break;
                }
                case 2: {
                    Icon icon3 = HighlightDisplayLevel.WARNING.getIcon();
                    icon = icon3;
                    Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"WARNING.icon");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return icon;
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[GenerationProblem.Level.values().length];
                try {
                    nArray[GenerationProblem.Level.ERROR.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GenerationProblem.Level.WARNING.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0092\u0004\u0018\u00002\u00060\u0001R\u00020\u00022\u00020\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bR\u0014\u0010\n\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/intellij/devkit/workspaceModel/codegen/writer/WorkspaceCodegenProblemsProvider$WorkspaceModelCodeGenerationProblemInFile;", "Lcom/intellij/devkit/workspaceModel/codegen/writer/WorkspaceCodegenProblemsProvider$WorkspaceModelCodeGenerationProblem;", "Lcom/intellij/devkit/workspaceModel/codegen/writer/WorkspaceCodegenProblemsProvider;", "Lcom/intellij/analysis/problemsView/FileProblem;", "originalProblem", "Lcom/intellij/workspaceModel/codegen/engine/GenerationProblem;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "column", "(Lcom/intellij/devkit/workspaceModel/codegen/writer/WorkspaceCodegenProblemsProvider;Lcom/intellij/workspaceModel/codegen/engine/GenerationProblem;Lcom/intellij/openapi/vfs/VirtualFile;II)V", "getColumn", "()I", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getLine", "intellij.devkit.workspaceModel"})
    private class WorkspaceModelCodeGenerationProblemInFile
    extends WorkspaceModelCodeGenerationProblem
    implements FileProblem {
        @NotNull
        private final VirtualFile file;
        private final int line;
        private final int column;

        public WorkspaceModelCodeGenerationProblemInFile(@NotNull GenerationProblem originalProblem, VirtualFile file, int line, int column) {
            Intrinsics.checkNotNullParameter((Object)originalProblem, (String)"originalProblem");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super(originalProblem);
            this.file = file;
            this.line = line;
            this.column = column;
        }

        @NotNull
        public VirtualFile getFile() {
            return this.file;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }
    }
}

