/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.ProcessorWithHints;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.util.PropertyUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.BaseGroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.GrResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.AccessorProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MultiProcessor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/AllVariantsProcessor;", "Lcom/intellij/psi/scope/ProcessorWithHints;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/MultiProcessor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/GrResolverProcessor;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "name", "", "place", "Lcom/intellij/psi/PsiElement;", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "accessorProcessors", "", "allProcessors", "candidates", "", "results", "getResults", "()Ljava/util/List;", "execute", "", "element", "state", "Lcom/intellij/psi/ResolveState;", "getProcessors", "", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nAllVariantsProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AllVariantsProcessor.kt\norg/jetbrains/plugins/groovy/lang/resolve/processors/AllVariantsProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1446#2,5:63\n*S KotlinDebug\n*F\n+ 1 AllVariantsProcessor.kt\norg/jetbrains/plugins/groovy/lang/resolve/processors/AllVariantsProcessor\n*L\n58#1:63,5\n*E\n"})
public final class AllVariantsProcessor
extends ProcessorWithHints
implements MultiProcessor,
GrResolverProcessor<GroovyResolveResult> {
    @NotNull
    private final String name;
    @NotNull
    private final PsiElement place;
    @NotNull
    private final List<GrResolverProcessor<GroovyResolveResult>> accessorProcessors;
    @NotNull
    private final List<GrResolverProcessor<GroovyResolveResult>> allProcessors;
    @NotNull
    private final List<GroovyResolveResult> candidates;

    public AllVariantsProcessor(@NotNull String name, @NotNull PsiElement place) {
        List list;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        this.name = name;
        this.place = place;
        this.hint(NameHint.KEY, arg_0 -> AllVariantsProcessor._init_$lambda$0(this, arg_0));
        if (!PropertyUtilKt.isPropertyName(this.name)) {
            list = CollectionsKt.emptyList();
        } else {
            Object[] objectArray = new AccessorProcessor[]{new AccessorProcessor(this.name, PropertyKind.GETTER, null, this.place), new AccessorProcessor(this.name, PropertyKind.BOOLEAN_GETTER, null, this.place)};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        this.accessorProcessors = list;
        this.allProcessors = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this), (Iterable)this.accessorProcessors);
        this.candidates = new ArrayList();
    }

    @NotNull
    public Collection<PsiScopeProcessor> getProcessors() {
        return this.allProcessors;
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        PsiNamedElement psiNamedElement = element instanceof PsiNamedElement ? (PsiNamedElement)element : null;
        if (psiNamedElement == null) {
            return true;
        }
        PsiNamedElement namedElement = psiNamedElement;
        if (!Intrinsics.areEqual((Object)this.name, (Object)ResolveUtilKt.getName(state, (PsiElement)namedElement))) {
            return true;
        }
        if (ResolveUtilKt.getResolveKind((PsiElement)namedElement) == null) {
            return true;
        }
        BaseGroovyResolveResult<PsiElement> candidate = new BaseGroovyResolveResult<PsiElement>((PsiElement)namedElement, this.place, state);
        ((Collection)this.candidates).add(candidate);
        return true;
    }

    @Override
    @NotNull
    public List<GroovyResolveResult> getResults() {
        List result2 = new ArrayList();
        CollectionsKt.addAll((Collection)result2, (Iterable)this.candidates);
        Iterable $this$flatMapTo$iv = this.accessorProcessors;
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            GrResolverProcessor it = (GrResolverProcessor)element$iv;
            boolean bl = false;
            Iterable list$iv = it.getResults();
            CollectionsKt.addAll((Collection)result2, (Iterable)list$iv);
        }
        GroovyResolveResult[] groovyResolveResultArray = ResolveUtil.filterSameSignatureCandidates(result2);
        Intrinsics.checkNotNullExpressionValue((Object)groovyResolveResultArray, (String)"filterSameSignatureCandidates(result)");
        return ArraysKt.toList((Object[])groovyResolveResultArray);
    }

    private static final String _init_$lambda$0(AllVariantsProcessor this$0, ResolveState it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.name;
    }
}

