/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyExpressionPattern;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyPatternsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00002\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006J\u0016\u0010\b\u001a\u00020\u00002\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/groovy/lang/psi/patterns/GroovyClosurePattern;", "Lorg/jetbrains/plugins/groovy/lang/psi/patterns/GroovyExpressionPattern;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "()V", "inMethod", "methodPattern", "Lcom/intellij/patterns/ElementPattern;", "Lcom/intellij/psi/PsiMethod;", "inMethodResult", "condition", "Lcom/intellij/patterns/PatternCondition;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyMethodResult;", "Companion", "intellij.groovy.psi"})
public final class GroovyClosurePattern
extends GroovyExpressionPattern<GrClosableBlock, GroovyClosurePattern> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public GroovyClosurePattern() {
        super(GrClosableBlock.class);
    }

    @NotNull
    public final GroovyClosurePattern inMethod(@NotNull ElementPattern<? extends PsiMethod> methodPattern) {
        Intrinsics.checkNotNullParameter(methodPattern, (String)"methodPattern");
        ObjectPattern objectPattern = this.with((PatternCondition)new PatternCondition<GrClosableBlock>(methodPattern){
            final /* synthetic */ ElementPattern<? extends PsiMethod> $methodPattern;
            {
                this.$methodPattern = $methodPattern;
                super("closureInMethod");
            }

            public boolean accepts(@NotNull GrClosableBlock closure, @Nullable ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)closure, (String)"closure");
                GrCall grCall = org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyClosurePattern$Companion.access$getCall(GroovyClosurePattern.Companion, closure);
                if (grCall == null) {
                    return false;
                }
                GrCall call = grCall;
                ProcessingContext processingContext = context;
                if (processingContext != null) {
                    processingContext.put(GroovyPatternsKt.getClosureCallKey(), (Object)call);
                }
                PsiMethod psiMethod = call.resolveMethod();
                if (psiMethod == null) {
                    return false;
                }
                PsiMethod method = psiMethod;
                return this.$methodPattern.accepts((Object)method);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"methodPattern: ElementPa\u2026ts(method)\n      }\n    })");
        return (GroovyClosurePattern)objectPattern;
    }

    @NotNull
    public final GroovyClosurePattern inMethodResult(@NotNull PatternCondition<? super GroovyMethodResult> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        ObjectPattern objectPattern = this.with((PatternCondition)new PatternCondition<GrClosableBlock>(condition){
            final /* synthetic */ PatternCondition<? super GroovyMethodResult> $condition;
            {
                this.$condition = $condition;
                super("closureInMethodResult");
            }

            public boolean accepts(@NotNull GrClosableBlock closure, @Nullable ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)closure, (String)"closure");
                GrCall grCall = org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyClosurePattern$Companion.access$getCall(GroovyClosurePattern.Companion, closure);
                if (grCall == null) {
                    return false;
                }
                GrCall call = grCall;
                ProcessingContext processingContext = context;
                if (processingContext != null) {
                    processingContext.put(GroovyPatternsKt.getClosureCallKey(), (Object)call);
                }
                GroovyResolveResult groovyResolveResult = call.advancedResolve();
                GroovyMethodResult groovyMethodResult = groovyResolveResult instanceof GroovyMethodResult ? (GroovyMethodResult)groovyResolveResult : null;
                if (groovyMethodResult == null) {
                    return false;
                }
                GroovyMethodResult result2 = groovyMethodResult;
                return this.$condition.accepts((Object)result2, context);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"condition: PatternCondit\u2026, context)\n      }\n    })");
        return (GroovyClosurePattern)objectPattern;
    }

    @NotNull
    public Object clone() {
        return super.clone();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/groovy/lang/psi/patterns/GroovyClosurePattern$Companion;", "", "()V", "getCall", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrCall;", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "intellij.groovy.psi"})
    public static final class Companion {
        private Companion() {
        }

        private final GrCall getCall(GrClosableBlock closure) {
            PsiElement parent2 = closure.getParent();
            if (parent2 instanceof GrCall) {
                GrClosableBlock[] grClosableBlockArray = ((GrCall)parent2).getClosureArguments();
                Intrinsics.checkNotNullExpressionValue((Object)grClosableBlockArray, (String)"parent.closureArguments");
                return ArraysKt.contains((Object[])grClosableBlockArray, (Object)closure) ? (GrCall)parent2 : null;
            }
            if (parent2 instanceof GrArgumentList) {
                PsiElement psiElement = ((GrArgumentList)parent2).getParent();
                GrCall grCall = psiElement instanceof GrCall ? (GrCall)psiElement : null;
                if (grCall == null) {
                    return null;
                }
                GrCall grandParent = grCall;
                GrClosableBlock[] grClosableBlockArray = grandParent.getClosureArguments();
                Intrinsics.checkNotNullExpressionValue((Object)grClosableBlockArray, (String)"grandParent.closureArguments");
                if (!(((Object[])grClosableBlockArray).length == 0)) {
                    return null;
                }
                GrExpression[] grExpressionArray = grandParent.getExpressionArguments();
                Intrinsics.checkNotNullExpressionValue((Object)grExpressionArray, (String)"grandParent.expressionArguments");
                if (!Intrinsics.areEqual((Object)ArraysKt.lastOrNull((Object[])grExpressionArray), (Object)closure)) {
                    return null;
                }
                return grandParent;
            }
            return null;
        }

        public static final /* synthetic */ GrCall access$getCall(Companion $this, GrClosableBlock closure) {
            return $this.getCall(closure);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

