/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.EqTailType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PairConsumer;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.configSlurper.ConfigSlurperSupport;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

class GroovyConfigSlurperCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private final boolean myAddPrefixes;

    GroovyConfigSlurperCompletionProvider(boolean addPrefixes) {
        this.myAddPrefixes = addPrefixes;
    }

    public static void register(CompletionContributor contributor) {
        PsiElementPattern.Capture pattern = (PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(GrReferenceExpression.class));
        contributor.extend(CompletionType.BASIC, (ElementPattern)pattern, (CompletionProvider)new GroovyConfigSlurperCompletionProvider(true));
        contributor.extend(CompletionType.SMART, (ElementPattern)pattern, (CompletionProvider)new GroovyConfigSlurperCompletionProvider(false));
    }

    protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        PsiFile file;
        if (parameters2 == null) {
            GroovyConfigSlurperCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GroovyConfigSlurperCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            GroovyConfigSlurperCompletionProvider.$$$reportNull$$$0(2);
        }
        if (!((file = parameters2.getOriginalFile()) instanceof GroovyFile)) {
            return;
        }
        GroovyFile groovyFile = (GroovyFile)file;
        if (!groovyFile.isScript()) {
            return;
        }
        GrReferenceExpression ref2 = (GrReferenceExpression)parameters2.getPosition().getParent();
        if (ref2 == null) {
            return;
        }
        HashMap variants = new HashMap();
        GroovyConfigSlurperCompletionProvider.collectVariants((PairConsumer<String, Boolean>)((PairConsumer)(s, isFinal) -> variants.put(s, isFinal)), ref2, groovyFile);
        if (variants.isEmpty()) {
            return;
        }
        PsiElement parent2 = ref2.getParent();
        if (parent2 instanceof GrAssignmentExpression) {
            parent2 = parent2.getParent();
        }
        if (parent2 == null) {
            return;
        }
        HashSet<String> processedPrefixes = new HashSet<String>();
        HashSet<String> prefixesInMethodCall = new HashSet<String>();
        for (PsiElement e = parent2.getFirstChild(); e != null; e = e.getNextSibling()) {
            String name;
            GrMethodCall call;
            if (e instanceof GrAssignmentExpression) {
                String s2;
                GrExpression left = ((GrAssignmentExpression)e).getLValue();
                if (!(left instanceof GrReferenceExpression) || (s2 = GroovyConfigSlurperCompletionProvider.refToString((GrReferenceExpression)left)) == null) continue;
                int dotIndex = s2.indexOf(46);
                if (dotIndex > 0) {
                    processedPrefixes.add(s2.substring(0, dotIndex));
                }
                variants.remove(s2);
                continue;
            }
            if (!(e instanceof GrMethodCall) || !GroovyConfigSlurperCompletionProvider.isPropertyCall(call = (GrMethodCall)e) || (name = GroovyConfigSlurperCompletionProvider.extractPropertyName(call)) == null) continue;
            processedPrefixes.add(name);
            prefixesInMethodCall.add(name);
            variants.remove(name);
        }
        for (Map.Entry entry : variants.entrySet()) {
            String variant = (String)entry.getKey();
            int dotIndex = variant.indexOf(46);
            if (dotIndex > 0 && dotIndex < variant.length() - 1) {
                String p = variant.substring(0, dotIndex);
                if (prefixesInMethodCall.contains(p)) continue;
                if (this.myAddPrefixes && processedPrefixes.add(p)) {
                    result2.addElement((LookupElement)LookupElementBuilder.create((String)p));
                }
            }
            LookupElementBuilder lookupElement2 = LookupElementBuilder.create((String)variant);
            if (((Boolean)entry.getValue()).booleanValue()) {
                lookupElement2 = TailTypeDecorator.withTail((LookupElement)lookupElement2, (TailType)EqTailType.INSTANCE);
            }
            result2.addElement((LookupElement)lookupElement2);
        }
    }

    private static void collectVariants(@NotNull PairConsumer<String, Boolean> consumer, @NotNull GrReferenceExpression ref2, @NotNull GroovyFile originalFile) {
        List<String> prefix;
        if (consumer == null) {
            GroovyConfigSlurperCompletionProvider.$$$reportNull$$$0(3);
        }
        if (ref2 == null) {
            GroovyConfigSlurperCompletionProvider.$$$reportNull$$$0(4);
        }
        if (originalFile == null) {
            GroovyConfigSlurperCompletionProvider.$$$reportNull$$$0(5);
        }
        if ((prefix = GroovyConfigSlurperCompletionProvider.getPrefix(ref2)) == null) {
            return;
        }
        for (ConfigSlurperSupport configSlurperSupport : (ConfigSlurperSupport[])ConfigSlurperSupport.EP_NAME.getExtensions()) {
            ConfigSlurperSupport.PropertiesProvider provider2 = configSlurperSupport.getProvider(originalFile);
            if (provider2 == null) continue;
            provider2.collectVariants(prefix, consumer);
        }
    }

    @Nullable
    private static String refToString(GrReferenceExpression ref2) {
        StringBuilder sb = new StringBuilder();
        while (ref2 != null) {
            String name = ref2.getReferenceName();
            if (name == null) {
                return null;
            }
            int i2 = name.length();
            while (--i2 >= 0) {
                sb.append(name.charAt(i2));
            }
            GrExpression qualifierExpression = ref2.getQualifierExpression();
            if (qualifierExpression == null) break;
            if (!(qualifierExpression instanceof GrReferenceExpression)) {
                return null;
            }
            sb.append('.');
            ref2 = (GrReferenceExpression)qualifierExpression;
        }
        sb.reverse();
        return sb.toString();
    }

    @Nullable
    public static List<String> getPrefix(GrReferenceExpression ref2) {
        ArrayList<String> res = new ArrayList<String>();
        GrExpression qualifier = ref2.getQualifierExpression();
        while (qualifier != null) {
            if (!(qualifier instanceof GrReferenceExpression)) {
                return null;
            }
            GrReferenceExpression r = (GrReferenceExpression)qualifier;
            String name = r.getReferenceName();
            if (name == null) {
                return null;
            }
            res.add(name);
            qualifier = r.getQualifierExpression();
        }
        PsiElement e = ref2.getParent();
        if (e instanceof GrAssignmentExpression) {
            GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)e;
            if (assignmentExpression.getLValue() != ref2) {
                return null;
            }
            e = assignmentExpression.getParent();
        }
        while (!(e instanceof PsiFile)) {
            if (e instanceof GrClosableBlock) {
                PsiElement eCall = e.getParent();
                if (!(eCall instanceof GrMethodCall)) {
                    return null;
                }
                GrMethodCall call = (GrMethodCall)eCall;
                if (!GroovyConfigSlurperCompletionProvider.isPropertyCall(call)) {
                    return null;
                }
                String name = GroovyConfigSlurperCompletionProvider.extractPropertyName(call);
                if (name == null) {
                    return null;
                }
                res.add(name);
                e = call.getParent();
                continue;
            }
            if (e instanceof GrBlockStatement || e instanceof GrOpenBlock || e instanceof GrIfStatement || e instanceof GrForStatement || e instanceof GrWhileStatement || e instanceof GrTryCatchStatement) {
                e = e.getParent();
                continue;
            }
            return null;
        }
        Collections.reverse(res);
        return res;
    }

    @Nullable
    private static String extractPropertyName(GrMethodCall call) {
        GrExpression ie = call.getInvokedExpression();
        if (ie instanceof GrReferenceExpression) {
            GrReferenceExpression r = (GrReferenceExpression)ie;
            if (r.isQualified()) {
                return null;
            }
            return r.getReferenceName();
        }
        if (ie instanceof GrLiteralImpl) {
            Object value2 = ((GrLiteralImpl)ie).getValue();
            if (!(value2 instanceof String)) {
                return null;
            }
            return (String)value2;
        }
        return null;
    }

    private static boolean isPropertyCall(GrMethodCall call) {
        GrExpression[] arguments2 = PsiUtil.getAllArguments(call);
        return arguments2.length == 1 && arguments2[0] instanceof GrClosableBlock;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/completion/GroovyConfigSlurperCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "collectVariants";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

