/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.Consumer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.GroovyClassNameInsertHandler;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyImports;
import org.jetbrains.plugins.groovy.util.FunctionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/groovy/lang/completion/CompleteReferenceProcessor;", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "matcher", "Lcom/intellij/codeInsight/completion/PrefixMatcher;", "consumer", "Lcom/intellij/util/Consumer;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "Lorg/jetbrains/plugins/groovy/lang/completion/LookupConsumer;", "afterNew", "", "(Lcom/intellij/codeInsight/completion/PrefixMatcher;Lcom/intellij/util/Consumer;Z)V", "execute", "element", "Lcom/intellij/psi/PsiElement;", "state", "Lcom/intellij/psi/ResolveState;", "intellij.groovy"})
final class CompleteReferenceProcessor
implements PsiScopeProcessor {
    @NotNull
    private final PrefixMatcher matcher;
    @NotNull
    private final Consumer<LookupElement> consumer;
    private final boolean afterNew;

    public CompleteReferenceProcessor(@NotNull PrefixMatcher matcher, @NotNull Consumer<LookupElement> consumer, boolean afterNew) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.matcher = matcher;
        this.consumer = consumer;
        this.afterNew = afterNew;
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!(element instanceof PsiNamedElement)) {
            return true;
        }
        String string = ((PsiNamedElement)element).getName();
        if (string == null) {
            return true;
        }
        String name = string;
        String importedName = (String)state.get(GroovyImports.getImportedNameKey());
        if (element instanceof PsiClass && importedName != null && !Intrinsics.areEqual((Object)importedName, (Object)name)) {
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)element, (String)importedName).withPresentableText(importedName);
            Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"create(element, imported\u2026entableText(importedName)");
            LookupElementBuilder builder = lookupElementBuilder;
            LookupElement item = GroovyCompletionUtil.setupLookupBuilder(element, (PsiSubstitutor)state.get(PsiSubstitutor.KEY), builder, null);
            this.consumer.consume((Object)item);
        } else if (this.matcher.prefixMatches(name)) {
            if (element instanceof PsiClass) {
                List items = JavaClassNameCompletionContributor.createClassLookupItems((PsiClass)((PsiClass)element), (boolean)this.afterNew, (InsertHandler)new GroovyClassNameInsertHandler(), (Condition)Conditions.alwaysTrue());
                Intrinsics.checkNotNullExpressionValue((Object)items, (String)"items");
                FunctionsKt.consumeAll(this.consumer, items);
            } else {
                LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)element, (String)name);
                Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"create(element, name)");
                LookupElementBuilder builder = lookupElementBuilder;
                LookupElement item = GroovyCompletionUtil.setupLookupBuilder(element, PsiSubstitutor.EMPTY, builder, null);
                this.consumer.consume((Object)item);
            }
        }
        return true;
    }
}

