/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.annotations;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyAnnotationArgumentPattern;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyElementPattern;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyPatternsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/annotations/AddAnnotationValueIntention;", "Lorg/jetbrains/plugins/groovy/intentions/base/Intention;", "()V", "getElementPredicate", "Lorg/jetbrains/plugins/groovy/intentions/base/PsiElementPredicate;", "processIntention", "", "element", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Holder", "intellij.groovy"})
public final class AddAnnotationValueIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return Holder.INSTANCE.getMyPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GrAnnotationMemberValue grAnnotationMemberValue = element instanceof GrAnnotationMemberValue ? (GrAnnotationMemberValue)element : null;
        if (grAnnotationMemberValue == null) {
            return;
        }
        GrAnnotationMemberValue value2 = grAnnotationMemberValue;
        PsiElement psiElement = ((GrAnnotationMemberValue)element).getParent();
        GrAnnotationNameValuePair grAnnotationNameValuePair = psiElement instanceof GrAnnotationNameValuePair ? (GrAnnotationNameValuePair)psiElement : null;
        if (grAnnotationNameValuePair == null) {
            return;
        }
        GrAnnotationNameValuePair pair = grAnnotationNameValuePair;
        ASTNode aSTNode = value2.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"value.node");
        ASTNode anchor = aSTNode;
        pair.getNode().addLeaf(GroovyTokenTypes.mIDENT, (CharSequence)"value", anchor);
        pair.getNode().addLeaf(GroovyTokenTypes.mASSIGN, (CharSequence)"=", anchor);
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)pair, true);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/annotations/AddAnnotationValueIntention$Holder;", "", "()V", "myPredicate", "Lorg/jetbrains/plugins/groovy/intentions/base/PsiElementPredicate;", "getMyPredicate", "()Lorg/jetbrains/plugins/groovy/intentions/base/PsiElementPredicate;", "intellij.groovy"})
    private static final class Holder {
        @NotNull
        public static final Holder INSTANCE = new Holder();
        @NotNull
        private static final PsiElementPredicate myPredicate;

        private Holder() {
        }

        @NotNull
        public final PsiElementPredicate getMyPredicate() {
            return myPredicate;
        }

        static {
            PatternCondition<GrAnnotationArgumentList> singleArgumentCondition2 = new PatternCondition<GrAnnotationArgumentList>(){

                public boolean accepts(@NotNull GrAnnotationArgumentList t, @Nullable ProcessingContext context) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    return t.getAttributes().length == 1;
                }
            };
            ObjectPattern objectPattern = GroovyPatternsKt.getGroovyAnnotationArgumentList().with((PatternCondition)singleArgumentCondition2);
            Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"groovyAnnotationArgument\u2026(singleArgumentCondition)");
            GroovyElementPattern.Capture argumentList = (GroovyElementPattern.Capture)objectPattern;
            TreeElementPattern treeElementPattern = GroovyPatternsKt.getGroovyAnnotationArgument().withArgumentName(null).withParent((ElementPattern)argumentList);
            Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern, (String)"groovyAnnotationArgument\u2026.withParent(argumentList)");
            GroovyAnnotationArgumentPattern.Capture argument = (GroovyAnnotationArgumentPattern.Capture)treeElementPattern;
            TreeElementPattern treeElementPattern2 = GroovyPatternsKt.getGroovyAnnotationArgumentValue().withParent((ElementPattern)argument);
            Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern2, (String)"groovyAnnotationArgumentValue.withParent(argument)");
            GroovyElementPattern.Capture argumentValue = (GroovyElementPattern.Capture)treeElementPattern2;
            myPredicate = arg_0 -> ((GroovyElementPattern.Capture)argumentValue).accepts(arg_0);
        }
    }
}

