/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.actions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyTokenSets;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/groovy/editor/actions/GroovyTripleQuoteBackspaceHandlerDelegate;", "Lcom/intellij/codeInsight/editorActions/BackspaceHandlerDelegate;", "()V", "myWithinTripleQuoted", "", "beforeCharDeleted", "", "c", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "charDeleted", "intellij.groovy"})
public final class GroovyTripleQuoteBackspaceHandlerDelegate
extends BackspaceHandlerDelegate {
    private boolean myWithinTripleQuoted;

    public void beforeCharDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.myWithinTripleQuoted = false;
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE) {
            return;
        }
        if (c != '\'' && c != '\"') {
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        HighlighterIterator highlighterIterator = editor.getHighlighter().createIterator(offset);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"editor.highlighter.createIterator(offset)");
        HighlighterIterator iterator2 = highlighterIterator;
        IElementType tokenType = iterator2.getTokenType();
        if (GroovyTokenSets.STRING_LITERALS.contains(tokenType)) {
            this.myWithinTripleQuoted = iterator2.getStart() + 3 == offset && iterator2.getEnd() - 3 == offset;
        }
    }

    public boolean charDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!this.myWithinTripleQuoted) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        editor.getDocument().deleteString(offset, offset + 3);
        return true;
    }
}

