/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import java.util.Arrays;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.compiler.ExcludeFromStubGenerationAction;

public final class GroovyStubNotificationProvider
implements EditorNotificationProvider {
    static final String GROOVY_STUBS = "groovyStubs";

    @Nullable
    public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            GroovyStubNotificationProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            GroovyStubNotificationProvider.$$$reportNull$$$0(1);
        }
        if (!file.getName().endsWith(".java") || !file.getPath().contains(GROOVY_STUBS)) {
            return null;
        }
        PsiClass psiClass = GroovyStubNotificationProvider.findClassByStub(project, file);
        if (psiClass == null) {
            return null;
        }
        return fileEditor -> GroovyStubNotificationProvider.decorateStubFile(file, project, fileEditor);
    }

    @Nullable
    @VisibleForTesting
    public static PsiClass findClassByStub(Project project, VirtualFile stubFile) {
        String[] components = StringUtil.trimEnd((String)stubFile.getPath(), (String)".java").split("[\\\\/]");
        int stubs = Arrays.asList(components).indexOf(GROOVY_STUBS);
        if (stubs < 0 || stubs >= components.length - 3) {
            return null;
        }
        String moduleName = components[stubs + 1];
        Module module = ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
        if (module == null) {
            return null;
        }
        String fqn = StringUtil.join(Arrays.asList(components).subList(stubs + 3, components.length), (String)".");
        return JavaPsiFacade.getInstance((Project)project).findClass(fqn, GlobalSearchScope.moduleScope((Module)module));
    }

    private static EditorNotificationPanel decorateStubFile(VirtualFile file, Project project, @NotNull FileEditor fileEditor) {
        if (fileEditor == null) {
            GroovyStubNotificationProvider.$$$reportNull$$$0(2);
        }
        EditorNotificationPanel panel = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Info);
        panel.setText(GroovyBundle.message("generated.stub.message", new Object[0]));
        panel.createActionLabel(GroovyBundle.message("generated.stub.navigate.link.label", new Object[0]), () -> DumbService.getInstance((Project)project).withAlternativeResolveEnabled(() -> {
            PsiClass original = GroovyStubNotificationProvider.findClassByStub(project, file);
            if (original != null) {
                original.navigate(true);
            }
        }));
        panel.createActionLabel(GroovyBundle.message("generated.stub.exclude.link.label", new Object[0]), () -> DumbService.getInstance((Project)project).withAlternativeResolveEnabled(() -> {
            PsiClass psiClass = GroovyStubNotificationProvider.findClassByStub(project, file);
            if (psiClass != null) {
                ExcludeFromStubGenerationAction.doExcludeFromStubGeneration(psiClass.getContainingFile());
            }
        }));
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/compiler/GroovyStubNotificationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectNotificationData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "decorateStubFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

