/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.style.string;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.options.OptDropdown;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.style.string.EscapingKt;
import org.jetbrains.plugins.groovy.codeInspection.style.string.GrStringStyleViolationInspection;
import org.jetbrains.plugins.groovy.codeInspection.style.string.GrStringTransformationFixFactoryKt;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.StringKind;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0003\"#$B\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0018\u001a\u00020\u00192\u0016\u0010\u001a\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001c0\u001b\"\u0004\u0018\u00010\u001cH\u0014\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020!H\u0014R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u001a\u0010\u0015\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\b\u00a8\u0006%"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/style/string/GrStringStyleViolationInspection;", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspection;", "()V", "escapedStringQuotation", "Lorg/jetbrains/plugins/groovy/codeInspection/style/string/GrStringStyleViolationInspection$InspectionStringQuotationKind;", "getEscapedStringQuotation$intellij_groovy_psi", "()Lorg/jetbrains/plugins/groovy/codeInspection/style/string/GrStringStyleViolationInspection$InspectionStringQuotationKind;", "setEscapedStringQuotation$intellij_groovy_psi", "(Lorg/jetbrains/plugins/groovy/codeInspection/style/string/GrStringStyleViolationInspection$InspectionStringQuotationKind;)V", "inspectGradle", "", "getInspectGradle$intellij_groovy_psi", "()Z", "setInspectGradle$intellij_groovy_psi", "(Z)V", "interpolatedStringQuotation", "getInterpolatedStringQuotation$intellij_groovy_psi", "setInterpolatedStringQuotation$intellij_groovy_psi", "multilineStringQuotation", "getMultilineStringQuotation$intellij_groovy_psi", "setMultilineStringQuotation$intellij_groovy_psi", "plainStringQuotation", "getPlainStringQuotation$intellij_groovy_psi", "setPlainStringQuotation$intellij_groovy_psi", "buildErrorString", "", "args", "", "", "([Ljava/lang/Object;)Ljava/lang/String;", "buildVisitor", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor;", "getGroovyOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "Companion", "InspectionStringQuotationKind", "StringUsageKind", "intellij.groovy.psi"})
public final class GrStringStyleViolationInspection
extends BaseInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private volatile InspectionStringQuotationKind plainStringQuotation = InspectionStringQuotationKind.SINGLE_QUOTED;
    @NotNull
    private volatile InspectionStringQuotationKind escapedStringQuotation = InspectionStringQuotationKind.UNDEFINED;
    @NotNull
    private volatile InspectionStringQuotationKind interpolatedStringQuotation = InspectionStringQuotationKind.UNDEFINED;
    @NotNull
    private volatile InspectionStringQuotationKind multilineStringQuotation = InspectionStringQuotationKind.TRIPLE_QUOTED;
    private volatile boolean inspectGradle = true;
    @NotNull
    private static final InspectionStringQuotationKind[] PLAIN_STRING_OPTIONS;
    @NotNull
    private static final InspectionStringQuotationKind[] MULTILINE_STRING_OPTIONS;
    @NotNull
    private static final InspectionStringQuotationKind[] ESCAPED_STRING_OPTIONS;
    @NotNull
    private static final InspectionStringQuotationKind[] INTERPOLATED_STRING_OPTIONS;

    @NotNull
    public final InspectionStringQuotationKind getPlainStringQuotation$intellij_groovy_psi() {
        return this.plainStringQuotation;
    }

    public final void setPlainStringQuotation$intellij_groovy_psi(@NotNull InspectionStringQuotationKind inspectionStringQuotationKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)inspectionStringQuotationKind), (String)"<set-?>");
        this.plainStringQuotation = inspectionStringQuotationKind;
    }

    @NotNull
    public final InspectionStringQuotationKind getEscapedStringQuotation$intellij_groovy_psi() {
        return this.escapedStringQuotation;
    }

    public final void setEscapedStringQuotation$intellij_groovy_psi(@NotNull InspectionStringQuotationKind inspectionStringQuotationKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)inspectionStringQuotationKind), (String)"<set-?>");
        this.escapedStringQuotation = inspectionStringQuotationKind;
    }

    @NotNull
    public final InspectionStringQuotationKind getInterpolatedStringQuotation$intellij_groovy_psi() {
        return this.interpolatedStringQuotation;
    }

    public final void setInterpolatedStringQuotation$intellij_groovy_psi(@NotNull InspectionStringQuotationKind inspectionStringQuotationKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)inspectionStringQuotationKind), (String)"<set-?>");
        this.interpolatedStringQuotation = inspectionStringQuotationKind;
    }

    @NotNull
    public final InspectionStringQuotationKind getMultilineStringQuotation$intellij_groovy_psi() {
        return this.multilineStringQuotation;
    }

    public final void setMultilineStringQuotation$intellij_groovy_psi(@NotNull InspectionStringQuotationKind inspectionStringQuotationKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)inspectionStringQuotationKind), (String)"<set-?>");
        this.multilineStringQuotation = inspectionStringQuotationKind;
    }

    public final boolean getInspectGradle$intellij_groovy_psi() {
        return this.inspectGradle;
    }

    public final void setInspectGradle$intellij_groovy_psi(boolean bl) {
        this.inspectGradle = bl;
    }

    @Override
    @NotNull
    protected OptPane getGroovyOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[2];
        String string = GroovyBundle.message("separator.preferable.string.kind", new Object[0]);
        OptRegularComponent[] optRegularComponentArray2 = new OptRegularComponent[4];
        String string2 = GroovyBundle.message("string.sort.default", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"string.sort.default\")");
        optRegularComponentArray2[0] = GrStringStyleViolationInspection.getGroovyOptionsPane$combobox("plainStringQuotation", string2, PLAIN_STRING_OPTIONS);
        String string3 = GroovyBundle.message("string.sort.strings.with.escaping", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"string.sort.strings.with.escaping\")");
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)InspectionStringQuotationKind.UNDEFINED);
        spreadBuilder.addSpread((Object)ESCAPED_STRING_OPTIONS);
        optRegularComponentArray2[1] = GrStringStyleViolationInspection.getGroovyOptionsPane$combobox("escapedStringQuotation", string3, (InspectionStringQuotationKind[])spreadBuilder.toArray((Object[])new InspectionStringQuotationKind[spreadBuilder.size()]));
        String string4 = GroovyBundle.message("string.sort.strings.with.interpolation", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"string.sort.strings.with.interpolation\")");
        spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)InspectionStringQuotationKind.UNDEFINED);
        spreadBuilder.addSpread((Object)INTERPOLATED_STRING_OPTIONS);
        optRegularComponentArray2[2] = GrStringStyleViolationInspection.getGroovyOptionsPane$combobox("interpolatedStringQuotation", string4, (InspectionStringQuotationKind[])spreadBuilder.toArray((Object[])new InspectionStringQuotationKind[spreadBuilder.size()]));
        String string5 = GroovyBundle.message("string.sort.multiline.string", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"string.sort.multiline.string\")");
        spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)InspectionStringQuotationKind.UNDEFINED);
        spreadBuilder.addSpread((Object)MULTILINE_STRING_OPTIONS);
        optRegularComponentArray2[3] = GrStringStyleViolationInspection.getGroovyOptionsPane$combobox("multilineStringQuotation", string5, (InspectionStringQuotationKind[])spreadBuilder.toArray((Object[])new InspectionStringQuotationKind[spreadBuilder.size()]));
        optRegularComponentArray[0] = OptPane.group((String)string, (OptRegularComponent[])optRegularComponentArray2);
        optRegularComponentArray2 = new OptRegularComponent[]{OptPane.checkbox((String)"inspectGradle", (String)GroovyBundle.message("checkbox.inspect.gradle.files", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])};
        optRegularComponentArray[1] = OptPane.group((String)GroovyBundle.message("separator.domain.of.inspection.usage", new Object[0]), (OptRegularComponent[])optRegularComponentArray2);
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(\n      group(Groovy\u2026ct.gradle.files\")))\n    )");
        return optPane;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object object = args[1];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.plugins.groovy.codeInspection.style.string.GrStringStyleViolationInspection.InspectionStringQuotationKind");
        InspectionStringQuotationKind targetQuotationKind = (InspectionStringQuotationKind)((Object)object);
        Object object2 = args[0];
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.jetbrains.plugins.groovy.codeInspection.style.string.GrStringStyleViolationInspection.StringUsageKind");
        switch (WhenMappings.$EnumSwitchMapping$1[((StringUsageKind)((Object)object2)).ordinal()]) {
            case 1: {
                String string2 = switch (WhenMappings.$EnumSwitchMapping$0[targetQuotationKind.ordinal()]) {
                    case 1 -> GroovyBundle.message("inspection.message.plain.string.should.be.double.quoted", new Object[0]);
                    case 2 -> GroovyBundle.message("inspection.message.plain.string.should.be.single.quoted", new Object[0]);
                    case 3 -> GroovyBundle.message("inspection.message.plain.string.should.be.slashy.quoted", new Object[0]);
                    case 4 -> GroovyBundle.message("inspection.message.plain.string.should.be.dollar.slashy.quoted", new Object[0]);
                    case 5 -> GroovyBundle.message("inspection.message.plain.string.should.be.quoted.with.triple.quotes", new Object[0]);
                    case 6 -> GroovyBundle.message("inspection.message.plain.string.should.be.quoted.with.triple.double.quotes", new Object[0]);
                    default -> throw new IllegalStateException("Unexpected error message".toString());
                };
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"when (targetQuotationKin\u2026d error message\")\n      }");
                break;
            }
            case 2: {
                String string3 = switch (WhenMappings.$EnumSwitchMapping$0[targetQuotationKind.ordinal()]) {
                    case 5 -> GroovyBundle.message("inspection.message.multiline.string.should.be.quoted.with.triple.quotes", new Object[0]);
                    case 6 -> GroovyBundle.message("inspection.message.multiline.string.should.be.quoted.with.triple.double.quotes", new Object[0]);
                    case 3 -> GroovyBundle.message("inspection.message.multiline.string.should.be.slashy.quoted", new Object[0]);
                    case 4 -> GroovyBundle.message("inspection.message.multiline.string.should.be.dollar.slashy.quoted", new Object[0]);
                    default -> throw new IllegalStateException("Unexpected error message".toString());
                };
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"when (targetQuotationKin\u2026d error message\")\n      }");
                break;
            }
            case 3: {
                String string4 = GroovyBundle.message("inspection.message.string.escaping.could.be.minimized", new Object[0]);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"inspection.mess\u2026ping.could.be.minimized\")");
                break;
            }
            case 4: {
                String string5 = switch (WhenMappings.$EnumSwitchMapping$0[targetQuotationKind.ordinal()]) {
                    case 1 -> GroovyBundle.message("inspection.message.interpolated.string.should.be.double.quoted", new Object[0]);
                    case 4 -> GroovyBundle.message("inspection.message.interpolated.string.should.be.dollar.slashy.quoted", new Object[0]);
                    case 3 -> GroovyBundle.message("inspection.message.interpolated.string.should.be.slashy.quoted", new Object[0]);
                    case 6 -> GroovyBundle.message("inspection.message.interpolated.string.should.be.quoted.with.triple.double.quotes", new Object[0]);
                    default -> throw new IllegalStateException("Unexpected error message".toString());
                };
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"when (targetQuotationKin\u2026d error message\")\n      }");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(this){
            final /* synthetic */ GrStringStyleViolationInspection this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitLiteralExpression(@NotNull GrLiteral literal) {
                Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
                if (!this.this$0.getInspectGradle$intellij_groovy_psi()) {
                    String string = literal.getContainingFile().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"literal.containingFile.name");
                    if (StringsKt.endsWith$default((String)string, (String)"gradle", (boolean)false, (int)2, null)) {
                        return;
                    }
                }
                if (literal instanceof GrString) {
                    this.handleGString(literal);
                } else if (!Intrinsics.areEqual((Object)GrStringUtil.getStartQuote(literal.getText()), (Object)"")) {
                    this.handlePlainString(literal);
                }
                super.visitLiteralExpression(literal);
            }

            private final void handleGString(GrLiteral literal) {
                this.checkInconsistency(this.this$0.getInterpolatedStringQuotation$intellij_groovy_psi(), literal, StringUsageKind.INTERPOLATED_STRING, GrStringStyleViolationInspection.access$getINTERPOLATED_STRING_OPTIONS$cp());
            }

            private final void handlePlainString(GrLiteral literal) {
                String literalText = literal.getText();
                if (this.this$0.getMultilineStringQuotation$intellij_groovy_psi() != InspectionStringQuotationKind.UNDEFINED && GrStringUtil.isMultilineStringLiteral(literal)) {
                    Intrinsics.checkNotNullExpressionValue((Object)literalText, (String)"literalText");
                    if (StringsKt.contains$default((CharSequence)literalText, (CharSequence)"\n", (boolean)false, (int)2, null)) {
                        this.checkInconsistency(this.this$0.getMultilineStringQuotation$intellij_groovy_psi(), literal, StringUsageKind.MULTILINE_STRING, GrStringStyleViolationInspection.access$getMULTILINE_STRING_OPTIONS$cp());
                        return;
                    }
                }
                if (this.this$0.getEscapedStringQuotation$intellij_groovy_psi() != InspectionStringQuotationKind.UNDEFINED) {
                    Intrinsics.checkNotNullExpressionValue((Object)literalText, (String)"literalText");
                    Pair<InspectionStringQuotationKind, Integer> bestEscaping2 = EscapingKt.findBestQuotationForEscaping(literalText, this.this$0.getEscapedStringQuotation$intellij_groovy_psi(), this.this$0.getPlainStringQuotation$intellij_groovy_psi());
                    if (bestEscaping2 != null) {
                        if (((Number)bestEscaping2.getSecond()).intValue() != 0) {
                            this.checkInconsistency((InspectionStringQuotationKind)((Object)bestEscaping2.getFirst()), literal, StringUsageKind.ESCAPED_STRING, GrStringStyleViolationInspection.access$getESCAPED_STRING_OPTIONS$cp());
                        }
                        return;
                    }
                }
                Intrinsics.checkNotNullExpressionValue((Object)literalText, (String)"literalText");
                if (!StringsKt.contains$default((CharSequence)literalText, (CharSequence)"\n", (boolean)false, (int)2, null)) {
                    this.checkInconsistency(this.this$0.getPlainStringQuotation$intellij_groovy_psi(), literal, StringUsageKind.PLAIN_STRING, GrStringStyleViolationInspection.access$getPLAIN_STRING_OPTIONS$cp());
                }
            }

            private final void checkInconsistency(InspectionStringQuotationKind expected, GrLiteral literal, StringUsageKind usageKind, InspectionStringQuotationKind[] availableStringKinds) {
                if (!ArraysKt.contains((Object[])availableStringKinds, (Object)((Object)expected))) {
                    return;
                }
                switch (buildVisitor.WhenMappings.$EnumSwitchMapping$0[expected.ordinal()]) {
                    case 1: {
                        buildVisitor.1.checkInconsistency$doCheck(literal, this.this$0, usageKind, expected, this, (Function1<? super GrLiteral, Boolean>)((Function1)buildVisitor.checkInconsistency.1.INSTANCE));
                        break;
                    }
                    case 2: {
                        buildVisitor.1.checkInconsistency$doCheck(literal, this.this$0, usageKind, expected, this, (Function1<? super GrLiteral, Boolean>)((Function1)buildVisitor.checkInconsistency.2.INSTANCE));
                        break;
                    }
                    case 3: {
                        buildVisitor.1.checkInconsistency$doCheck(literal, this.this$0, usageKind, expected, this, (Function1<? super GrLiteral, Boolean>)((Function1)buildVisitor.checkInconsistency.3.INSTANCE));
                        break;
                    }
                    case 4: {
                        buildVisitor.1.checkInconsistency$doCheck(literal, this.this$0, usageKind, expected, this, (Function1<? super GrLiteral, Boolean>)((Function1)buildVisitor.checkInconsistency.4.INSTANCE));
                        break;
                    }
                    case 5: {
                        buildVisitor.1.checkInconsistency$doCheck(literal, this.this$0, usageKind, expected, this, (Function1<? super GrLiteral, Boolean>)((Function1)buildVisitor.checkInconsistency.5.INSTANCE));
                        break;
                    }
                    case 6: {
                        buildVisitor.1.checkInconsistency$doCheck(literal, this.this$0, usageKind, expected, this, (Function1<? super GrLiteral, Boolean>)((Function1)buildVisitor.checkInconsistency.6.INSTANCE));
                        break;
                    }
                }
            }

            private static final void checkInconsistency$doCheck(GrLiteral $literal, GrStringStyleViolationInspection this$0, StringUsageKind $usageKind, InspectionStringQuotationKind $expected, buildVisitor.1 this$1, Function1<? super GrLiteral, Boolean> predicate) {
                if (!((Boolean)predicate.invoke((Object)$literal)).booleanValue()) {
                    GroovyFix[] groovyFixArray;
                    Object[] objectArray = new Object[]{$usageKind, $expected};
                    String description = this$0.buildErrorString(objectArray);
                    StringKind stringKind = org.jetbrains.plugins.groovy.codeInspection.style.string.GrStringStyleViolationInspection$Companion.access$getActualKind(GrStringStyleViolationInspection.Companion, $expected);
                    if (stringKind != null) {
                        StringKind it = stringKind;
                        boolean bl = false;
                        GroovyFix[] groovyFixArray2 = new GroovyFix[]{GrStringTransformationFixFactoryKt.getStringTransformationFix(it)};
                        groovyFixArray = groovyFixArray2;
                    } else {
                        boolean $i$f$emptyArray = false;
                        groovyFixArray = new GroovyFix[]{};
                    }
                    GroovyFix[] fixes = groovyFixArray;
                    this$1.registerError((PsiElement)$literal, description, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }
        };
    }

    private static final String getGroovyOptionsPane$combobox$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String getGroovyOptionsPane$combobox$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final OptDropdown getGroovyOptionsPane$combobox(@Language(value="jvm-field-name") String bindId, String splitLabel, InspectionStringQuotationKind[] values) {
        OptDropdown optDropdown = OptPane.dropdown((String)bindId, (String)splitLabel, (Collection)ArraysKt.asList((Object[])values), arg_0 -> GrStringStyleViolationInspection.getGroovyOptionsPane$combobox$lambda$0((Function1)getGroovyOptionsPane.combobox.1.INSTANCE, arg_0), arg_0 -> GrStringStyleViolationInspection.getGroovyOptionsPane$combobox$lambda$1(getGroovyOptionsPane.combobox.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)optDropdown, (String)"dropdown(bindId, splitLa\u2026tionKind::representation)");
        return optDropdown;
    }

    public static final /* synthetic */ InspectionStringQuotationKind[] access$getINTERPOLATED_STRING_OPTIONS$cp() {
        return INTERPOLATED_STRING_OPTIONS;
    }

    public static final /* synthetic */ InspectionStringQuotationKind[] access$getMULTILINE_STRING_OPTIONS$cp() {
        return MULTILINE_STRING_OPTIONS;
    }

    public static final /* synthetic */ InspectionStringQuotationKind[] access$getESCAPED_STRING_OPTIONS$cp() {
        return ESCAPED_STRING_OPTIONS;
    }

    public static final /* synthetic */ InspectionStringQuotationKind[] access$getPLAIN_STRING_OPTIONS$cp() {
        return PLAIN_STRING_OPTIONS;
    }

    static {
        InspectionStringQuotationKind[] inspectionStringQuotationKindArray = new InspectionStringQuotationKind[]{InspectionStringQuotationKind.DOUBLE_QUOTED, InspectionStringQuotationKind.SINGLE_QUOTED, InspectionStringQuotationKind.SLASHY, InspectionStringQuotationKind.TRIPLE_QUOTED, InspectionStringQuotationKind.TRIPLE_DOUBLE_QUOTED, InspectionStringQuotationKind.DOLLAR_SLASHY_QUOTED};
        PLAIN_STRING_OPTIONS = inspectionStringQuotationKindArray;
        inspectionStringQuotationKindArray = new InspectionStringQuotationKind[]{InspectionStringQuotationKind.TRIPLE_QUOTED, InspectionStringQuotationKind.SLASHY, InspectionStringQuotationKind.TRIPLE_DOUBLE_QUOTED, InspectionStringQuotationKind.DOLLAR_SLASHY_QUOTED};
        MULTILINE_STRING_OPTIONS = inspectionStringQuotationKindArray;
        inspectionStringQuotationKindArray = new InspectionStringQuotationKind[]{InspectionStringQuotationKind.DOUBLE_QUOTED, InspectionStringQuotationKind.SINGLE_QUOTED, InspectionStringQuotationKind.SLASHY, InspectionStringQuotationKind.TRIPLE_QUOTED, InspectionStringQuotationKind.TRIPLE_DOUBLE_QUOTED, InspectionStringQuotationKind.DOLLAR_SLASHY_QUOTED};
        ESCAPED_STRING_OPTIONS = inspectionStringQuotationKindArray;
        inspectionStringQuotationKindArray = new InspectionStringQuotationKind[]{InspectionStringQuotationKind.DOUBLE_QUOTED, InspectionStringQuotationKind.SLASHY, InspectionStringQuotationKind.TRIPLE_DOUBLE_QUOTED, InspectionStringQuotationKind.DOLLAR_SLASHY_QUOTED};
        INTERPOLATED_STRING_OPTIONS = inspectionStringQuotationKindArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/style/string/GrStringStyleViolationInspection$Companion;", "", "()V", "ESCAPED_STRING_OPTIONS", "", "Lorg/jetbrains/plugins/groovy/codeInspection/style/string/GrStringStyleViolationInspection$InspectionStringQuotationKind;", "[Lorg/jetbrains/plugins/groovy/codeInspection/style/string/GrStringStyleViolationInspection$InspectionStringQuotationKind;", "INTERPOLATED_STRING_OPTIONS", "MULTILINE_STRING_OPTIONS", "PLAIN_STRING_OPTIONS", "getActualKind", "Lorg/jetbrains/plugins/groovy/lang/psi/util/StringKind;", "kind", "intellij.groovy.psi"})
    public static final class Companion {
        private Companion() {
        }

        private final StringKind getActualKind(InspectionStringQuotationKind kind) {
            return switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1 -> null;
                case 2 -> StringKind.DOUBLE_QUOTED;
                case 3 -> StringKind.SINGLE_QUOTED;
                case 4 -> StringKind.SLASHY;
                case 5 -> StringKind.TRIPLE_SINGLE_QUOTED;
                case 6 -> StringKind.TRIPLE_DOUBLE_QUOTED;
                case 7 -> StringKind.DOLLAR_SLASHY;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public static final /* synthetic */ StringKind access$getActualKind(Companion $this, InspectionStringQuotationKind kind) {
            return $this.getActualKind(kind);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[InspectionStringQuotationKind.values().length];
                try {
                    nArray[InspectionStringQuotationKind.UNDEFINED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[InspectionStringQuotationKind.DOUBLE_QUOTED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[InspectionStringQuotationKind.SINGLE_QUOTED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[InspectionStringQuotationKind.SLASHY.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[InspectionStringQuotationKind.TRIPLE_QUOTED.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[InspectionStringQuotationKind.TRIPLE_DOUBLE_QUOTED.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[InspectionStringQuotationKind.DOLLAR_SLASHY_QUOTED.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/style/string/GrStringStyleViolationInspection$InspectionStringQuotationKind;", "", "(Ljava/lang/String;I)V", "representation", "", "UNDEFINED", "DOUBLE_QUOTED", "SINGLE_QUOTED", "SLASHY", "TRIPLE_QUOTED", "TRIPLE_DOUBLE_QUOTED", "DOLLAR_SLASHY_QUOTED", "intellij.groovy.psi"})
    public static final class InspectionStringQuotationKind
    extends Enum<InspectionStringQuotationKind> {
        public static final /* enum */ InspectionStringQuotationKind UNDEFINED = new InspectionStringQuotationKind();
        public static final /* enum */ InspectionStringQuotationKind DOUBLE_QUOTED = new InspectionStringQuotationKind();
        public static final /* enum */ InspectionStringQuotationKind SINGLE_QUOTED = new InspectionStringQuotationKind();
        public static final /* enum */ InspectionStringQuotationKind SLASHY = new InspectionStringQuotationKind();
        public static final /* enum */ InspectionStringQuotationKind TRIPLE_QUOTED = new InspectionStringQuotationKind();
        public static final /* enum */ InspectionStringQuotationKind TRIPLE_DOUBLE_QUOTED = new InspectionStringQuotationKind();
        public static final /* enum */ InspectionStringQuotationKind DOLLAR_SLASHY_QUOTED = new InspectionStringQuotationKind();
        private static final /* synthetic */ InspectionStringQuotationKind[] $VALUES;

        @Nls
        @NotNull
        public final String representation() {
            String string;
            switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    String string2 = GroovyBundle.message("string.option.do.not.handle.specifically", new Object[0]);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"string.option.d\u2026not.handle.specifically\")");
                    break;
                }
                case 2: {
                    String string3 = GroovyBundle.message("string.option.double.quoted.string", new Object[0]);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"string.option.double.quoted.string\")");
                    break;
                }
                case 3: {
                    String string4 = GroovyBundle.message("string.option.single.quoted.string", new Object[0]);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"string.option.single.quoted.string\")");
                    break;
                }
                case 4: {
                    String string5 = GroovyBundle.message("string.option.slashy.string", new Object[0]);
                    string = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"string.option.slashy.string\")");
                    break;
                }
                case 5: {
                    String string6 = GroovyBundle.message("string.option.triple.quoted.string", new Object[0]);
                    string = string6;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(\"string.option.triple.quoted.string\")");
                    break;
                }
                case 6: {
                    String string7 = GroovyBundle.message("string.option.triple.double.quoted.string", new Object[0]);
                    string = string7;
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(\"string.option.t\u2026le.double.quoted.string\")");
                    break;
                }
                case 7: {
                    String string8 = GroovyBundle.message("string.option.dollar.slashy.string", new Object[0]);
                    string = string8;
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"message(\"string.option.dollar.slashy.string\")");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        public static InspectionStringQuotationKind[] values() {
            return (InspectionStringQuotationKind[])$VALUES.clone();
        }

        public static InspectionStringQuotationKind valueOf(String value2) {
            return Enum.valueOf(InspectionStringQuotationKind.class, value2);
        }

        static {
            $VALUES = inspectionStringQuotationKindArray = new InspectionStringQuotationKind[]{InspectionStringQuotationKind.UNDEFINED, InspectionStringQuotationKind.DOUBLE_QUOTED, InspectionStringQuotationKind.SINGLE_QUOTED, InspectionStringQuotationKind.SLASHY, InspectionStringQuotationKind.TRIPLE_QUOTED, InspectionStringQuotationKind.TRIPLE_DOUBLE_QUOTED, InspectionStringQuotationKind.DOLLAR_SLASHY_QUOTED};
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[InspectionStringQuotationKind.values().length];
                try {
                    nArray[InspectionStringQuotationKind.UNDEFINED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[InspectionStringQuotationKind.DOUBLE_QUOTED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[InspectionStringQuotationKind.SINGLE_QUOTED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[InspectionStringQuotationKind.SLASHY.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[InspectionStringQuotationKind.TRIPLE_QUOTED.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[InspectionStringQuotationKind.TRIPLE_DOUBLE_QUOTED.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[InspectionStringQuotationKind.DOLLAR_SLASHY_QUOTED.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/style/string/GrStringStyleViolationInspection$StringUsageKind;", "", "(Ljava/lang/String;I)V", "PLAIN_STRING", "MULTILINE_STRING", "ESCAPED_STRING", "INTERPOLATED_STRING", "intellij.groovy.psi"})
    private static final class StringUsageKind
    extends Enum<StringUsageKind> {
        public static final /* enum */ StringUsageKind PLAIN_STRING = new StringUsageKind();
        public static final /* enum */ StringUsageKind MULTILINE_STRING = new StringUsageKind();
        public static final /* enum */ StringUsageKind ESCAPED_STRING = new StringUsageKind();
        public static final /* enum */ StringUsageKind INTERPOLATED_STRING = new StringUsageKind();
        private static final /* synthetic */ StringUsageKind[] $VALUES;

        public static StringUsageKind[] values() {
            return (StringUsageKind[])$VALUES.clone();
        }

        public static StringUsageKind valueOf(String value2) {
            return Enum.valueOf(StringUsageKind.class, value2);
        }

        static {
            $VALUES = stringUsageKindArray = new StringUsageKind[]{StringUsageKind.PLAIN_STRING, StringUsageKind.MULTILINE_STRING, StringUsageKind.ESCAPED_STRING, StringUsageKind.INTERPOLATED_STRING};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[InspectionStringQuotationKind.values().length];
            try {
                nArray[InspectionStringQuotationKind.DOUBLE_QUOTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InspectionStringQuotationKind.SINGLE_QUOTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InspectionStringQuotationKind.SLASHY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InspectionStringQuotationKind.DOLLAR_SLASHY_QUOTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InspectionStringQuotationKind.TRIPLE_QUOTED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InspectionStringQuotationKind.TRIPLE_DOUBLE_QUOTED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[StringUsageKind.values().length];
            try {
                nArray[StringUsageKind.PLAIN_STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StringUsageKind.MULTILINE_STRING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StringUsageKind.ESCAPED_STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StringUsageKind.INTERPOLATED_STRING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

