/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.highlighter.GroovySyntaxHighlighter;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public final class GrInspectionUtil {
    public static boolean isNull(@NotNull GrExpression expression) {
        if (expression == null) {
            GrInspectionUtil.$$$reportNull$$$0(0);
        }
        return "null".equals(expression.getText());
    }

    public static boolean isEquality(@NotNull GrBinaryExpression binaryCondition) {
        IElementType tokenType;
        if (binaryCondition == null) {
            GrInspectionUtil.$$$reportNull$$$0(1);
        }
        return GroovyTokenTypes.mEQUAL == (tokenType = binaryCondition.getOperationTokenType());
    }

    public static boolean isInequality(@NotNull GrBinaryExpression binaryCondition) {
        IElementType tokenType;
        if (binaryCondition == null) {
            GrInspectionUtil.$$$reportNull$$$0(2);
        }
        return GroovyTokenTypes.mNOT_EQUAL == (tokenType = binaryCondition.getOperationTokenType());
    }

    @NotNull
    public static HighlightInfo.Builder createAnnotationForRef(@NotNull GrReferenceElement ref2, @NotNull HighlightDisplayLevel displayLevel, @NotNull @NlsContexts.DetailedDescription String message) {
        if (ref2 == null) {
            GrInspectionUtil.$$$reportNull$$$0(3);
        }
        if (displayLevel == null) {
            GrInspectionUtil.$$$reportNull$$$0(4);
        }
        if (message == null) {
            GrInspectionUtil.$$$reportNull$$$0(5);
        }
        PsiElement refNameElement = ref2.getReferenceNameElement();
        assert (refNameElement != null);
        if (displayLevel == HighlightDisplayLevel.ERROR) {
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range(refNameElement).descriptionAndTooltip(message);
            if (builder == null) {
                GrInspectionUtil.$$$reportNull$$$0(6);
            }
            return builder;
        }
        if (displayLevel == HighlightDisplayLevel.WEAK_WARNING) {
            boolean isTestMode = ApplicationManager.getApplication().isUnitTestMode();
            HighlightInfoType infotype = isTestMode ? HighlightInfoType.WARNING : HighlightInfoType.INFORMATION;
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)infotype).range(refNameElement);
            builder.descriptionAndTooltip(message);
            HighlightInfo.Builder builder2 = builder.needsUpdateOnTyping(false).textAttributes(GroovySyntaxHighlighter.UNRESOLVED_ACCESS);
            if (builder2 == null) {
                GrInspectionUtil.$$$reportNull$$$0(7);
            }
            return builder2;
        }
        HighlightInfoType highlightInfoType = HighlightInfo.convertSeverity((HighlightSeverity)displayLevel.getSeverity());
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType).range(refNameElement).descriptionAndTooltip(message);
        if (builder == null) {
            GrInspectionUtil.$$$reportNull$$$0(8);
        }
        return builder;
    }

    public static void replaceExpression(GrExpression expression, @NlsSafe String newExpression) {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(expression.getProject());
        GrExpression newCall = factory.createExpressionFromText(newExpression, expression.getContext());
        expression.replaceWithExpression(newCall, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryCondition";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayLevel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/GrInspectionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/GrInspectionUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotationForRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isNull";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isEquality";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInequality";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationForRef";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

