/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.annotator.intentions.AddToReferenceListFixKt;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u001f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\b\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\u0005H\u0016J\u0017\u0010\u001a\u001a\t\u0018\u00010\u001b\u00a2\u0006\u0002\b\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0003\u001d\u001e\u001f\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/AddToReferenceListFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "role", "Lcom/intellij/psi/PsiReferenceList$Role;", "addedName", "", "hostClassName", "(Lcom/intellij/psi/PsiReferenceList$Role;Ljava/lang/String;Ljava/lang/String;)V", "appendReferenceList", "", "dependentClass", "Lcom/intellij/psi/PsiClass;", "listToInsert", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrReferenceList;", "applyFix", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "generateNewList", "Lkotlin/Pair;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "getFamilyName", "getName", "getReplacedList", "Lcom/intellij/psi/PsiReferenceList;", "Lorg/jetbrains/annotations/Nullable;", "Lorg/jetbrains/plugins/groovy/annotator/intentions/AddToExtendsList;", "Lorg/jetbrains/plugins/groovy/annotator/intentions/AddToImplementsList;", "Lorg/jetbrains/plugins/groovy/annotator/intentions/AddToPermitsList;", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nAddToReferenceListFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddToReferenceListFix.kt\norg/jetbrains/plugins/groovy/annotator/intentions/AddToReferenceListFix\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,85:1\n10#2:86\n10#2:89\n10#2:90\n57#3,2:87\n*S KotlinDebug\n*F\n+ 1 AddToReferenceListFix.kt\norg/jetbrains/plugins/groovy/annotator/intentions/AddToReferenceListFix\n*L\n29#1:86\n31#1:89\n41#1:90\n30#1:87,2\n*E\n"})
public abstract class AddToReferenceListFix
implements LocalQuickFix {
    @NotNull
    private final PsiReferenceList.Role role;
    @NotNull
    private final String addedName;
    @NotNull
    private final String hostClassName;

    private AddToReferenceListFix(PsiReferenceList.Role role, String addedName, String hostClassName) {
        this.role = role;
        this.addedName = addedName;
        this.hostClassName = hostClassName;
    }

    @NotNull
    public String getName() {
        Object[] objectArray = new Object[]{this.addedName, AddToReferenceListFixKt.access$getRepresentation(this.role), this.hostClassName};
        String string = GroovyBundle.message("intention.name.add.to.clause", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"intention.name.\u2026ntation(), hostClassName)");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Pair<PsiClass, GrReferenceList> pair = this.generateNewList(descriptor2);
        if (pair == null) {
            return;
        }
        Pair<PsiClass, GrReferenceList> pair2 = pair;
        PsiClass dependentClass = (PsiClass)pair2.component1();
        GrReferenceList listToInsert = (GrReferenceList)pair2.component2();
        this.appendReferenceList(dependentClass, listToInsert);
    }

    /*
     * Unable to fully structure code
     */
    private final Pair<PsiClass, GrReferenceList> generateNewList(ProblemDescriptor descriptor) {
        block16: {
            block15: {
                block14: {
                    block13: {
                        v0 = descriptor.getPsiElement();
                        if (v0 == null) break block13;
                        $this$asSafely$iv = v0;
                        $i$f$asSafely = false;
                        v1 = $this$asSafely$iv;
                        if (!(v1 instanceof GrCodeReferenceElement)) {
                            v1 = null;
                        }
                        if ((v0 = (GrCodeReferenceElement)v1) != null) break block14;
                    }
                    return null;
                }
                $this$parentOfType_u24default$iv = element = v0;
                withSelf$iv = false;
                $i$f$parentOfType = false;
                v2 = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PsiClass.class, (boolean)true);
                if (v2 == null) {
                    return null;
                }
                referencedClass = v2;
                v3 = element.resolve();
                if (v3 == null) break block15;
                $this$asSafely$iv = v3;
                $i$f$asSafely = false;
                v4 = $this$asSafely$iv;
                if (!(v4 instanceof PsiClass)) {
                    v4 = null;
                }
                if ((v3 = (PsiClass)v4) != null) break block16;
            }
            return null;
        }
        dependentClass = v3;
        targetReferenceList = this.getReplacedList((PsiClass)dependentClass);
        if (targetReferenceList == null) ** GOTO lbl-1000
        v5 = targetReferenceList.getReferenceElements();
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"targetReferenceList.referenceElements");
        if (((Object[])v5).length == 0) lbl-1000:
        // 2 sources

        {
            v6 = AddToReferenceListFixKt.access$getRepresentation(this.role) + " " + referencedClass.getQualifiedName();
        } else {
            v6 = targetReferenceList.getText() + ", " + referencedClass.getQualifiedName();
        }
        referencesRepresentation = v6;
        v7 = GroovyPsiElementFactory.getInstance(referencedClass.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getInstance(referencedClass.project)");
        factory = v7;
        v8 = factory.createTypeDefinition("class __Dummy " + referencesRepresentation + " {}");
        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"factory.createTypeDefini\u2026rencesRepresentation {}\")");
        typeDefinition = v8;
        $this$asSafely$iv = this.getReplacedList(typeDefinition);
        $i$f$asSafely = false;
        v9 = $this$asSafely$iv;
        if (!(v9 instanceof GrReferenceList)) {
            v9 = null;
        }
        v10 = (GrReferenceList)v9;
        if (v10 == null) {
            return null;
        }
        return TuplesKt.to((Object)dependentClass, (Object)v10);
    }

    private final PsiReferenceList getReplacedList(PsiClass dependentClass) {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.role.ordinal()]) {
            case 1 -> dependentClass.getExtendsList();
            case 2 -> dependentClass.getImplementsList();
            case 3 -> dependentClass.getPermitsList();
            default -> throw new IllegalStateException("Unexpected".toString());
        };
    }

    private final void appendReferenceList(PsiClass dependentClass, GrReferenceList listToInsert) {
        PsiReferenceList listToReplace = this.getReplacedList(dependentClass);
        if (listToReplace == null) {
            dependentClass.addAfter((PsiElement)listToInsert, (PsiElement)dependentClass.getNameIdentifier());
        } else {
            listToReplace.replace((PsiElement)listToInsert);
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        Pair<PsiClass, GrReferenceList> pair = this.generateNewList(previewDescriptor);
        if (pair == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }
        Pair<PsiClass, GrReferenceList> pair2 = pair;
        PsiClass dependentClass = (PsiClass)pair2.component1();
        GrReferenceList newList = (GrReferenceList)pair2.component2();
        PsiElement psiElement = dependentClass.copy();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiClass");
        PsiClass copy = (PsiClass)psiElement;
        this.appendReferenceList(copy, newList);
        return (IntentionPreviewInfo)new IntentionPreviewInfo.CustomDiff((FileType)GroovyFileType.GROOVY_FILE_TYPE, dependentClass.getText(), copy.getText());
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("intention.family.name.add.class.to.clause", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"intention.famil\u2026ame.add.class.to.clause\")");
        return string;
    }

    public /* synthetic */ AddToReferenceListFix(PsiReferenceList.Role role, String addedName, String hostClassName, DefaultConstructorMarker $constructor_marker) {
        this(role, addedName, hostClassName);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PsiReferenceList.Role.values().length];
            try {
                nArray[PsiReferenceList.Role.EXTENDS_LIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsiReferenceList.Role.IMPLEMENTS_LIST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsiReferenceList.Role.PERMITS_LIST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

