/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.util;

import com.intellij.indexing.shared.download.SharedIndexCompression;
import com.intellij.indexing.shared.util.ChunkedDownloader;
import com.intellij.indexing.shared.util.ChunkedDownloaderKt;
import com.intellij.indexing.shared.util.CountingInputStream;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\u001a8\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001aJ\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00122\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"acceptedMimeTypes", "", "decompressAndValidate", "", "compression", "Lcom/intellij/indexing/shared/download/SharedIndexCompression;", "targetFile", "Ljava/nio/file/Path;", "expectedSize", "", "expectedSha256", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "countingStream", "Lcom/intellij/indexing/shared/util/CountingInputStream;", "downloadUrlWithValidation", "url", "headers", "", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\ndownloadUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 downloadUtil.kt\ncom/intellij/indexing/shared/util/DownloadUtilKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,124:1\n215#2,2:125\n*S KotlinDebug\n*F\n+ 1 downloadUtil.kt\ncom/intellij/indexing/shared/util/DownloadUtilKt\n*L\n52#1:125,2\n*E\n"})
public final class DownloadUtilKt {
    @NotNull
    public static final String acceptedMimeTypes = "application/octet-stream, application/xz, application/x-xz";

    public static final long downloadUrlWithValidation(@NotNull String url, @NotNull Path targetFile, long expectedSize, @NotNull String expectedSha256, @NotNull Map<String, String> headers, @NotNull SharedIndexCompression compression, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter((Object)expectedSha256, (String)"expectedSha256");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)((Object)compression), (String)"compression");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        if (!(expectedSize > 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        try {
            int maxSize = Registry.get((String)"shared.indexes.download.chunk.size").asInteger();
            if (expectedSize > (long)(maxSize * 2) && ChunkedDownloaderKt.rangeAllowed(url, headers, expectedSize)) {
                ChunkedDownloader chunkedDownloader = new ChunkedDownloader(maxSize, Registry.get((String)"shared.indexes.download.chunk.threads").asInteger());
                chunkedDownloader.download(url, headers, expectedSize, indicator, (Function1<? super InputStream, Unit>)((Function1)new Function1<InputStream, Unit>(compression, targetFile, expectedSize, expectedSha256, indicator){
                    final /* synthetic */ SharedIndexCompression $compression;
                    final /* synthetic */ Path $targetFile;
                    final /* synthetic */ long $expectedSize;
                    final /* synthetic */ String $expectedSha256;
                    final /* synthetic */ ProgressIndicator $indicator;
                    {
                        this.$compression = $compression;
                        this.$targetFile = $targetFile;
                        this.$expectedSize = $expectedSize;
                        this.$expectedSha256 = $expectedSha256;
                        this.$indicator = $indicator;
                        super(1);
                    }

                    public final void invoke(@NotNull InputStream it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        DownloadUtilKt.access$decompressAndValidate(this.$compression, this.$targetFile, this.$expectedSize, this.$expectedSha256, this.$indicator, new CountingInputStream(it));
                    }
                }));
                return Files.size(targetFile);
            }
            HttpRequests.request((String)url).productNameAsUserAgent().tuner(arg_0 -> DownloadUtilKt.downloadUrlWithValidation$lambda$1(headers, arg_0)).accept(acceptedMimeTypes).throwStatusCodeException(true).connect(arg_0 -> DownloadUtilKt.downloadUrlWithValidation$lambda$2(compression, targetFile, expectedSize, expectedSha256, indicator, arg_0));
            return Files.size(targetFile);
        }
        catch (Throwable e) {
            FileUtil.delete((Path)targetFile);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void decompressAndValidate(SharedIndexCompression compression, Path targetFile, long expectedSize, String expectedSha256, ProgressIndicator indicator, CountingInputStream countingStream) {
        Path path = targetFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"targetFile.parent");
        PathKt.createDirectories((Path)path);
        Closeable closeable = compression.createUnpackingStream(countingStream);
        Throwable throwable = null;
        try {
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = PathKt.outputStream$default((Path)targetFile, (boolean)false, (OpenOption[])new OpenOption[0], (int)1, null);
            int n = 0x100000;
            closeable2 = closeable2 instanceof BufferedOutputStream ? (BufferedOutputStream)closeable2 : new BufferedOutputStream((OutputStream)closeable2, n);
            Throwable throwable2 = null;
            try {
                BufferedOutputStream output = (BufferedOutputStream)closeable2;
                boolean bl2 = false;
                byte[] buff = new byte[0x100000];
                while (true) {
                    indicator.checkCanceled();
                    int off = input.read(buff);
                    if (off < 0) break;
                    if (off <= 0) continue;
                    output.write(buff, 0, off);
                    if (countingStream.getBytesRead() > expectedSize) {
                        throw new RuntimeException("Connection is not closed at byte " + countingStream.getBytesRead() + ". Expected " + expectedSize + " bytes");
                    }
                    indicator.setFraction(Math.min(1.0, (double)countingStream.getBytesRead() / (double)expectedSize));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        if (countingStream.getBytesRead() < expectedSize) {
            throw new RuntimeException("Connection closed at byte " + countingStream.getBytesRead() + ". Expected " + expectedSize + " bytes");
        }
        String string = countingStream.getHasher().hash().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"countingStream.hasher.hash().toString()");
        String actualHashCode = string;
        if (!StringsKt.equals((String)actualHashCode, (String)expectedSha256, (boolean)true)) {
            throw new RuntimeException("SHA-256 checksums does not match. Actual value is " + actualHashCode + ", expected " + expectedSha256);
        }
    }

    private static final void downloadUrlWithValidation$lambda$1(Map $headers, URLConnection tuner) {
        Intrinsics.checkNotNullParameter((Object)$headers, (String)"$headers");
        Intrinsics.checkNotNullParameter((Object)tuner, (String)"tuner");
        Map $this$forEach$iv = $headers;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            tuner.addRequestProperty(k, v);
        }
    }

    private static final Unit downloadUrlWithValidation$lambda$2(SharedIndexCompression $compression, Path $targetFile, long $expectedSize, String $expectedSha256, ProgressIndicator $indicator, HttpRequests.Request it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$compression), (String)"$compression");
        Intrinsics.checkNotNullParameter((Object)$targetFile, (String)"$targetFile");
        Intrinsics.checkNotNullParameter((Object)$expectedSha256, (String)"$expectedSha256");
        Intrinsics.checkNotNullParameter((Object)$indicator, (String)"$indicator");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        InputStream inputStream = it.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"it.inputStream");
        DownloadUtilKt.decompressAndValidate($compression, $targetFile, $expectedSize, $expectedSha256, $indicator, new CountingInputStream(inputStream));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$decompressAndValidate(SharedIndexCompression compression, Path targetFile, long expectedSize, String expectedSha256, ProgressIndicator indicator, CountingInputStream countingStream) {
        DownloadUtilKt.decompressAndValidate(compression, targetFile, expectedSize, expectedSha256, indicator, countingStream);
    }
}

