/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.intellij.indexing.shared.download.DownloadTaskContext;
import com.intellij.indexing.shared.download.ShadeIndexDumbModeTrackerTopicListener;
import com.intellij.indexing.shared.download.SharedIndexDownloadExecutor;
import com.intellij.indexing.shared.download.SharedIndexDownloadLoggerKt;
import com.intellij.indexing.shared.download.SharedIndexDumbModeTrackingKt;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.RelayUiToDelegateIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtScheduledExecutorService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016J)\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\t0\u000e\u00a2\u0006\u0002\b\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexDownloadExecutor;", "Lcom/intellij/openapi/Disposable;", "()V", "isDisposed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "oneThreadExecutor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "dispose", "", "submitPreProgressSync", "project", "Lcom/intellij/openapi/project/Project;", "action", "Lkotlin/Function1;", "Lcom/intellij/indexing/shared/download/DownloadTaskContext;", "Lkotlin/ExtensionFunctionType;", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nSharedIndexDownloadExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexDownloadExecutor.kt\ncom/intellij/indexing/shared/download/SharedIndexDownloadExecutor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,224:1\n1855#2,2:225\n*S KotlinDebug\n*F\n+ 1 SharedIndexDownloadExecutor.kt\ncom/intellij/indexing/shared/download/SharedIndexDownloadExecutor\n*L\n105#1:225,2\n*E\n"})
public final class SharedIndexDownloadExecutor
implements Disposable {
    @NotNull
    private final AtomicBoolean isDisposed = new AtomicBoolean(false);
    @NotNull
    private final ExecutorService oneThreadExecutor;

    public SharedIndexDownloadExecutor() {
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"SharedIndexesDownloader", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplication\u2026redIndexesDownloader\", 1)");
        this.oneThreadExecutor = executorService;
    }

    public void dispose() {
        this.isDisposed.set(true);
    }

    public final void submitPreProgressSync(@Nullable Project project, @NotNull Function1<? super DownloadTaskContext, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (this.isDisposed.get()) {
            return;
        }
        ProgressIndicatorBase rootIndicator = new ProgressIndicatorBase();
        AtomicBoolean isTaskCompleted = new AtomicBoolean(false);
        Condition<Object> condition2 = new Condition<Object>(rootIndicator, this, project){
            final /* synthetic */ ProgressIndicatorBase $rootIndicator;
            final /* synthetic */ SharedIndexDownloadExecutor this$0;
            final /* synthetic */ Project $project;
            {
                this.$rootIndicator = $rootIndicator;
                this.this$0 = $receiver;
                this.$project = $project;
            }

            public boolean value(@Nullable Object t) {
                return this.isExpired();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isExpired() {
                if (this.$rootIndicator.isCanceled()) return true;
                if (SharedIndexDownloadExecutor.access$isDisposed$p(this.this$0).get()) return true;
                Project project = this.$project;
                if (!(project != null ? (ComponentManager)project : (ComponentManager)ApplicationManager.getApplication()).isDisposed()) return false;
                return true;
            }
        };
        ModalityState modalityState = ApplicationManager.getApplication().getDefaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"getApplication().defaultModalityState");
        ModalityState modalityState2 = modalityState;
        this.oneThreadExecutor.submit(() -> SharedIndexDownloadExecutor.submitPreProgressSync$lambda$2(condition2, this, project, isTaskCompleted, rootIndicator, modalityState2, action));
    }

    private static final void submitPreProgressSync$lambda$2$lambda$1(Project $project, submitPreProgressSync.1.progressCancellation.1 $progressCancellation, Function1 $action, submitPreProgressSync.1.context.1 $context, ProgressIndicatorBase $rootIndicator) {
        Intrinsics.checkNotNullParameter((Object)$progressCancellation, (String)"$progressCancellation");
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$rootIndicator, (String)"$rootIndicator");
        if ($project != null && Registry.is((String)"shared.indexes.download.autoCancel")) {
            $project.getMessageBus().connect((Disposable)$progressCancellation).subscribe(SharedIndexDumbModeTrackingKt.getShadeIndexDumbModeTrackerTopic(), (Object)new ShadeIndexDumbModeTrackerTopicListener($rootIndicator){
                final /* synthetic */ ProgressIndicatorBase $rootIndicator;
                {
                    this.$rootIndicator = $rootIndicator;
                }

                public void onStableSmartModeDetected() {
                    SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Shared indexes download was cancelled. Indexing has completed faster");
                    this.$rootIndicator.cancel();
                }
            });
        }
        $action.invoke((Object)$context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void submitPreProgressSync$lambda$2(submitPreProgressSync.condition.1 $condition, SharedIndexDownloadExecutor this$0, Project $project, AtomicBoolean $isTaskCompleted, ProgressIndicatorBase $rootIndicator, ModalityState $modalityState, Function1 $action) {
        Intrinsics.checkNotNullParameter((Object)$condition, (String)"$condition");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$isTaskCompleted, (String)"$isTaskCompleted");
        Intrinsics.checkNotNullParameter((Object)$rootIndicator, (String)"$rootIndicator");
        Intrinsics.checkNotNullParameter((Object)$modalityState, (String)"$modalityState");
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        if ($condition.isExpired()) {
            return;
        }
        var progressCancellation2 = new Disposable($rootIndicator){
            @NotNull
            private final AtomicBoolean shouldCancelTheProgress;
            final /* synthetic */ ProgressIndicatorBase $rootIndicator;
            {
                this.$rootIndicator = $rootIndicator;
                this.shouldCancelTheProgress = new AtomicBoolean(true);
            }

            public final void doNotCancelProgress() {
                this.shouldCancelTheProgress.set(false);
            }

            public void dispose() {
                if (this.shouldCancelTheProgress.get()) {
                    this.$rootIndicator.cancel();
                }
            }
        };
        Object[] objectArray = new Disposable[]{this$0, $project};
        Iterable $this$forEach$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Disposable parent = (Disposable)element$iv;
            boolean bl = false;
            Disposer.register((Disposable)parent, (Disposable)progressCancellation2);
        }
        var context2 = new DownloadTaskContext($rootIndicator, progressCancellation2, $project, $condition, $isTaskCompleted, $modalityState){
            @NotNull
            private final AtomicBoolean hasProgress;
            final /* synthetic */ ProgressIndicatorBase $rootIndicator;
            final /* synthetic */ submitPreProgressSync.1.progressCancellation.1 $progressCancellation;
            final /* synthetic */ Project $project;
            final /* synthetic */ submitPreProgressSync.condition.1 $condition;
            final /* synthetic */ AtomicBoolean $isTaskCompleted;
            final /* synthetic */ ModalityState $modalityState;
            {
                this.$rootIndicator = $rootIndicator;
                this.$progressCancellation = $progressCancellation;
                this.$project = $project;
                this.$condition = $condition;
                this.$isTaskCompleted = $isTaskCompleted;
                this.$modalityState = $modalityState;
                this.hasProgress = new AtomicBoolean(false);
            }

            @NotNull
            public ProgressIndicator getIndicator() {
                return (ProgressIndicator)this.$rootIndicator;
            }

            public void ensureBackgroundableProgressShown() {
                if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    return;
                }
                if (!this.hasProgress.compareAndSet(false, true)) {
                    return;
                }
                this.$rootIndicator.checkCanceled();
                CountDownLatch taskCompletionSemaphore = new CountDownLatch(1);
                Disposer.register((Disposable)this.$progressCancellation, () -> submitPreProgressSync.1.context.1.ensureBackgroundableProgressShown$lambda$0(taskCompletionSemaphore));
                String string = SharedIndexesBundle.message("progress.title.resolving.shared.indexes", new Object[0]);
                Task.Backgroundable task2 = new Task.Backgroundable(this.$project, this.$rootIndicator, taskCompletionSemaphore, string){
                    final /* synthetic */ ProgressIndicatorBase $rootIndicator;
                    final /* synthetic */ CountDownLatch $taskCompletionSemaphore;
                    {
                        this.$rootIndicator = $rootIndicator;
                        this.$taskCompletionSemaphore = $taskCompletionSemaphore;
                        super($project, $super_call_param$1);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     */
                    public void run(@NotNull ProgressIndicator indicator) {
                        void parentProgress$iv;
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        ProgressIndicator progressIndicator = (ProgressIndicator)this.$rootIndicator;
                        CountDownLatch countDownLatch = this.$taskCompletionSemaphore;
                        boolean $i$f$runUnderNestedProgressAndRelayMessages = false;
                        Function1 action$iv = (Function1)new Function1<ProgressIndicator, Unit>(countDownLatch){
                            final /* synthetic */ CountDownLatch $taskCompletionSemaphore$inlined;
                            {
                                this.$taskCompletionSemaphore$inlined = countDownLatch;
                                super(1);
                            }

                            public final Unit invoke(@NotNull ProgressIndicator it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                ProgressIndicator it2 = it;
                                boolean bl = false;
                                ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)this.$taskCompletionSemaphore$inlined);
                                return Unit.INSTANCE;
                            }
                        };
                        if (parentProgress$iv instanceof AbstractProgressIndicatorExBase) {
                            void parentProgress$iv$iv;
                            AbstractProgressIndicatorExBase abstractProgressIndicatorExBase = (AbstractProgressIndicatorExBase)parentProgress$iv;
                            AbstractProgressIndicatorExBase delegate$iv$iv = (AbstractProgressIndicatorExBase)new RelayUiToDelegateIndicator(indicator);
                            boolean $i$f$runWithStateDelegate = false;
                            parentProgress$iv$iv.addStateDelegate((ProgressIndicatorEx)delegate$iv$iv);
                            try {
                                Object object;
                                boolean bl = false;
                                boolean $i$f$runUnderBoundCancellation = false;
                                Function0 action$iv$iv = (Function0)new Function0<Unit>(action$iv, (ProgressIndicator)parentProgress$iv){
                                    final /* synthetic */ Function1 $action$inlined;
                                    final /* synthetic */ ProgressIndicator $parentProgress$inlined;
                                    {
                                        this.$action$inlined = function1;
                                        this.$parentProgress$inlined = progressIndicator;
                                        super(0);
                                    }

                                    public final Unit invoke() {
                                        boolean bl = false;
                                        return this.$action$inlined.invoke((Object)this.$parentProgress$inlined);
                                    }
                                };
                                if (!(indicator instanceof AbstractProgressIndicatorExBase)) {
                                    object = action$iv$iv.invoke();
                                } else {
                                    AbstractProgressIndicatorExBase relay$iv$iv = new AbstractProgressIndicatorExBase((ProgressIndicator)parentProgress$iv){
                                        final /* synthetic */ ProgressIndicator $cancels;
                                        {
                                            this.$cancels = $cancels;
                                        }

                                        public void cancel() {
                                            super.cancel();
                                            this.$cancels.cancel();
                                        }
                                    };
                                    AbstractProgressIndicatorExBase parentProgress$iv$iv$iv = (AbstractProgressIndicatorExBase)indicator;
                                    boolean $i$f$runWithStateDelegate2 = false;
                                    parentProgress$iv$iv$iv.addStateDelegate((ProgressIndicatorEx)relay$iv$iv);
                                    try {
                                        Object object2 = action$iv$iv.invoke();
                                        object = object2;
                                    }
                                    finally {
                                        parentProgress$iv$iv$iv.removeStateDelegate((ProgressIndicatorEx)relay$iv$iv);
                                    }
                                }
                                Object object3 = object;
                            }
                            finally {
                                parentProgress$iv$iv.removeStateDelegate((ProgressIndicatorEx)delegate$iv$iv);
                            }
                        }
                        if (indicator instanceof AbstractProgressIndicatorExBase) {
                            AbstractProgressIndicatorExBase parentProgress$iv$iv = (AbstractProgressIndicatorExBase)indicator;
                            AbstractProgressIndicatorExBase delegate$iv$iv = (AbstractProgressIndicatorExBase)new RelayUiToDelegateIndicator((ProgressIndicator)parentProgress$iv);
                            boolean $i$f$runWithStateDelegate = false;
                            parentProgress$iv$iv.addStateDelegate((ProgressIndicatorEx)delegate$iv$iv);
                            try {
                                Object object;
                                boolean bl = false;
                                boolean $i$f$runUnderBoundCancellation = false;
                                Function0 action$iv$iv = (Function0)new Function0<Unit>(action$iv, indicator){
                                    final /* synthetic */ Function1 $action$inlined;
                                    final /* synthetic */ ProgressIndicator $childProgress$inlined;
                                    {
                                        this.$action$inlined = function1;
                                        this.$childProgress$inlined = progressIndicator;
                                        super(0);
                                    }

                                    public final Unit invoke() {
                                        boolean bl = false;
                                        return this.$action$inlined.invoke((Object)this.$childProgress$inlined);
                                    }
                                };
                                if (!(parentProgress$iv instanceof AbstractProgressIndicatorExBase)) {
                                    object = action$iv$iv.invoke();
                                } else {
                                    AbstractProgressIndicatorExBase relay$iv$iv = new AbstractProgressIndicatorExBase(indicator){
                                        final /* synthetic */ ProgressIndicator $cancels;
                                        {
                                            this.$cancels = $cancels;
                                        }

                                        public void cancel() {
                                            super.cancel();
                                            this.$cancels.cancel();
                                        }
                                    };
                                    AbstractProgressIndicatorExBase parentProgress$iv$iv$iv = (AbstractProgressIndicatorExBase)parentProgress$iv;
                                    boolean $i$f$runWithStateDelegate3 = false;
                                    parentProgress$iv$iv$iv.addStateDelegate((ProgressIndicatorEx)relay$iv$iv);
                                    try {
                                        Object object4 = action$iv$iv.invoke();
                                        object = object4;
                                    }
                                    finally {
                                        parentProgress$iv$iv$iv.removeStateDelegate((ProgressIndicatorEx)relay$iv$iv);
                                    }
                                }
                                Object object5 = object;
                            }
                            finally {
                                parentProgress$iv$iv.removeStateDelegate((ProgressIndicatorEx)delegate$iv$iv);
                            }
                        }
                        action$iv.invoke((Object)indicator);
                    }
                };
                new Runnable(this.$condition, this.$isTaskCompleted, this.$project, this, this.$modalityState, this.$progressCancellation, task2){
                    final /* synthetic */ submitPreProgressSync.condition.1 $condition;
                    final /* synthetic */ AtomicBoolean $isTaskCompleted;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ submitPreProgressSync.1.context.1 this$0;
                    final /* synthetic */ ModalityState $modalityState;
                    final /* synthetic */ submitPreProgressSync.1.progressCancellation.1 $progressCancellation;
                    final /* synthetic */ submitPreProgressSync.1.context.ensureBackgroundableProgressShown.task.1 $task;
                    {
                        this.$condition = $condition;
                        this.$isTaskCompleted = $isTaskCompleted;
                        this.$project = $project;
                        this.this$0 = $receiver;
                        this.$modalityState = $modalityState;
                        this.$progressCancellation = $progressCancellation;
                        this.$task = $task;
                    }

                    public void run() {
                        if (this.$condition.isExpired() || this.$isTaskCompleted.get()) {
                            return;
                        }
                        if (this.$project == null) {
                            this.this$0.queueChildTask((Function0<Unit>)((Function0)new Function0<Unit>(this.$task){
                                final /* synthetic */ submitPreProgressSync.1.context.ensureBackgroundableProgressShown.task.1 $task;
                                {
                                    this.$task = $task;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.$task.queue();
                                }
                            }));
                            return;
                        }
                        IdeFrameEx ideFrameEx = WindowManagerEx.getInstanceEx().findFrameHelper(this.$project);
                        boolean hasStatusBar = (ideFrameEx != null ? ideFrameEx.getStatusBar() : null) instanceof StatusBarEx;
                        if (hasStatusBar) {
                            this.this$0.queueChildTask((Function0<Unit>)((Function0)new Function0<Unit>(this.$task){
                                final /* synthetic */ submitPreProgressSync.1.context.ensureBackgroundableProgressShown.task.1 $task;
                                {
                                    this.$task = $task;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.$task.queue();
                                }
                            }));
                            return;
                        }
                        ScheduledFuture scheduledFuture = EdtScheduledExecutorService.getInstance().schedule((Runnable)this, this.$modalityState, 1L, TimeUnit.SECONDS);
                        Intrinsics.checkNotNullExpressionValue((Object)scheduledFuture, (String)"getInstance().schedule(t\u2026ate, 1, TimeUnit.SECONDS)");
                        ScheduledFuture future = scheduledFuture;
                        Disposable disposable = () -> submitPreProgressSync.1.context.ensureBackgroundableProgressShown.2.run$lambda$0(future);
                        if (!Disposer.tryRegister((Disposable)this.$progressCancellation, (Disposable)disposable)) {
                            Disposer.dispose((Disposable)disposable);
                        }
                    }

                    private static final void run$lambda$0(ScheduledFuture $future) {
                        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
                        $future.cancel(false);
                    }
                }.run();
            }

            public void queueChildTask(@NotNull Function0<Unit> action) {
                Intrinsics.checkNotNullParameter(action, (String)"action");
                if (this.$condition.isExpired()) {
                    return;
                }
                Runnable task2 = () -> submitPreProgressSync.1.context.1.queueChildTask$lambda$1(this.$condition, action);
                ApplicationManager.getApplication().invokeLater(task2, this.$modalityState, (Condition)this.$condition);
            }

            private static final void ensureBackgroundableProgressShown$lambda$0(CountDownLatch $taskCompletionSemaphore) {
                Intrinsics.checkNotNullParameter((Object)$taskCompletionSemaphore, (String)"$taskCompletionSemaphore");
                $taskCompletionSemaphore.countDown();
            }

            private static final void queueChildTask$lambda$1(submitPreProgressSync.condition.1 $condition, Function0 $action) {
                Intrinsics.checkNotNullParameter((Object)$condition, (String)"$condition");
                Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
                if ($condition.isExpired()) {
                    return;
                }
                $action.invoke();
            }
        };
        try {
            Runnable actualTask2 = () -> SharedIndexDownloadExecutor.submitPreProgressSync$lambda$2$lambda$1($project, progressCancellation2, $action, context2, $rootIndicator);
            ProgressManager.getInstance().runProcess(actualTask2, context2.getIndicator());
            progressCancellation2.doNotCancelProgress();
        }
        catch (Throwable t) {
            if (t instanceof ControlFlowException) {
                throw t;
            }
            SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Shared Indexes download task failed unexpectedly. " + t.getMessage(), t);
        }
        finally {
            $isTaskCompleted.set(true);
            Disposer.dispose((Disposable)progressCancellation2);
        }
    }

    public static final /* synthetic */ AtomicBoolean access$isDisposed$p(SharedIndexDownloadExecutor $this) {
        return $this.isDisposed;
    }
}

