/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.jarFinder.InternetAttachSourceProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.gradle.execution.build.CachedModuleDataFinder;
import org.jetbrains.plugins.gradle.execution.target.GradleTargetUtil;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.execution.BuildLayoutParameters;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleLog;
import org.jetbrains.plugins.gradle.util.GradleModuleData;

final class GradleAttachSourcesProvider
implements AttachSourcesProvider {
    GradleAttachSourcesProvider() {
    }

    @NotNull
    public Collection<? extends AttachSourcesProvider.AttachSourcesAction> getActions(final @NotNull List<? extends LibraryOrderEntry> orderEntries, final @NotNull PsiFile psiFile) {
        Map<LibraryOrderEntry, Module> gradleModules;
        if (orderEntries == null) {
            GradleAttachSourcesProvider.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            GradleAttachSourcesProvider.$$$reportNull$$$0(1);
        }
        if ((gradleModules = GradleAttachSourcesProvider.getGradleModules(orderEntries)).isEmpty()) {
            List list = List.of();
            if (list == null) {
                GradleAttachSourcesProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<1> list = List.of(new AttachSourcesProvider.AttachSourcesAction(){

            public String getName() {
                return GradleBundle.message((String)"gradle.action.download.sources", (Object[])new Object[0]);
            }

            public String getBusyText() {
                return GradleBundle.message((String)"gradle.action.download.sources.busy.text", (Object[])new Object[0]);
            }

            @NotNull
            public ActionCallback perform(@NotNull List<? extends LibraryOrderEntry> orderEntriesContainingFile) {
                String sourcesLocationFilePath;
                File sourcesLocationFile;
                Map<LibraryOrderEntry, Module> gradleModules;
                if (orderEntriesContainingFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((gradleModules = GradleAttachSourcesProvider.getGradleModules(orderEntries)).isEmpty()) {
                    ActionCallback actionCallback = ActionCallback.REJECTED;
                    if (actionCallback == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return actionCallback;
                }
                final ActionCallback resultWrapper = new ActionCallback();
                final Project project = psiFile.getProject();
                Map.Entry<LibraryOrderEntry, Module> next = gradleModules.entrySet().iterator().next();
                final LibraryOrderEntry libraryOrderEntry = next.getKey();
                Module module = next.getValue();
                String libraryName = libraryOrderEntry.getLibraryName();
                if (libraryName == null) {
                    ActionCallback actionCallback = ActionCallback.REJECTED;
                    if (actionCallback == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return actionCallback;
                }
                final String artifactCoordinates = StringUtil.trimStart((String)libraryName, (String)(GradleConstants.SYSTEM_ID.getReadableName() + ": "));
                if (StringUtil.equals((CharSequence)libraryName, (CharSequence)artifactCoordinates)) {
                    ActionCallback actionCallback = ActionCallback.REJECTED;
                    if (actionCallback == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return actionCallback;
                }
                GradleModuleData gradleModuleData = CachedModuleDataFinder.getGradleModuleData((Module)module);
                if (gradleModuleData == null) {
                    ActionCallback actionCallback = ActionCallback.REJECTED;
                    if (actionCallback == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return actionCallback;
                }
                String gradlePath = gradleModuleData.getGradlePath();
                String sourceArtifactNotation = GradleAttachSourcesProvider.getSourcesArtifactNotation(artifactCoordinates, artifactIdCandidate -> {
                    Object[] rootFiles = libraryOrderEntry.getRootFiles(OrderRootType.CLASSES);
                    return rootFiles.length == 0 || ContainerUtil.exists((Object[])rootFiles, file -> file.getName().startsWith((String)artifactIdCandidate));
                });
                try {
                    sourcesLocationFile = new File(FileUtil.createTempDirectory((String)"sources", (String)"loc"), "path.tmp");
                    sourcesLocationFilePath = StringUtil.escapeBackSlashes((String)sourcesLocationFile.getCanonicalPath());
                    Runtime.getRuntime().addShutdownHook(new Thread(() -> FileUtil.delete((File)sourcesLocationFile), "GradleAttachSourcesProvider cleanup"));
                }
                catch (IOException e) {
                    GradleLog.LOG.warn((Throwable)e);
                    ActionCallback actionCallback = ActionCallback.REJECTED;
                    if (actionCallback == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return actionCallback;
                }
                String taskName = "DownloadSources";
                String initScript = "allprojects {\n  afterEvaluate { project ->\n    if(project.path == '" + gradlePath + "') {\n        def overwrite = project.tasks.findByName('DownloadSources') != null\n        project.tasks.create(name: 'DownloadSources', overwrite: overwrite) {\n        doLast {\n          def configuration = null\n          def repository = project.repositories.toList().find {\n              logger.lifecycle('Attempt to download sources from ' + it.name)\n              project.repositories.clear()\n              project.repositories.add(it)\n              configuration = project.configurations.create('downloadSourcesFrom_' + UUID.randomUUID())\n              configuration.transitive = false\n              project.dependencies.add(configuration.name, '" + sourceArtifactNotation + "')\n              def files = null\n              try {\n                files = configuration.resolvedConfiguration.lenientConfiguration.getFiles()\n              } catch (java.lang.Throwable ignore) { }\n              return files && !files.isEmpty()\n          }\n          if (!repository) {\n              configuration = project.configurations.create('downloadSources_' + UUID.randomUUID())\n              configuration.transitive = false\n              project.dependencies.add(configuration.name, '" + sourceArtifactNotation + "')\n              configuration.resolve()\n          }\n          def sourcesPath = configuration?.singleFile?.path\n          if (sourcesPath) {\n            logger.lifecycle('Sources were downloaded to ' + sourcesPath)\n            new File('" + sourcesLocationFilePath + "').write sourcesPath\n          } else throw new RuntimeException('Sources download failed')\n        }\n      }\n    }\n  }\n}\n";
                UserDataHolderBase userData = new UserDataHolderBase();
                userData.putUserData(GradleTaskManager.INIT_SCRIPT_KEY, (Object)initScript);
                String projectGradleVmOptions = Objects.requireNonNullElse(GradleSettings.getInstance((Project)project).getGradleVmOptions(), "");
                String gradleVmOptions = projectGradleVmOptions + " -Dorg.gradle.configuration-cache=false -Dorg.gradle.unsafe.configuration-cache=false";
                final ExternalSystemTaskExecutionSettings settings = new ExternalSystemTaskExecutionSettings();
                settings.setExecutionName(this.getName());
                settings.setExternalProjectPath(gradleModuleData.getDirectoryToRunTask());
                settings.setTaskNames(List.of(gradleModuleData.getTaskPath("DownloadSources", true)));
                settings.setVmOptions(gradleVmOptions);
                settings.setExternalSystemIdString(GradleConstants.SYSTEM_ID.getId());
                ExternalSystemUtil.runTask((ExternalSystemTaskExecutionSettings)settings, (String)"Run", (Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (TaskCallback)new TaskCallback(){

                    public void onSuccess() {
                        VirtualFile classesFile = libraryOrderEntry.getRootFiles(OrderRootType.CLASSES)[0];
                        File sourceJar = GradleAttachSourcesProvider.getSourceFile(artifactCoordinates, classesFile, project, settings.getExternalProjectPath());
                        if (sourceJar == null) {
                            try {
                                sourceJar = new File(FileUtil.loadFile((File)sourcesLocationFile));
                                FileUtil.delete((File)sourcesLocationFile);
                            }
                            catch (IOException e) {
                                GradleLog.LOG.warn((Throwable)e);
                            }
                        }
                        File finalSourceJar = sourceJar;
                        ApplicationManager.getApplication().invokeLater(() -> {
                            HashSet libraries = new HashSet();
                            for (LibraryOrderEntry orderEntry : orderEntries) {
                                ContainerUtil.addIfNotNull(libraries, (Object)orderEntry.getLibrary());
                            }
                            if (finalSourceJar != null) {
                                InternetAttachSourceProvider.attachSourceJar((File)finalSourceJar, libraries);
                            }
                            resultWrapper.setDone();
                        });
                    }

                    public void onFailure() {
                        resultWrapper.setRejected();
                        String title = GradleBundle.message((String)"gradle.notifications.sources.download.failed.title", (Object[])new Object[0]);
                        String message = GradleBundle.message((String)"gradle.notifications.sources.download.failed.content", (Object[])new Object[]{artifactCoordinates});
                        NotificationData notification = new NotificationData(title, message, NotificationCategory.WARNING, NotificationSource.PROJECT_SYNC);
                        notification.setBalloonNotification(true);
                        ExternalSystemNotificationManager.getInstance((Project)project).showNotification(GradleConstants.SYSTEM_ID, notification);
                    }
                }, (ProgressExecutionMode)ProgressExecutionMode.IN_BACKGROUND_ASYNC, (boolean)false, (UserDataHolderBase)userData);
                ActionCallback actionCallback = resultWrapper;
                if (actionCallback == null) {
                    1.$$$reportNull$$$0(6);
                }
                return actionCallback;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 3, 4, 5, 6 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "orderEntriesContainingFile";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/gradle/util/GradleAttachSourcesProvider$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/gradle/util/GradleAttachSourcesProvider$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "perform";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "perform";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 3, 4, 5, 6 -> new IllegalStateException(string);
                };
            }
        });
        if (list == null) {
            GradleAttachSourcesProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @VisibleForTesting
    @NotNull
    static String getSourcesArtifactNotation(@NotNull String artifactCoordinates, @NotNull Predicate<String> artifactIdChecker) {
        boolean isArtifactId;
        String[] split;
        if (artifactCoordinates == null) {
            GradleAttachSourcesProvider.$$$reportNull$$$0(4);
        }
        if (artifactIdChecker == null) {
            GradleAttachSourcesProvider.$$$reportNull$$$0(5);
        }
        Object groupNameVersionCoordinates = (split = artifactCoordinates.split(":")).length == 4 ? ((isArtifactId = artifactIdChecker.test(split[1])) ? split[0] + ":" + split[1] + ":" + split[3] : artifactCoordinates) : (split.length == 5 ? split[0] + ":" + split[1] + ":" + split[4] : artifactCoordinates);
        String string = (String)groupNameVersionCoordinates + ":sources";
        if (string == null) {
            GradleAttachSourcesProvider.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    private static File getSourceFile(@NotNull String artifactCoordinates, VirtualFile classesFile, @NotNull Project project, @NotNull @NlsSafe String projectPath) {
        if (artifactCoordinates == null) {
            GradleAttachSourcesProvider.$$$reportNull$$$0(7);
        }
        if (project == null) {
            GradleAttachSourcesProvider.$$$reportNull$$$0(8);
        }
        if (projectPath == null) {
            GradleAttachSourcesProvider.$$$reportNull$$$0(9);
        }
        LibraryData data = new LibraryData(GradleConstants.SYSTEM_ID, artifactCoordinates);
        data.addPath(LibraryPathType.BINARY, VfsUtil.getLocalFile((VirtualFile)classesFile).getPath());
        BuildLayoutParameters buildLayoutParameters = GradleInstallationManager.getInstance().guessBuildLayoutParameters(project, projectPath);
        String gradleUserHome = (String)GradleTargetUtil.maybeGetLocalValue((TargetValue)buildLayoutParameters.getGradleUserHome());
        if (gradleUserHome == null) {
            return null;
        }
        GradleProjectResolverUtil.attachSourcesAndJavadocFromGradleCacheIfNeeded((File)new File(gradleUserHome), (LibraryData)data);
        Iterator iterator = data.getPaths(LibraryPathType.SOURCE).iterator();
        return iterator.hasNext() ? new File((String)iterator.next()) : null;
    }

    @NotNull
    private static Map<LibraryOrderEntry, Module> getGradleModules(@NotNull List<? extends LibraryOrderEntry> libraryOrderEntries) {
        if (libraryOrderEntries == null) {
            GradleAttachSourcesProvider.$$$reportNull$$$0(10);
        }
        HashMap<LibraryOrderEntry, Module> result = new HashMap<LibraryOrderEntry, Module>();
        for (LibraryOrderEntry libraryOrderEntry : libraryOrderEntries) {
            Module module;
            if (libraryOrderEntry.isModuleLevel() || !ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)(module = libraryOrderEntry.getOwnerModule()))) continue;
            result.put(libraryOrderEntry, module);
        }
        HashMap<LibraryOrderEntry, Module> hashMap = result;
        if (hashMap == null) {
            GradleAttachSourcesProvider.$$$reportNull$$$0(11);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntries";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/util/GradleAttachSourcesProvider";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactCoordinates";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactIdChecker";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryOrderEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/util/GradleAttachSourcesProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourcesArtifactNotation";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSourcesArtifactNotation";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getGradleModules";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 11 -> new IllegalStateException(string);
        };
    }
}

