/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.devkit.runtimeModuleRepository.jps.build;

import com.intellij.devkit.runtimeModuleRepository.jps.impl.DevkitRuntimeModuleRepositoryJpsBundle;
import com.intellij.platform.runtime.repository.serialization.RawRuntimeModuleDescriptor;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0017\u0010\b\u001a\u0013\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b\u0012\u0004\u0012\u00020\u00040\t\u00a8\u0006\f"}, d2={"Lcom/intellij/devkit/runtimeModuleRepository/jps/build/RuntimeModuleRepositoryValidator;", "", "()V", "validate", "", "descriptors", "", "Lcom/intellij/platform/runtime/repository/serialization/RawRuntimeModuleDescriptor;", "errorReporter", "Lkotlin/Function1;", "", "Lorg/jetbrains/annotations/Nls;", "intellij.devkit.runtimeModuleRepository.jps"})
public final class RuntimeModuleRepositoryValidator {
    @NotNull
    public static final RuntimeModuleRepositoryValidator INSTANCE = new RuntimeModuleRepositoryValidator();

    private RuntimeModuleRepositoryValidator() {
    }

    public final void validate(@NotNull List<RawRuntimeModuleDescriptor> descriptors, @NotNull Function1<? super String, Unit> errorReporter) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        Intrinsics.checkNotNullParameter(errorReporter, (String)"errorReporter");
        HashSet<String> moduleIDs = new HashSet<String>();
        for (RawRuntimeModuleDescriptor descriptor : descriptors) {
            if (moduleIDs.add(descriptor.getId())) continue;
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)descriptor.getId(), (String)"descriptor.id");
            errorReporter.invoke((Object)DevkitRuntimeModuleRepositoryJpsBundle.INSTANCE.message("error.message.duplicating.id.0.is.found", objectArray));
        }
    }
}

