/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.packaging;

import com.intellij.DynamicBundle;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.JavaFXBundle;
import org.jetbrains.plugins.javaFX.packaging.JavaFxArtifactProperties;

public class JavaFxEditCertificatesDialog
extends DialogWrapper {
    Panel myPanel;

    protected JavaFxEditCertificatesDialog(JComponent parent, JavaFxArtifactProperties properties, Project project) {
        super((Component)parent, true);
        this.setTitle(JavaFXBundle.message("javafx.certificates.dialog.choose.certificate.title", new Object[0]));
        this.init();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIUtil.setEnabled((Component)JavaFxEditCertificatesDialog.this.myPanel.myKeysPanel, (!JavaFxEditCertificatesDialog.this.myPanel.mySelfSignedRadioButton.isSelected() ? 1 : 0) != 0, (boolean)true);
            }
        };
        this.myPanel.mySelfSignedRadioButton.addActionListener(actionListener);
        this.myPanel.mySignedByKeyRadioButton.addActionListener(actionListener);
        boolean selfSigning = properties.isSelfSigning();
        UIUtil.setEnabled((Component)this.myPanel.myKeysPanel, (!selfSigning ? 1 : 0) != 0, (boolean)true);
        this.myPanel.mySelfSignedRadioButton.setSelected(selfSigning);
        this.myPanel.mySignedByKeyRadioButton.setSelected(!selfSigning);
        this.myPanel.myAliasTF.setText(properties.getAlias());
        this.myPanel.myKeystore.setText(properties.getKeystore());
        String keypass = properties.getKeypass();
        this.myPanel.myKeypassTF.setText(keypass != null ? new String(Base64.getDecoder().decode(keypass), StandardCharsets.UTF_8) : "");
        String storepass = properties.getStorepass();
        this.myPanel.myStorePassTF.setText(storepass != null ? new String(Base64.getDecoder().decode(storepass), StandardCharsets.UTF_8) : "");
        this.myPanel.myKeystore.addBrowseFolderListener(JavaFXBundle.message("javafx.certificates.dialog.choose.certificate.title", new Object[0]), JavaFXBundle.message("javafx.certificates.dialog.select.file.with.generated.keys", new Object[0]), project, BrowseFilesListener.SINGLE_FILE_DESCRIPTOR);
    }

    protected void doOKAction() {
        if (this.myPanel.mySignedByKeyRadioButton.isSelected()) {
            if (StringUtil.isEmptyOrSpaces((String)this.myPanel.myAliasTF.getText())) {
                Messages.showErrorDialog((Component)this.myPanel.myWholePanel, (String)JavaFXBundle.message("javafx.certificates.dialog.alias.should.be.non.empty.error", new Object[0]));
                return;
            }
            String keystore = this.myPanel.myKeystore.getText();
            if (StringUtil.isEmptyOrSpaces((String)keystore)) {
                Messages.showErrorDialog((Component)this.myPanel.myWholePanel, (String)JavaFXBundle.message("javafx.certificates.dialog.path.to.keystore.file.error", new Object[0]));
                return;
            }
            if (!new File(keystore).isFile()) {
                Messages.showErrorDialog((Component)this.myPanel.myWholePanel, (String)JavaFXBundle.message("javafx.certificates.dialog.keystore.file.should.exist.error", new Object[0]));
                return;
            }
            if (StringUtil.isEmptyOrSpaces((String)String.valueOf(this.myPanel.myKeypassTF.getPassword())) || StringUtil.isEmptyOrSpaces((String)String.valueOf(this.myPanel.myStorePassTF.getPassword()))) {
                Messages.showErrorDialog((Component)this.myPanel.myWholePanel, (String)JavaFXBundle.message("javafx.certificates.dialog.passwords.should.be.set.error", new Object[0]));
                return;
            }
        }
        super.doOKAction();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myPanel = new Panel();
        return this.myPanel.myWholePanel;
    }

    protected static class Panel {
        JRadioButton mySelfSignedRadioButton;
        JRadioButton mySignedByKeyRadioButton;
        JPasswordField myStorePassTF;
        JPasswordField myKeypassTF;
        JTextField myAliasTF;
        TextFieldWithBrowseButton myKeystore;
        JPanel myWholePanel;
        JPanel myKeysPanel;

        protected Panel() {
            this.$$$setupUI$$$();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JPasswordField jPasswordField;
            JPasswordField jPasswordField2;
            JTextField jTextField;
            TextFieldWithBrowseButton textFieldWithBrowseButton;
            JPanel jPanel;
            JRadioButton jRadioButton;
            JRadioButton jRadioButton2;
            JPanel jPanel2;
            this.myWholePanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.mySelfSignedRadioButton = jRadioButton2 = new JRadioButton();
            jRadioButton2.setSelected(true);
            this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/JavaFXBundle", Panel.class).getString("javafx.edit.certificates.dialog.self.signed.radio"));
            jPanel2.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
            this.mySignedByKeyRadioButton = jRadioButton = new JRadioButton();
            this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/JavaFXBundle", Panel.class).getString("javafx.edit.certificates.dialog.signed.by.key.radio"));
            jPanel2.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myKeysPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 36, 0, 0), -1, -1, false, false));
            jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/JavaFXBundle", Panel.class).getString("javafx.edit.certificates.dialog.keystore"));
            jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myKeystore = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
            jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
            JLabel jLabel2 = new JLabel();
            this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/JavaFXBundle", Panel.class).getString("javafx.edit.certificates.dialog.alias"));
            jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel3 = new JLabel();
            this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/JavaFXBundle", Panel.class).getString("javafx.edit.certificates.dialog.signed.storepass"));
            jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel4 = new JLabel();
            this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/JavaFXBundle", Panel.class).getString("javafx.edit.certificates.dialog.keypass"));
            jPanel.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myAliasTF = jTextField = new JTextField();
            jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
            this.myStorePassTF = jPasswordField2 = new JPasswordField();
            jPanel.add((Component)jPasswordField2, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
            this.myKeypassTF = jPasswordField = new JPasswordField();
            jPanel.add((Component)jPasswordField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
            jLabel.setLabelFor((Component)textFieldWithBrowseButton);
            jLabel2.setLabelFor(jTextField);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButton2);
            buttonGroup.add(jRadioButton);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

