/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.AttributeValueSelfReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.FxmlConstants;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxControllerBasedReferenceProvider;

public class JavaFxFieldIdReferenceProvider
extends JavaFxControllerBasedReferenceProvider {
    @Override
    protected PsiReference[] getReferencesByElement(@NotNull PsiClass aClass, XmlAttributeValue xmlAttributeValue, ProcessingContext context) {
        String name;
        PsiField fieldOrGetterMethod;
        if (aClass == null) {
            JavaFxFieldIdReferenceProvider.$$$reportNull$$$0(0);
        }
        if ((fieldOrGetterMethod = aClass.findFieldByName(name = xmlAttributeValue.getValue(), true)) == null) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = aClass.findMethodsByName(name, true)) {
                if (!method.getParameterList().isEmpty()) continue;
                fieldOrGetterMethod = method;
                break;
            }
        }
        return new PsiReference[]{new JavaFxControllerFieldRef(xmlAttributeValue, (PsiMember)fieldOrGetterMethod, aClass), new AttributeValueSelfReference((PsiElement)xmlAttributeValue)};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxFieldIdReferenceProvider", "getReferencesByElement"));
    }

    public static class JavaFxControllerFieldRef
    extends PsiReferenceBase<XmlAttributeValue> {
        private final XmlAttributeValue myXmlAttributeValue;
        private final PsiMember myFieldOrMethod;
        private final PsiClass myAClass;

        public JavaFxControllerFieldRef(XmlAttributeValue xmlAttributeValue, PsiMember fieldOrMethod, PsiClass aClass) {
            super((PsiElement)xmlAttributeValue, true);
            this.myXmlAttributeValue = xmlAttributeValue;
            this.myFieldOrMethod = fieldOrMethod;
            this.myAClass = aClass;
        }

        public XmlAttributeValue getXmlAttributeValue() {
            return this.myXmlAttributeValue;
        }

        public PsiClass getAClass() {
            return this.myAClass;
        }

        @Nullable
        public PsiElement resolve() {
            return this.myFieldOrMethod != null ? this.myFieldOrMethod : this.myXmlAttributeValue;
        }

        public boolean isUnresolved() {
            XmlFile xmlFile;
            return this.myFieldOrMethod == null && this.myAClass != null && (xmlFile = (XmlFile)this.myXmlAttributeValue.getContainingFile()).getRootTag() != null && !JavaFxPsiUtil.isOutOfHierarchy(this.myXmlAttributeValue);
        }

        public Object @NotNull [] getVariants() {
            PsiField[] fields;
            PsiClass exactTagClass = JavaFxPsiUtil.getTagClass(this.myXmlAttributeValue);
            PsiClass guessedTagClass = exactTagClass == null ? this.getGuessedTagClass() : null;
            ArrayList<PsiField> fieldsToSuggest = new ArrayList<PsiField>();
            for (PsiField psiField : fields = this.myAClass.getAllFields()) {
                PsiClass fieldClass;
                if (psiField.hasModifierProperty("static") || !JavaFxPsiUtil.isVisibleInFxml((PsiMember)psiField)) continue;
                PsiType fieldType = psiField.getType();
                PsiClass psiClass = fieldClass = fieldType instanceof PsiClassType ? ((PsiClassType)fieldType).resolve() : null;
                if (fieldClass == null) {
                    fieldsToSuggest.add(psiField);
                    continue;
                }
                if (exactTagClass != null) {
                    if (!InheritanceUtil.isInheritorOrSelf((PsiClass)exactTagClass, (PsiClass)fieldClass, (boolean)true)) continue;
                    fieldsToSuggest.add(psiField);
                    continue;
                }
                if (guessedTagClass != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)fieldClass, (PsiClass)guessedTagClass, (boolean)true)) continue;
                fieldsToSuggest.add(psiField);
            }
            Object[] objectArray = ArrayUtil.toObjectArray(fieldsToSuggest);
            if (objectArray == null) {
                JavaFxControllerFieldRef.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                JavaFxControllerFieldRef.$$$reportNull$$$0(1);
            }
            String newPropertyName = JavaFxPsiUtil.getPropertyName(newElementName, this.myFieldOrMethod instanceof PsiMethod);
            return super.handleElementRename(newPropertyName);
        }

        private PsiClass getGuessedTagClass() {
            String name;
            PsiElement xmlAttribute = this.myXmlAttributeValue.getParent();
            XmlTag xmlTag = ((XmlAttribute)xmlAttribute).getParent();
            if (xmlTag == null) {
                return null;
            }
            PsiElement parentTag = xmlTag.getParent();
            if (parentTag == null) {
                return null;
            }
            String className = null;
            if (parentTag instanceof XmlDocument) {
                className = "javafx.scene.layout.Pane";
            } else if (parentTag.getParent() instanceof XmlDocument && !FxmlConstants.FX_BUILT_IN_TAGS.contains(name = xmlTag.getName())) {
                className = "javafx.scene.Node";
            }
            if (className == null) {
                return null;
            }
            return JavaPsiFacade.getInstance((Project)this.myAClass.getProject()).findClass(className, GlobalSearchScope.allScope((Project)this.myAClass.getProject()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxFieldIdReferenceProvider$JavaFxControllerFieldRef";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxFieldIdReferenceProvider$JavaFxControllerFieldRef";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

