/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxControllerBasedReferenceProvider;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxEventHandlerReference;

class JavaFxEventHandlerReferenceProvider
extends JavaFxControllerBasedReferenceProvider {
    private static final Logger LOG = Logger.getInstance(JavaFxEventHandlerReferenceProvider.class);

    JavaFxEventHandlerReferenceProvider() {
    }

    @Override
    protected PsiReference[] getReferencesByElement(@NotNull PsiClass controllerClass, XmlAttributeValue xmlAttributeValue, ProcessingContext context) {
        if (controllerClass == null) {
            JavaFxEventHandlerReferenceProvider.$$$reportNull$$$0(0);
        }
        String attValueString = xmlAttributeValue.getValue();
        LOG.assertTrue(attValueString.startsWith("#"));
        XmlAttribute attribute = (XmlAttribute)xmlAttributeValue.getParent();
        if (attribute == null || !JavaFxPsiUtil.isEventHandlerProperty(attribute)) {
            return PsiReference.EMPTY_ARRAY;
        }
        String eventHandlerName = attValueString.substring(1);
        PsiMethod[] methods = controllerClass.findMethodsByName(eventHandlerName, true);
        PsiReference[] references = (PsiReference[])Arrays.stream(methods).filter(psiMethod -> JavaFxEventHandlerReference.isHandlerMethodSignature(psiMethod, controllerClass)).map(psiMethod -> new JavaFxEventHandlerReference(xmlAttributeValue, (PsiMethod)psiMethod, controllerClass)).toArray(arg_0 -> ((ArrayFactory)PsiReference.ARRAY_FACTORY).create(arg_0));
        if (references.length == 1) {
            return references;
        }
        if (references.length > 1) {
            return new PsiReference[]{new PsiMultiReference(references, (PsiElement)xmlAttributeValue)};
        }
        XmlTag rootTag = ((XmlFile)xmlAttributeValue.getContainingFile()).getRootTag();
        if (rootTag == null || "fx:root".equals(rootTag.getName())) {
            return PsiReference.EMPTY_ARRAY;
        }
        return new PsiReference[]{new JavaFxEventHandlerReference(xmlAttributeValue, null, controllerClass)};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controllerClass", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxEventHandlerReferenceProvider", "getReferencesByElement"));
    }
}

