/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.file;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.VcsEditorTabFilesManager;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.GitLabProjectConnection;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequestId;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabMergeRequestsFilesController;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabVirtualFile;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabVirtualFileSystem;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/file/GitLabMergeRequestsFilesControllerImpl;", "Lorg/jetbrains/plugins/gitlab/mergerequest/file/GitLabMergeRequestsFilesController;", "project", "Lcom/intellij/openapi/project/Project;", "connection", "Lorg/jetbrains/plugins/gitlab/api/GitLabProjectConnection;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/gitlab/api/GitLabProjectConnection;)V", "closeAllFiles", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "openDiff", "mr", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestId;", "focus", "", "openTimeline", "intellij.vcs.gitlab"})
public final class GitLabMergeRequestsFilesControllerImpl
implements GitLabMergeRequestsFilesController {
    @NotNull
    private final Project project;
    @NotNull
    private final GitLabProjectConnection connection;

    public GitLabMergeRequestsFilesControllerImpl(@NotNull Project project, @NotNull GitLabProjectConnection connection) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.project = project;
        this.connection = connection;
    }

    @Override
    public void openTimeline(@NotNull GitLabMergeRequestId mr, boolean focus) {
        Intrinsics.checkNotNullParameter((Object)mr, (String)"mr");
        GitLabVirtualFileSystem fs = GitLabVirtualFileSystem.Companion.getInstance();
        String path = GitLabVirtualFileSystem.getPath$default(fs, this.connection.getId(), this.project, this.connection.getRepo().getRepository(), mr, false, 16, null);
        VirtualFile virtualFile = fs.refreshAndFindFileByPath(path);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        FileEditorManager.getInstance((Project)this.project).openFile(file, focus);
    }

    @Override
    public void openDiff(@NotNull GitLabMergeRequestId mr, boolean focus) {
        Intrinsics.checkNotNullParameter((Object)mr, (String)"mr");
        GitLabVirtualFileSystem fs = GitLabVirtualFileSystem.Companion.getInstance();
        String path = fs.getPath(this.connection.getId(), this.project, this.connection.getRepo().getRepository(), mr, true);
        VirtualFile virtualFile = fs.refreshAndFindFileByPath(path);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        VcsEditorTabFilesManager.Companion.getInstance().openFile(this.project, file, focus);
    }

    @Override
    @Nullable
    public Object closeAllFiles(@NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GitLabMergeRequestsFilesControllerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (GitLabMergeRequestsFilesControllerImpl.access$getProject$p(this.this$0).isDisposed()) {
                            return Unit.INSTANCE;
                        }
                        FileEditorManager fileManager = FileEditorManager.getInstance((Project)GitLabMergeRequestsFilesControllerImpl.access$getProject$p(this.this$0));
                        this.label = 1;
                        Object object3 = CoroutinesKt.writeAction((Function0)((Function0)new Function0<Unit>(fileManager, this.this$0){
                            final /* synthetic */ FileEditorManager $fileManager;
                            final /* synthetic */ GitLabMergeRequestsFilesControllerImpl this$0;
                            {
                                this.$fileManager = $fileManager;
                                this.this$0 = $receiver;
                                super(0);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke() {
                                void $this$forEach$iv;
                                VirtualFile[] virtualFileArray = this.$fileManager.getOpenFiles();
                                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"fileManager.openFiles");
                                Object[] objectArray = virtualFileArray;
                                GitLabMergeRequestsFilesControllerImpl gitLabMergeRequestsFilesControllerImpl = this.this$0;
                                FileEditorManager fileEditorManager = this.$fileManager;
                                boolean $i$f$forEach = false;
                                for (void element$iv : $this$forEach$iv) {
                                    VirtualFile file = (VirtualFile)element$iv;
                                    boolean bl = false;
                                    if (!(file instanceof GitLabVirtualFile) || !Intrinsics.areEqual((Object)GitLabMergeRequestsFilesControllerImpl.access$getConnection$p(gitLabMergeRequestsFilesControllerImpl).getId(), (Object)((GitLabVirtualFile)file).getConnectionId())) continue;
                                    fileEditorManager.closeFile(file);
                                }
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Project access$getProject$p(GitLabMergeRequestsFilesControllerImpl $this) {
        return $this.project;
    }

    public static final /* synthetic */ GitLabProjectConnection access$getConnection$p(GitLabMergeRequestsFilesControllerImpl $this) {
        return $this.connection;
    }
}

