/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.designSurface.ComponentDragObject;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.designSurface.FeedbackLayer;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.lw.LwContainer;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.AbstractTextFieldEditor;
import com.intellij.uiDesigner.propertyInspector.editors.ComponentEditor;
import com.intellij.uiDesigner.propertyInspector.properties.HGapProperty;
import com.intellij.uiDesigner.propertyInspector.properties.VGapProperty;
import com.intellij.uiDesigner.propertyInspector.renderers.ComponentRenderer;
import com.intellij.uiDesigner.propertyInspector.renderers.LabelPropertyRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadLayoutManager;
import com.intellij.util.IncorrectOperationException;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadCardLayoutManager
extends RadLayoutManager {
    @Override
    @Nullable
    public String getName() {
        return "CardLayout";
    }

    @Override
    @Nullable
    public LayoutManager createLayout() {
        return new CardLayout();
    }

    @Override
    public void readLayout(LwContainer lwContainer, RadContainer radContainer) throws Exception {
        String defaultCard = (String)lwContainer.getClientProperty((Object)"CardLayout");
        DefaultCardProperty.INSTANCE.setValue(radContainer, defaultCard);
    }

    @Override
    public void writeChildConstraints(XmlWriter writer, RadComponent child) {
        writer.startElement("card");
        try {
            writer.addAttribute("name", (String)child.getCustomLayoutConstraints());
        }
        finally {
            writer.endElement();
        }
    }

    @Override
    public void writeLayout(XmlWriter writer, RadContainer radContainer) {
        CardLayout layout = (CardLayout)radContainer.getLayout();
        writer.addAttribute("hgap", layout.getHgap());
        writer.addAttribute("vgap", layout.getVgap());
        String defaultCard = DefaultCardProperty.INSTANCE.getValue(radContainer);
        if (!StringUtil.isEmpty((String)defaultCard)) {
            writer.addAttribute("show", defaultCard);
        }
    }

    @Override
    public void addComponentToContainer(RadContainer container, RadComponent component, int index) {
        container.getDelegee().add((Component)component.getDelegee(), component.getCustomLayoutConstraints());
    }

    @Override
    public void removeComponentFromContainer(RadContainer container, RadComponent component) {
        if (component.getId().equals(DefaultCardProperty.INSTANCE.getValue(container))) {
            DefaultCardProperty.INSTANCE.setValueEx(container, null);
        }
        super.removeComponentFromContainer(container, component);
    }

    @Override
    public void changeContainerLayout(RadContainer container) throws IncorrectOperationException {
        if (container.getComponentCount() != 0) {
            throw new IncorrectOperationException("Only empty containers can be changed to CardLayout");
        }
        super.changeContainerLayout(container);
    }

    @Override
    @NotNull
    public ComponentDropLocation getDropLocation(RadContainer container, @Nullable Point location) {
        return new CardDropLocation(container);
    }

    @Override
    public Property[] getContainerProperties(Project project) {
        return new Property[]{HGapProperty.getInstance(project), VGapProperty.getInstance(project), DefaultCardProperty.INSTANCE};
    }

    @Override
    public Property[] getComponentProperties(Project project, RadComponent component) {
        return new Property[]{CardNameProperty.INSTANCE};
    }

    @Override
    public boolean isSwitchedToChild(RadContainer container, RadComponent child) {
        return child.getDelegee().isVisible();
    }

    @Override
    public boolean switchContainerToChild(RadContainer container, RadComponent child) {
        CardLayout cardLayout = (CardLayout)container.getLayout();
        String card = (String)child.getCustomLayoutConstraints();
        cardLayout.show(container.getDelegee(), card);
        return true;
    }

    @Override
    public boolean areChildrenExclusive() {
        return true;
    }

    private static class DefaultCardProperty
    extends Property<RadContainer, String> {
        @NonNls
        private static final String NAME = "Default Card";
        private final ComponentRenderer myRenderer = new ComponentRenderer();
        private ComponentEditor myEditor;
        static DefaultCardProperty INSTANCE = new DefaultCardProperty();

        DefaultCardProperty() {
            super(null, NAME);
        }

        @Override
        @NotNull
        public PropertyRenderer<String> getRenderer() {
            ComponentRenderer componentRenderer = this.myRenderer;
            if (componentRenderer == null) {
                DefaultCardProperty.$$$reportNull$$$0(0);
            }
            return componentRenderer;
        }

        @Override
        public PropertyEditor<String> getEditor() {
            if (this.myEditor == null) {
                this.myEditor = new ComponentEditor(null, null){

                    @Override
                    protected RadComponent[] collectFilteredComponents(RadComponent component) {
                        RadContainer container = (RadContainer)component;
                        RadComponent[] result = new RadComponent[container.getComponentCount() + 1];
                        for (int i = 1; i < result.length; ++i) {
                            result[i] = container.getComponent(i - 1);
                        }
                        return result;
                    }
                };
            }
            return this.myEditor;
        }

        @Override
        public String getValue(RadContainer component) {
            return (String)component.getDelegee().getClientProperty(NAME);
        }

        @Override
        protected void setValueImpl(RadContainer component, String value) throws Exception {
            component.getDelegee().putClientProperty(NAME, StringUtil.isEmpty((String)value) ? null : value);
        }

        @Override
        public boolean appliesToSelection(List<RadComponent> selection) {
            return selection.size() == 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/radComponents/RadCardLayoutManager$DefaultCardProperty", "getRenderer"));
        }
    }

    private static class CardDropLocation
    implements ComponentDropLocation {
        private final RadContainer myContainer;
        @NonNls
        private static final String CARD_NAME_PREFIX = "Card";

        CardDropLocation(RadContainer container) {
            this.myContainer = container;
        }

        @Override
        public RadContainer getContainer() {
            return this.myContainer;
        }

        @Override
        public boolean canDrop(ComponentDragObject dragObject) {
            return dragObject.getComponentCount() == 1;
        }

        @Override
        public void placeFeedback(FeedbackLayer feedbackLayer, ComponentDragObject dragObject) {
            Rectangle rc = this.myContainer.getBounds();
            feedbackLayer.putFeedback(this.myContainer.getParent().getDelegee(), rc, null);
        }

        @Override
        public void processDrop(GuiEditor editor, RadComponent[] components, GridConstraints[] constraintsToAdjust, ComponentDragObject dragObject) {
            int cardIndex = 1;
            while (this.myContainer.findComponentWithConstraints(CARD_NAME_PREFIX + cardIndex) != null) {
                ++cardIndex;
            }
            components[0].setCustomLayoutConstraints(CARD_NAME_PREFIX + cardIndex);
            this.myContainer.addComponent(components[0]);
        }

        @Override
        @Nullable
        public ComponentDropLocation getAdjacentLocation(ComponentDropLocation.Direction direction) {
            return null;
        }
    }

    private static final class CardNameProperty
    extends Property<RadComponent, String> {
        private final LabelPropertyRenderer<String> myRenderer = new LabelPropertyRenderer();
        private final AbstractTextFieldEditor<String> myEditor = new AbstractTextFieldEditor<String>(){

            @Override
            protected void setValueFromComponent(RadComponent component, String value) {
                this.myTf.setText((String)component.getCustomLayoutConstraints());
            }

            @Override
            public String getValue() throws Exception {
                return this.myTf.getText();
            }
        };
        static CardNameProperty INSTANCE = new CardNameProperty();

        private CardNameProperty() {
            super(null, "Card Name");
        }

        @Override
        public String getValue(RadComponent component) {
            return (String)component.getCustomLayoutConstraints();
        }

        @Override
        protected void setValueImpl(RadComponent component, String value) throws Exception {
            if (!value.equals(component.getCustomLayoutConstraints())) {
                if (component.getParent().findComponentWithConstraints(value) != null) {
                    throw new Exception(UIDesignerBundle.message("error.card.already.exists", value));
                }
                component.changeCustomLayoutConstraints(value);
                JComponent parent = component.getParent().getDelegee();
                CardLayout layout = (CardLayout)parent.getLayout();
                layout.show(parent, value);
            }
        }

        @Override
        @NotNull
        public PropertyRenderer<String> getRenderer() {
            LabelPropertyRenderer<String> labelPropertyRenderer = this.myRenderer;
            if (labelPropertyRenderer == null) {
                CardNameProperty.$$$reportNull$$$0(0);
            }
            return labelPropertyRenderer;
        }

        @Override
        public PropertyEditor<String> getEditor() {
            return this.myEditor;
        }

        @Override
        public boolean appliesToSelection(List<RadComponent> selection) {
            return selection.size() == 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/radComponents/RadCardLayoutManager$CardNameProperty", "getRenderer"));
        }
    }
}

