/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ChooseLocaleAction
extends ComboBoxAction {
    private static final String PRESENTATION = "ChooseLocaleAction.presentation";

    public ChooseLocaleAction() {
        this.getTemplatePresentation().setText("");
        this.getTemplatePresentation().setDescription(UIDesignerBundle.messagePointer("choose.locale.description", new Object[0]));
        this.getTemplatePresentation().setIcon(AllIcons.Nodes.PpWeb);
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        if (presentation == null) {
            ChooseLocaleAction.$$$reportNull$$$0(0);
        }
        if (place == null) {
            ChooseLocaleAction.$$$reportNull$$$0(1);
        }
        JComponent component = super.createCustomComponent(presentation, place);
        component.putClientProperty(PRESENTATION, presentation);
        JComponent jComponent = component;
        if (jComponent == null) {
            ChooseLocaleAction.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button, @NotNull DataContext dataContext) {
        if (button == null) {
            ChooseLocaleAction.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            ChooseLocaleAction.$$$reportNull$$$0(4);
        }
        final Presentation presentation = (Presentation)button.getClientProperty(PRESENTATION);
        DefaultActionGroup group = new DefaultActionGroup();
        GuiEditor editor = FormEditingUtil.getActiveEditor(dataContext);
        if (editor != null) {
            Locale[] locales = FormEditingUtil.collectUsedLocales(editor.getModule(), editor.getRootContainer());
            if (locales.length > 1 || locales.length == 1 && locales[0].getDisplayName().length() > 0) {
                Arrays.sort(locales, Comparator.comparing(Locale::getDisplayName));
                for (Locale locale : locales) {
                    group.add((AnAction)new SetLocaleAction(editor, locale){

                        @Override
                        public void actionPerformed(@NotNull AnActionEvent e) {
                            if (e == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            super.actionPerformed(e);
                            presentation.setText(this.getTemplatePresentation().getText());
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/uiDesigner/actions/ChooseLocaleAction$1", "actionPerformed"));
                        }
                    });
                }
            } else {
                group.add((AnAction)new SetLocaleAction(editor, new Locale("")));
            }
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            ChooseLocaleAction.$$$reportNull$$$0(5);
        }
        return defaultActionGroup;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ChooseLocaleAction.$$$reportNull$$$0(6);
        }
        e.getPresentation().setVisible(FormEditingUtil.getActiveEditor(e.getDataContext()) != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ChooseLocaleAction.$$$reportNull$$$0(7);
        }
        return actionUpdateThread;
    }

    @NlsSafe
    private static String getLocaleText(Locale locale) {
        return locale.getDisplayName().length() == 0 ? UIDesignerBundle.message("choose.locale.default", new Object[0]) : locale.getDisplayName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/actions/ChooseLocaleAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/actions/ChooseLocaleAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createPopupActionGroup";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 7 -> new IllegalStateException(string);
        };
    }

    private static class SetLocaleAction
    extends AnAction {
        final GuiEditor myEditor;
        final Locale myLocale;

        SetLocaleAction(GuiEditor editor, Locale locale) {
            this.getTemplatePresentation().setText(ChooseLocaleAction.getLocaleText(locale), false);
            this.myEditor = editor;
            this.myLocale = locale;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SetLocaleAction.$$$reportNull$$$0(0);
            }
            this.myEditor.setStringDescriptorLocale(this.myLocale);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/uiDesigner/actions/ChooseLocaleAction$SetLocaleAction", "actionPerformed"));
        }
    }
}

