/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.designSurface.InplaceEditingLayer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGuiEditorAction
extends AnAction
implements DumbAware {
    private final boolean myModifying;

    protected AbstractGuiEditorAction() {
        this.myModifying = false;
    }

    protected AbstractGuiEditorAction(boolean modifying) {
        this.myModifying = modifying;
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        GuiEditor editor;
        if (e == null) {
            AbstractGuiEditorAction.$$$reportNull$$$0(0);
        }
        if ((editor = FormEditingUtil.getEditorFromContext(e.getDataContext())) != null) {
            ArrayList<RadComponent> selection = FormEditingUtil.getSelectedComponents(editor);
            if (this.myModifying && !editor.ensureEditable()) {
                return;
            }
            InplaceEditingLayer editingLayer = editor.getInplaceEditingLayer();
            if (editingLayer.isEditing()) {
                editingLayer.finishInplaceEditing();
            }
            Runnable runnable = () -> {
                this.actionPerformed(editor, selection, e);
                if (this.myModifying) {
                    editor.refreshAndSave(true);
                }
            };
            if (this.getCommandName() != null) {
                CommandProcessor.getInstance().executeCommand(editor.getProject(), runnable, this.getCommandName(), null);
            } else {
                runnable.run();
            }
        }
    }

    protected abstract void actionPerformed(GuiEditor var1, List<? extends RadComponent> var2, AnActionEvent var3);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            AbstractGuiEditorAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public final void update(@NotNull AnActionEvent e) {
        GuiEditor editor;
        if (e == null) {
            AbstractGuiEditorAction.$$$reportNull$$$0(2);
        }
        if ((editor = FormEditingUtil.getEditorFromContext(e.getDataContext())) == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setEnabledAndVisible(true);
            ArrayList<RadComponent> selection = FormEditingUtil.getSelectedComponents(editor);
            this.update(editor, selection, e);
        }
    }

    protected void update(@NotNull GuiEditor editor, ArrayList<? extends RadComponent> selection, AnActionEvent e) {
        if (editor == null) {
            AbstractGuiEditorAction.$$$reportNull$$$0(3);
        }
    }

    @Nullable
    @Nls
    protected String getCommandName() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/actions/AbstractGuiEditorAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/actions/AbstractGuiEditorAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

