/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.sarif;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import com.jetbrains.qodana.sarif.SarifUtil;
import com.jetbrains.qodana.sarif.model.ArtifactLocation;
import com.jetbrains.qodana.sarif.model.Location;
import com.jetbrains.qodana.sarif.model.LogicalLocation;
import com.jetbrains.qodana.sarif.model.Message;
import com.jetbrains.qodana.sarif.model.MultiformatMessageString;
import com.jetbrains.qodana.sarif.model.PhysicalLocation;
import com.jetbrains.qodana.sarif.model.PropertyBag;
import com.jetbrains.qodana.sarif.model.Region;
import com.jetbrains.qodana.sarif.model.ReportingDescriptor;
import com.jetbrains.qodana.sarif.model.ReportingDescriptorReference;
import com.jetbrains.qodana.sarif.model.ReportingDescriptorRelationship;
import com.jetbrains.qodana.sarif.model.Result;
import com.jetbrains.qodana.sarif.model.Run;
import com.jetbrains.qodana.sarif.model.SarifReport;
import com.jetbrains.qodana.sarif.model.Tool;
import com.jetbrains.qodana.sarif.model.ToolComponent;
import com.jetbrains.qodana.sarif.model.VersionControlDetails;
import com.jetbrains.qodana.sarif.model.VersionedMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.rmi.UnexpectedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.sarif.DescriptionHandler;
import org.jetbrains.qodana.sarif.InvalidSarifException;
import org.jetbrains.qodana.sarif.NonUniqueProblemReporter;
import org.jetbrains.qodana.sarif.NullableHasher;
import org.jetbrains.qodana.sarif.Report;
import org.jetbrains.qodana.sarif.SarifConverter;
import org.jetbrains.qodana.sarif.SarifConverterKt;
import org.jetbrains.qodana.sarif.TextSanitizer;
import org.jetbrains.qodana.sarif.model.CoverageInformation;
import org.jetbrains.qodana.sarif.model.Description;
import org.jetbrains.qodana.sarif.model.FreshCoverage;
import org.jetbrains.qodana.sarif.model.MetaInformation;
import org.jetbrains.qodana.sarif.model.ResultAllProblems;
import org.jetbrains.qodana.sarif.model.StreamingResultAllProblems;
import org.jetbrains.qodana.sarif.model.TotalCoverage;
import org.jetbrains.qodana.sarif.model.dependency.analysis.DependencyAnalysisCode;
import org.jetbrains.qodana.sarif.model.streaming.util.AccumulatingIterator;
import org.jetbrains.qodana.sarif.model.streaming.util.AccumulatingIteratorKt;
import org.jetbrains.qodana.sarif.model.taint.TaintCode;
import org.jetbrains.qodana.sarif.model.taint.TaintProblem;
import org.jetbrains.teamcity.qodana.model.version3.Problem;
import org.jetbrains.teamcity.qodana.model.version3.SimpleProblem;
import org.jetbrains.teamcity.qodana.model.version3.Source;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001RB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0002J \u0010#\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u000f2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u000fH\u0002J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J$\u0010&\u001a\u00020\"2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020\u0017H\u0002J\u0018\u0010+\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010,\u001a\u00020-H\u0002J&\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00130\u000f2\u0006\u0010/\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0017H\u0002J\u0018\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001706*\u00020\u0015H\u0002JW\u00107\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020:08*\u00020\u001d2\u0006\u0010;\u001a\u00020<2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010=\u001a\u00020\"2#\b\u0002\u0010>\u001a\u001d\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b@\u0012\b\bA\u0012\u0004\b\b(B\u0012\u0004\u0012\u00020C0?H\u0002J\u001a\u00107\u001a\b\u0012\u0004\u0012\u0002090\u000f*\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010D\u001a\u00020\u0013*\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u0010E\u001a\u0004\u0018\u00010\u0013*\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010F\u001a\u00020-*\u00020G2\u0006\u0010H\u001a\u00020\u0017H\u0002J\u000e\u0010I\u001a\u0004\u0018\u00010\u0017*\u00020\u0015H\u0002J\f\u0010J\u001a\u00020K*\u00020LH\u0002J\u0012\u0010M\u001a\b\u0012\u0004\u0012\u0002010N*\u00020\u0015H\u0002J\u0014\u0010O\u001a\u00020C*\u00020\u000e2\u0006\u0010P\u001a\u00020\u0001H\u0002J\u0014\u0010O\u001a\u00020C*\u00020\u000e2\u0006\u0010P\u001a\u00020QH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006S"}, d2={"Lorg/jetbrains/qodana/sarif/SarifConverter;", "", "()V", "gson", "Lcom/google/gson/Gson;", "hasher", "Lorg/jetbrains/qodana/sarif/NullableHasher;", "getHasher", "()Lorg/jetbrains/qodana/sarif/NullableHasher;", "convert", "Lorg/jetbrains/qodana/sarif/Report;", "sarifReport", "Lcom/jetbrains/qodana/sarif/model/SarifReport;", "sarifFile", "Ljava/io/File;", "", "output", "Ljava/nio/file/Path;", "convertCommonProblem", "Lorg/jetbrains/teamcity/qodana/model/version3/SimpleProblem;", "result", "Lcom/jetbrains/qodana/sarif/model/Result;", "toolName", "", "typeByRule", "convertTaintProblem", "extractCoverageInfo", "Lorg/jetbrains/qodana/sarif/model/CoverageInformation;", "run", "Lcom/jetbrains/qodana/sarif/model/Run;", "extractMetaInformation", "Lorg/jetbrains/qodana/sarif/model/MetaInformation;", "shortToolName", "problemsSize", "", "filterTags", "list", "getComment", "getCoverageInt", "coverageInfo", "", "", "key", "getType", "rule", "Lcom/jetbrains/qodana/sarif/model/ReportingDescriptor;", "readProblemsFromProperties", "propertyName", "source", "Lorg/jetbrains/teamcity/qodana/model/version3/Source;", "location", "Lcom/jetbrains/qodana/sarif/model/Location;", "sourceType", "attributes", "", "convertResults", "Lorg/jetbrains/qodana/sarif/model/streaming/util/AccumulatingIterator;", "Lorg/jetbrains/teamcity/qodana/model/version3/Problem;", "Lorg/jetbrains/qodana/sarif/SarifConverter$ProblemsCount;", "sarifReader", "Ljava/io/Reader;", "indexInReport", "callback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "r", "", "convertToProblem", "convertToProblemSafe", "findRuleById", "Lcom/jetbrains/qodana/sarif/model/Tool;", "ruleId", "hash", "isTechDebt", "", "Lcom/jetbrains/qodana/sarif/model/Result$BaselineState;", "sources", "", "writeResult", "src", "Lorg/jetbrains/qodana/sarif/model/StreamingResultAllProblems;", "ProblemsCount", "sarif-converter"})
public final class SarifConverter {
    @NotNull
    private final Gson gson;

    public SarifConverter() {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"GsonBuilder().setPrettyP\u2026leHtmlEscaping().create()");
        this.gson = gson;
    }

    private final NullableHasher getHasher() {
        Hasher hasher = Hashing.sha256().newHasher();
        Intrinsics.checkNotNullExpressionValue((Object)hasher, (String)"sha256().newHasher()");
        return new NullableHasher(hasher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<File> convert(@NotNull File sarifFile, @NotNull Path output2) {
        Intrinsics.checkNotNullParameter((Object)sarifFile, (String)"sarifFile");
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        Object object = sarifFile;
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        boolean bl = false;
        Object object2 = object;
        boolean bl2 = false;
        Object object3 = object2;
        boolean bl3 = false;
        object3 = new FileInputStream((File)object3);
        bl3 = false;
        object2 = new InputStreamReader((InputStream)object3, charset);
        bl2 = false;
        object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        boolean bl4 = false;
        n = 0;
        Throwable throwable = null;
        try {
            Object it = (BufferedReader)object;
            boolean bl5 = false;
            it = SarifUtil.readReport((Reader)it, false);
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        Object sarifReport = it;
        SarifConverterKt.access$getLog$p().info(Intrinsics.stringPlus((String)"sarif file version: ", (Object)((Object)((SarifReport)sarifReport).getVersion())));
        object = sarifFile;
        Charset charset2 = Charsets.UTF_8;
        int n2 = 8192;
        boolean it = false;
        Object bl5 = object;
        bl2 = false;
        object3 = bl5;
        bl3 = false;
        object3 = new FileInputStream((File)object3);
        bl3 = false;
        bl5 = new InputStreamReader((InputStream)object3, charset2);
        bl2 = false;
        object = bl5 instanceof BufferedReader ? (BufferedReader)bl5 : new BufferedReader((Reader)bl5, n2);
        boolean bl6 = false;
        n2 = 0;
        Throwable throwable2 = null;
        try {
            String string;
            boolean isQodanaReport;
            BufferedReader reader = (BufferedReader)object;
            boolean bl7 = false;
            List<Run> list2 = ((SarifReport)sarifReport).getRuns();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"sarifReport.runs");
            object3 = (Run)CollectionsKt.firstOrNull(list2);
            if (object3 == null) {
                throw new UnexpectedException("Report have to contain at least one run object");
            }
            Object run2 = object3;
            String fullName = ((Run)run2).getTool().getDriver().getFullName();
            String shortToolName = ((Run)run2).getTool().getDriver().getName();
            boolean bl8 = isQodanaReport = fullName != null && StringsKt.startsWith((String)fullName, (String)"qodana", (boolean)true);
            String toolName = isQodanaReport ? "Code Inspection" : ((string = fullName) == null ? shortToolName : string);
            Reader reader2 = reader;
            Intrinsics.checkNotNullExpressionValue((Object)toolName, (String)"toolName");
            AccumulatingIterator iteratorProblems = SarifConverter.convertResults$default(this, (Run)run2, reader2, toolName, 0, null, 12, null);
            boolean bl9 = false;
            List writtenFiles = new ArrayList();
            SarifConverterKt.access$getLog$p().info("Writing result-allProblems.json");
            File file = output2.resolve("result-allProblems.json").toFile();
            boolean bl10 = false;
            boolean bl11 = false;
            File it2 = file;
            boolean bl12 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
            this.writeResult(it2, new StreamingResultAllProblems(null, iteratorProblems, 1, null));
            writtenFiles.add(it2);
            int problemsSize = ((ProblemsCount)iteratorProblems.getAccumulated()).getProcessed();
            int lostProblems = ((ProblemsCount)iteratorProblems.getAccumulated()).getLost();
            if (lostProblems > 0 && problemsSize == 0) {
                throw new InvalidSarifException("all sarif problems have invalid data");
            }
            SarifConverterKt.access$getLog$p().info(Intrinsics.stringPlus((String)"Amount problems: ", (Object)problemsSize));
            if (lostProblems != 0) {
                SarifConverterKt.access$getLog$p().info(Intrinsics.stringPlus((String)"Unhandled problems: ", (Object)lostProblems));
            }
            Intrinsics.checkNotNullExpressionValue((Object)shortToolName, (String)"shortToolName");
            MetaInformation metaInformation = this.extractMetaInformation((Run)run2, toolName, shortToolName, problemsSize);
            CoverageInformation coverageInformation = this.extractCoverageInfo((Run)run2);
            Description description2 = new DescriptionHandler((Run)run2).handle();
            SarifConverterKt.access$getLog$p().info("Writing metaInformation.json");
            File file2 = output2.resolve("metaInformation.json").toFile();
            boolean bl13 = false;
            boolean bl14 = false;
            File it3 = file2;
            boolean bl15 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it3, (String)"it");
            this.writeResult(it3, metaInformation);
            writtenFiles.add(it3);
            SarifConverterKt.access$getLog$p().info("Writing coverageInformation.json");
            file2 = output2.resolve("coverageInformation.json").toFile();
            bl13 = false;
            bl14 = false;
            it3 = file2;
            boolean bl16 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it3, (String)"it");
            this.writeResult(it3, coverageInformation);
            writtenFiles.add(it3);
            if (description2 != null) {
                String descriptionFileName = Intrinsics.stringPlus((String)StringsKt.replace$default((String)((String)((Map.Entry)CollectionsKt.first((Iterable)metaInformation.getToolsInspection().entrySet())).getKey()), (String)" ", (String)"_", (boolean)false, (int)4, null), (Object)".json");
                SarifConverterKt.access$getLog$p().info(Intrinsics.stringPlus((String)"Writing descriptions/", (Object)descriptionFileName));
                Comparable<Path> comparable = output2.resolve("descriptions");
                bl14 = false;
                boolean bl17 = false;
                Path $this$convert_u24lambda_u2d6_u24lambda_u2d4 = comparable;
                boolean bl18 = false;
                $this$convert_u24lambda_u2d6_u24lambda_u2d4.toFile().mkdirs();
                comparable = comparable.resolve(descriptionFileName).toFile();
                bl14 = false;
                bl17 = false;
                Comparable<Path> it4 = comparable;
                boolean bl19 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it4, (String)"it");
                this.writeResult((File)it4, description2);
                writtenFiles.add(it4);
            }
            List list3 = writtenFiles;
            return list3;
        }
        catch (Throwable throwable3) {
            throwable2 = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
        }
    }

    @NotNull
    public final Report convert(@NotNull File sarifFile) {
        Intrinsics.checkNotNullParameter((Object)sarifFile, (String)"sarifFile");
        SarifReport sarifReport = SarifUtil.readReport(sarifFile.toPath());
        Intrinsics.checkNotNullExpressionValue((Object)sarifReport, (String)"sarifReport");
        return this.convert(sarifReport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeResult(File $this$writeResult, Object src) {
        Object object = $this$writeResult;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        int n = 8192;
        boolean bl = false;
        Object object2 = object;
        boolean bl2 = false;
        Object object3 = object2;
        boolean bl3 = false;
        object3 = new FileOutputStream((File)object3);
        bl3 = false;
        object2 = new OutputStreamWriter((OutputStream)object3, charset);
        bl2 = false;
        object = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
        boolean bl4 = false;
        n = 0;
        Throwable throwable = null;
        try {
            BufferedWriter it = (BufferedWriter)object;
            boolean bl5 = false;
            this.gson.toJson(src, (Appendable)it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeResult(File $this$writeResult, StreamingResultAllProblems src) {
        NonUniqueProblemReporter reporter = new NonUniqueProblemReporter();
        Object object = $this$writeResult;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        int n = 8192;
        boolean bl = false;
        Object object2 = object;
        boolean bl2 = false;
        Object object3 = object2;
        boolean bl3 = false;
        object3 = new FileOutputStream((File)object3);
        bl3 = false;
        object2 = new OutputStreamWriter((OutputStream)object3, charset);
        bl2 = false;
        object = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
        boolean bl4 = false;
        n = 0;
        Throwable throwable = null;
        try {
            BufferedWriter writer = (BufferedWriter)object;
            boolean bl5 = false;
            JsonWriter jsonWriter = this.gson.newJsonWriter((Writer)writer);
            boolean bl6 = false;
            bl3 = false;
            JsonWriter $this$writeResult_u24lambda_u2d12_u24lambda_u2d11 = jsonWriter;
            boolean bl7 = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$writeResult_u24lambda_u2d12_u24lambda_u2d11, (String)"");
            JsonWriter $this$obj$iv = $this$writeResult_u24lambda_u2d12_u24lambda_u2d11;
            boolean $i$f$obj = false;
            $this$obj$iv.beginObject();
            boolean bl8 = false;
            $this$writeResult_u24lambda_u2d12_u24lambda_u2d11.name("version");
            $this$writeResult_u24lambda_u2d12_u24lambda_u2d11.value(src.getVersion());
            $this$writeResult_u24lambda_u2d12_u24lambda_u2d11.name("listProblem");
            JsonWriter $this$array$iv = $this$writeResult_u24lambda_u2d12_u24lambda_u2d11;
            boolean $i$f$array = false;
            $this$array$iv.beginArray();
            boolean bl9 = false;
            Iterator<Problem> $this$forEach$iv = src.getIteratorProblem();
            boolean $i$f$forEach = false;
            Iterator<Problem> iterator = $this$forEach$iv;
            boolean bl10 = false;
            Iterator<Problem> iterator2 = iterator;
            while (iterator2.hasNext()) {
                Problem element$iv;
                Problem problem = element$iv = iterator2.next();
                boolean bl11 = false;
                reporter.checkIfDuplicate(problem.getHash());
                this.gson.toJson((Object)problem, (Type)problem.getClass(), $this$writeResult_u24lambda_u2d12_u24lambda_u2d11);
            }
            $this$array$iv.endArray();
            $this$obj$iv.endObject();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        reporter.reportDuplicates();
    }

    private final Report convert(SarifReport sarifReport) {
        Object object = sarifReport.getRuns();
        Intrinsics.checkNotNullExpressionValue(object, (String)"sarifReport.runs");
        Run run2 = (Run)CollectionsKt.firstOrNull(object);
        if (run2 == null) {
            throw new UnexpectedException("Report have to contain at least one run object");
        }
        Run run3 = run2;
        object = run3.getTool().getDriver().getFullName();
        Object toolName = object == null ? run3.getTool().getDriver().getName() : object;
        String shortToolName = run3.getTool().getDriver().getName();
        Intrinsics.checkNotNullExpressionValue((Object)toolName, (String)"toolName");
        List<Problem> problems2 = this.convertResults(run3, (String)toolName);
        List<SimpleProblem> sanity = this.readProblemsFromProperties("qodana.sanity.results", run3, (String)toolName);
        List<SimpleProblem> promo = this.readProblemsFromProperties("qodana.promo.results", run3, (String)toolName);
        Description description2 = new DescriptionHandler(run3).handle();
        Intrinsics.checkNotNullExpressionValue((Object)shortToolName, (String)"shortToolName");
        MetaInformation metaInformation = this.extractMetaInformation(run3, (String)toolName, shortToolName, problems2.size());
        return new Report(new ResultAllProblems(null, problems2, 1, null), new ResultAllProblems(null, sanity, 1, null), new ResultAllProblems(null, promo, 1, null), metaInformation, description2);
    }

    private final MetaInformation extractMetaInformation(Run run2, String toolName, String shortToolName, int problemsSize) {
        VersionControlDetails versionControlDetails;
        MetaInformation metaInformation = new MetaInformation(0, null, null, null, 15, null);
        boolean bl = false;
        boolean bl2 = false;
        MetaInformation $this$extractMetaInformation_u24lambda_u2d14 = metaInformation;
        boolean bl3 = false;
        Set<VersionControlDetails> set = run2.getVersionControlProvenance();
        if (set != null && (versionControlDetails = (VersionControlDetails)CollectionsKt.firstOrNull((Iterable)set)) != null) {
            VersionControlDetails versionControlDetails2 = versionControlDetails;
            boolean bl4 = false;
            boolean bl5 = false;
            VersionControlDetails $this$extractMetaInformation_u24lambda_u2d14_u24lambda_u2d13 = versionControlDetails2;
            boolean bl6 = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"repositoryUri", (Object)$this$extractMetaInformation_u24lambda_u2d14_u24lambda_u2d13.getRepositoryUri()), TuplesKt.to((Object)"revisionId", (Object)$this$extractMetaInformation_u24lambda_u2d14_u24lambda_u2d13.getRevisionId()), TuplesKt.to((Object)"branch", (Object)$this$extractMetaInformation_u24lambda_u2d14_u24lambda_u2d13.getBranch())};
            $this$extractMetaInformation_u24lambda_u2d14.setAttributes(MapsKt.mapOf((Pair)TuplesKt.to((Object)"vcs", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"sarifIdea", (Object)MapsKt.mapOf((Pair[])pairArray))))));
        }
        $this$extractMetaInformation_u24lambda_u2d14.setTotalProblem(problemsSize);
        $this$extractMetaInformation_u24lambda_u2d14.setToolsInspection(MapsKt.mapOf((Pair)TuplesKt.to((Object)toolName, (Object)problemsSize)));
        $this$extractMetaInformation_u24lambda_u2d14.setLinterName(shortToolName);
        return metaInformation;
    }

    /*
     * WARNING - void declaration
     */
    private final CoverageInformation extractCoverageInfo(Run run2) {
        Object $this$extractCoverageInfo_u24lambda_u2d17_u24lambda_u2d15;
        PropertyBag propertyBag = run2.getProperties();
        Object object = (Map)(propertyBag == null ? null : propertyBag.get("coverage"));
        if (object == null) {
            return new CoverageInformation(null, null, null, 7, null);
        }
        Map coverageInfo = object;
        object = new CoverageInformation(null, null, null, 7, null);
        boolean bl = false;
        boolean bl2 = false;
        Object $this$extractCoverageInfo_u24lambda_u2d17 = object;
        boolean bl3 = false;
        Object object2 = new TotalCoverage(0, 0, 0, 7, null);
        boolean bl4 = false;
        boolean bl5 = false;
        TotalCoverage totalCoverage = object2;
        Object object3 = $this$extractCoverageInfo_u24lambda_u2d17;
        boolean bl6 = false;
        ((TotalCoverage)$this$extractCoverageInfo_u24lambda_u2d17_u24lambda_u2d15).setTotalCoverage(this.getCoverageInt(coverageInfo, "totalCoverage"));
        ((TotalCoverage)$this$extractCoverageInfo_u24lambda_u2d17_u24lambda_u2d15).setTotalLines(this.getCoverageInt(coverageInfo, "totalLines"));
        ((TotalCoverage)$this$extractCoverageInfo_u24lambda_u2d17_u24lambda_u2d15).setTotalCoveredLines(this.getCoverageInt(coverageInfo, "totalCoveredLines"));
        Unit unit = Unit.INSTANCE;
        ((CoverageInformation)object3).setTotal((TotalCoverage)object2);
        if (coverageInfo.get("freshCoverage") != null) {
            void $this$extractCoverageInfo_u24lambda_u2d17_u24lambda_u2d16;
            object2 = new FreshCoverage(0, 0, 0, 7, null);
            bl4 = false;
            bl5 = false;
            $this$extractCoverageInfo_u24lambda_u2d17_u24lambda_u2d15 = object2;
            object3 = $this$extractCoverageInfo_u24lambda_u2d17;
            boolean bl7 = false;
            $this$extractCoverageInfo_u24lambda_u2d17_u24lambda_u2d16.setFreshCoverage(this.getCoverageInt(coverageInfo, "freshCoverage"));
            $this$extractCoverageInfo_u24lambda_u2d17_u24lambda_u2d16.setFreshLines(this.getCoverageInt(coverageInfo, "freshLines"));
            $this$extractCoverageInfo_u24lambda_u2d17_u24lambda_u2d16.setFreshCoveredLines(this.getCoverageInt(coverageInfo, "freshCoveredLines"));
            unit = Unit.INSTANCE;
            ((CoverageInformation)object3).setFresh((FreshCoverage)object2);
        }
        return object;
    }

    private final int getCoverageInt(Map<String, Double> coverageInfo, String key) {
        Integer n;
        Double d = coverageInfo.get(key);
        Integer n2 = n = d == null ? null : Integer.valueOf((int)d.doubleValue());
        if (n == null) {
            throw new InvalidSarifException(Intrinsics.stringPlus((String)"Missing required coverage property: ", (Object)key));
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SimpleProblem> readProblemsFromProperties(String propertyName, Run run2, String toolName) {
        List list2;
        PropertyBag propertyBag = run2.getProperties();
        Object sanityObject = propertyBag == null ? null : propertyBag.get(propertyName);
        Object object = sanityObject;
        if (object == null) {
            list2 = null;
        } else {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            List<Result> list3 = SarifUtil.readResultsFromObject(it);
            if (list3 == null) {
                list2 = null;
            } else {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                object2 = list3;
                boolean $i$f$mapNotNull = false;
                void var10_10 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    SimpleProblem simpleProblem;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl4 = false;
                    Result it2 = (Result)element$iv$iv;
                    boolean bl5 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                    if (this.convertToProblemSafe(run2, it2, toolName) == null) continue;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    SimpleProblem it$iv$iv = simpleProblem;
                    boolean bl8 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            }
        }
        propertyBag = list2;
        return propertyBag == null ? CollectionsKt.emptyList() : propertyBag;
    }

    private final List<Problem> convertResults(Run $this$convertResults, String toolName) {
        int lostProblems = 0;
        boolean bl = false;
        List problems2 = new ArrayList();
        List<Result> list2 = $this$convertResults.getResults();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"results");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Result result = (Result)element$iv;
            boolean bl2 = false;
            try {
                Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
                problems2.add(this.convertToProblem($this$convertResults, result, toolName));
            }
            catch (Exception exception) {
                int n = lostProblems;
                lostProblems = n + 1;
                SarifConverterKt.access$getLog$p().error("Failed converting results", (Throwable)exception);
            }
        }
        if (lostProblems > 0 && problems2.size() == 0) {
            throw new InvalidSarifException("all sarif problems have invalid data");
        }
        return problems2;
    }

    private final AccumulatingIterator<Problem, ProblemsCount> convertResults(Run $this$convertResults, Reader sarifReader, String toolName, int indexInReport, Function1<? super Result, Unit> callback) {
        Iterator<Result> iterator = SarifUtil.lazyReadResults(sarifReader, indexInReport);
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"lazyReadResults(sarifReader, indexInReport)");
        return AccumulatingIteratorKt.filterNotNull(AccumulatingIterator.Companion.accumulating$sarif_converter(iterator, ProblemsCount.Companion.getEmpty(), (Function2)new Function2<Result, ProblemsCount, Pair<? extends SimpleProblem, ? extends ProblemsCount>>(callback, this, $this$convertResults, toolName){
            final /* synthetic */ Function1<Result, Unit> $callback;
            final /* synthetic */ SarifConverter this$0;
            final /* synthetic */ Run $this_convertResults;
            final /* synthetic */ String $toolName;
            {
                this.$callback = $callback;
                this.this$0 = $receiver;
                this.$this_convertResults = $receiver2;
                this.$toolName = $toolName;
                super(2);
            }

            @NotNull
            public final Pair<SimpleProblem, ProblemsCount> invoke(Result elem, @NotNull ProblemsCount prev) {
                Intrinsics.checkNotNullParameter((Object)prev, (String)"prev");
                Intrinsics.checkNotNullExpressionValue((Object)elem, (String)"elem");
                this.$callback.invoke((Object)elem);
                SimpleProblem problem = SarifConverter.access$convertToProblemSafe(this.this$0, this.$this_convertResults, elem, this.$toolName);
                ProblemsCount count = problem == null ? new ProblemsCount(prev.getProcessed(), prev.getLost() + 1) : new ProblemsCount(prev.getProcessed() + 1, prev.getLost());
                return new Pair((Object)problem, (Object)count);
            }
        }));
    }

    static /* synthetic */ AccumulatingIterator convertResults$default(SarifConverter sarifConverter, Run run2, Reader reader, String string, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            function1 = convertResults.2.INSTANCE;
        }
        return sarifConverter.convertResults(run2, reader, string, n, (Function1<? super Result, Unit>)function1);
    }

    private final SimpleProblem convertToProblemSafe(Run $this$convertToProblemSafe, Result result, String toolName) {
        try {
            return this.convertToProblem($this$convertToProblemSafe, result, toolName);
        }
        catch (Exception e) {
            SarifConverterKt.access$getLog$p().error("", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleProblem convertToProblem(Run $this$convertToProblem, Result result, String toolName) {
        String string;
        Object object;
        String string2;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        boolean bl;
        SimpleProblem simpleProblem;
        Object object6 = $this$convertToProblem.getTool();
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"tool");
        Tool tool = object6;
        object6 = result.getRuleId();
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"result.ruleId");
        ReportingDescriptor rule = this.findRuleById(tool, (String)object6);
        ToolComponent driver = $this$convertToProblem.getTool().getDriver();
        String type = this.getType(result, rule);
        Object object7 = result.getRuleId();
        if (Intrinsics.areEqual((Object)object7, (Object)"PhpVulnerablePathsInspection")) {
            simpleProblem = this.convertTaintProblem(result);
        } else if (Intrinsics.areEqual((Object)object7, (Object)"CheckDependencyLicenses")) {
            SimpleProblem simpleProblem2 = this.convertCommonProblem(result, toolName, type);
            bl = false;
            boolean bl2 = false;
            SimpleProblem $this$convertToProblem_u24lambda_u2d21 = simpleProblem2;
            boolean bl3 = false;
            DependencyAnalysisCode.Companion.addLicenseTags$sarif_converter($this$convertToProblem_u24lambda_u2d21);
            simpleProblem = simpleProblem2;
        } else {
            simpleProblem = this.convertCommonProblem(result, toolName, type);
        }
        object7 = simpleProblem;
        boolean bl4 = false;
        bl = false;
        Object $this$convertToProblem_u24lambda_u2d25 = object7;
        boolean bl5 = false;
        Set<ReportingDescriptorRelationship> set = this.hash(result);
        ((SimpleProblem)$this$convertToProblem_u24lambda_u2d25).setHash((String)(set == null ? String.valueOf(Random.Default.nextLong()) : set));
        Object object8 = $this$convertToProblem_u24lambda_u2d25;
        set = rule.getFullDescription();
        if (set == null) {
            object5 = "";
        } else {
            void $this$convertToProblem_u24lambda_u2d25_u24lambda_u2d22;
            object4 = set;
            boolean bl6 = false;
            boolean bl7 = false;
            object3 = object4;
            object2 = object8;
            boolean bl8 = false;
            String string3 = $this$convertToProblem_u24lambda_u2d25_u24lambda_u2d22.getMarkdown();
            string2 = string3 == null ? $this$convertToProblem_u24lambda_u2d25_u24lambda_u2d22.getText() : string3;
            object8 = object2;
            object = string2;
            object5 = object == null ? "" : object;
        }
        ((SimpleProblem)object8).setDetailsInfo((String)object5);
        Object object9 = $this$convertToProblem_u24lambda_u2d25;
        set = rule.getRelationships();
        if (set == null) {
            string = "";
        } else {
            object = (ReportingDescriptorRelationship)CollectionsKt.first((Iterable)set);
            if (object == null) {
                string = "";
            } else {
                object4 = ((ReportingDescriptorRelationship)object).getTarget();
                if (object4 == null) {
                    string = "";
                } else {
                    String string4 = ((ReportingDescriptorReference)object4).getId();
                    if (string4 == null) {
                        string = "";
                    } else {
                        Object element$iv2;
                        block15: {
                            object3 = string4;
                            boolean bl9 = false;
                            boolean bl10 = false;
                            Object object10 = object3;
                            object2 = object9;
                            boolean bl11 = false;
                            List<ReportingDescriptor> list2 = driver.getTaxa();
                            Intrinsics.checkNotNullExpressionValue(list2, (String)"driver.taxa");
                            Iterable $this$first$iv = list2;
                            boolean $i$f$first = false;
                            for (Object element$iv2 : $this$first$iv) {
                                void id;
                                ReportingDescriptor it = (ReportingDescriptor)element$iv2;
                                boolean bl12 = false;
                                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                                break block15;
                            }
                            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                        }
                        string2 = ((ReportingDescriptor)element$iv2).getName();
                        object9 = object2;
                        String string5 = string2;
                        string = string5 == null ? "" : string5;
                    }
                }
            }
        }
        ((SimpleProblem)object9).setCategory(string);
        return object7;
    }

    private final SimpleProblem convertTaintProblem(Result result) {
        TaintProblem taintProblem = TaintProblem.Companion.readTaintProblem$default(TaintProblem.Companion, result, false, 2, null);
        return TaintCode.Companion.convert$sarif_converter(taintProblem);
    }

    private final SimpleProblem convertCommonProblem(Result result, String toolName, String typeByRule) {
        Set<String> set;
        SimpleProblem simpleProblem = ResultAllProblems.Companion.emptySimpleProblem$sarif_converter();
        boolean bl = false;
        boolean bl2 = false;
        SimpleProblem $this$convertCommonProblem_u24lambda_u2d26 = simpleProblem;
        boolean bl3 = false;
        $this$convertCommonProblem_u24lambda_u2d26.setTool(toolName);
        $this$convertCommonProblem_u24lambda_u2d26.setType(typeByRule);
        $this$convertCommonProblem_u24lambda_u2d26.setComment(this.getComment(result));
        $this$convertCommonProblem_u24lambda_u2d26.setSeverity(SarifConverterKt.access$severity(result));
        $this$convertCommonProblem_u24lambda_u2d26.setAttributes(this.attributes(result));
        $this$convertCommonProblem_u24lambda_u2d26.setSources(this.sources(result));
        Object object = result.getProperties();
        $this$convertCommonProblem_u24lambda_u2d26.setTags(this.filterTags(object == null ? null : ((set = ((PropertyBag)object).getTags()) == null ? null : CollectionsKt.toMutableList((Collection)set))));
        object = result.getFixes();
        $this$convertCommonProblem_u24lambda_u2d26.setFixes(object == null ? null : CollectionsKt.toMutableList((Collection)((Collection)object)));
        return simpleProblem;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> filterTags(List<String> list2) {
        void $this$filterTo$iv$iv;
        List<String> list3 = list2;
        if (list3 == null) {
            return null;
        }
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!SarifConverterKt.access$getINCORRECT_PROBLEM_TAGS$p().contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filtered = (List)destination$iv$iv;
        Collection collection = filtered;
        boolean bl = false;
        return !collection.isEmpty() ? filtered : null;
    }

    private final String getComment(Result result) {
        String string;
        if (Intrinsics.areEqual((Object)result.getRuleId(), (Object)"DuplicatedCode")) {
            return "Duplicated code";
        }
        Message message = result.getMessage();
        if (message == null) {
            string = "";
        } else {
            String string2;
            String string3;
            Message message2 = message;
            boolean bl = false;
            boolean bl2 = false;
            Message $this$getComment_u24lambda_u2d28 = message2;
            boolean bl3 = false;
            String string4 = $this$getComment_u24lambda_u2d28.getText();
            if (string4 == null) {
                string3 = null;
            } else {
                String string5 = string4;
                TextSanitizer.Companion companion = TextSanitizer.Companion;
                boolean bl4 = false;
                boolean bl5 = false;
                String p0 = string5;
                boolean bl6 = false;
                string3 = companion.sanitizeText(p0);
            }
            string = (string2 = string3) == null ? "" : string2;
        }
        return string;
    }

    private final String getType(Result result, ReportingDescriptor rule) {
        String string;
        if (Intrinsics.areEqual((Object)result.getRuleId(), (Object)"DuplicatedCode")) {
            return "Duplicates";
        }
        MultiformatMessageString multiformatMessageString = rule.getShortDescription();
        return multiformatMessageString == null ? "" : ((string = multiformatMessageString.getText()) == null ? "" : string);
    }

    private final List<Source> sources(Result $this$sources) {
        boolean bl = false;
        List list2 = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $this$sources_u24lambda_u2d34 = list2;
        boolean bl4 = false;
        List<Location> list3 = $this$sources.getLocations();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"locations");
        Iterable $this$forEach$iv = list3;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Location location = (Location)element$iv;
            boolean bl5 = false;
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"location");
            $this$sources_u24lambda_u2d34.add(this.source(location, SarifConverter.sources$type($this$sources, location)));
        }
        return list2;
    }

    private final Source source(Location location, String sourceType) {
        PhysicalLocation physicalLocation = location.getPhysicalLocation();
        PhysicalLocation physicalLocation2 = physicalLocation;
        Region contextRegion = physicalLocation2 == null ? null : physicalLocation2.getContextRegion();
        return SarifConverterKt.source(location, sourceType, contextRegion);
    }

    private final Map<String, String> attributes(Result $this$attributes) {
        Object it;
        String string;
        LogicalLocation logicalLocation;
        Set<LogicalLocation> set;
        Object object;
        boolean bl = false;
        Map map2 = new LinkedHashMap();
        boolean bl2 = false;
        boolean bl3 = false;
        Map $this$attributes_u24lambda_u2d37 = map2;
        boolean bl4 = false;
        Object object2 = $this$attributes.getLocations();
        $this$attributes_u24lambda_u2d37.put("module", object2 == null ? "" : ((object = (Location)CollectionsKt.firstOrNull(object2)) == null ? "" : ((set = object.getLogicalLocations()) == null ? "" : ((logicalLocation = (LogicalLocation)CollectionsKt.first((Iterable)set)) == null ? "" : ((string = logicalLocation.getFullyQualifiedName()) == null ? "" : string)))));
        object2 = $this$attributes.getRuleId();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"ruleId");
        $this$attributes_u24lambda_u2d37.put("inspectionName", object2);
        object2 = $this$attributes.getBaselineState();
        if (object2 != null) {
            object = object2;
            boolean bl5 = false;
            boolean bl6 = false;
            it = object;
            boolean bl7 = false;
            if (this.isTechDebt((Result.BaselineState)((Object)it))) {
                $this$attributes_u24lambda_u2d37.put("isTechDebt", "true");
            }
        }
        object2 = $this$attributes.getBaselineState();
        if (object2 != null) {
            object = object2;
            boolean bl8 = false;
            boolean bl9 = false;
            it = object;
            boolean bl10 = false;
            String string2 = ((Result.BaselineState)((Object)it)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.toString()");
            $this$attributes_u24lambda_u2d37.put("baselineState", string2);
        }
        return map2;
    }

    private final boolean isTechDebt(Result.BaselineState $this$isTechDebt) {
        return $this$isTechDebt == Result.BaselineState.UNCHANGED || $this$isTechDebt == Result.BaselineState.ABSENT;
    }

    private final ReportingDescriptor findRuleById(Tool $this$findRuleById, String ruleId) {
        Sequence sequence;
        List<ReportingDescriptor> list2 = $this$findRuleById.getDriver().getRules();
        Sequence sequence2 = list2 == null ? null : CollectionsKt.asSequence((Iterable)list2);
        Sequence driverRules = sequence2 == null ? SequencesKt.emptySequence() : sequence2;
        Set<ToolComponent> set = $this$findRuleById.getExtensions();
        list2 = set == null ? null : ((sequence = CollectionsKt.asSequence((Iterable)set)) == null ? null : SequencesKt.flatMap((Sequence)sequence, (Function1)findRuleById.extensionRules.1.INSTANCE));
        Object extensionRules2 = list2 == null ? SequencesKt.emptySequence() : list2;
        try {
            List<ReportingDescriptor> list3;
            Object v0;
            block6: {
                Sequence $this$firstOrNull$iv = driverRules;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ReportingDescriptor it = (ReportingDescriptor)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)ruleId)) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            list2 = v0;
            if (list2 == null) {
                Object element$iv2;
                block7: {
                    Object $this$first$iv = extensionRules2;
                    boolean $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        ReportingDescriptor it = (ReportingDescriptor)element$iv2;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)ruleId)) continue;
                        break block7;
                    }
                    throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
                }
                set = element$iv2;
                Intrinsics.checkNotNullExpressionValue(set, (String)"extensionRules.first { it.id == ruleId }");
                list3 = (ReportingDescriptor)((Object)set);
            } else {
                list3 = list2;
            }
            return list3;
        }
        catch (NoSuchElementException e) {
            SarifConverterKt.access$getLog$p().error(Intrinsics.stringPlus((String)"rules sections (driver rules or extension rules) doesn't contain rule with id ", (Object)ruleId));
            throw e;
        }
    }

    private final String hash(Result $this$hash) {
        String it;
        boolean bl;
        boolean bl2;
        Object object;
        Pair pair = TuplesKt.to((Object)"equalIndicator", (Object)1);
        String key = (String)pair.component1();
        int version = ((Number)pair.component2()).intValue();
        VersionedMap<String> versionedMap = $this$hash.getPartialFingerprints();
        String partialFingerprint = versionedMap == null ? null : versionedMap.get(key, version);
        versionedMap = partialFingerprint;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!(versionedMap == null || StringsKt.isBlank((CharSequence)((Object)versionedMap)))) {
            return partialFingerprint;
        }
        VersionedMap<String> versionedMap2 = $this$hash.getFingerprints();
        String fingerprint = versionedMap2 == null ? null : versionedMap2.get(key, version);
        NullableHasher h = this.getHasher();
        String string = fingerprint;
        if (string != null) {
            object = string;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl5 = false;
            h.putUnencodedChars(it);
        }
        string = partialFingerprint;
        if (string != null) {
            object = string;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl6 = false;
            h.putUnencodedChars(it);
        }
        string = h.hash();
        return string == null ? null : ((object = (Object)string.asBytes()) == null ? null : object.toString());
    }

    private static final String sources$type(Result $this_sources, Location location) {
        String string;
        String string2;
        if (Intrinsics.areEqual((Object)$this_sources.getRuleId(), (Object)"DuplicatedCode")) {
            return "Duplicates";
        }
        Object object = location.getPhysicalLocation();
        if (object == null) {
            string2 = null;
        } else {
            ArtifactLocation artifactLocation = ((PhysicalLocation)object).getArtifactLocation();
            if (artifactLocation == null) {
                string2 = null;
            } else {
                String string3 = artifactLocation.getUri();
                if (string3 == null) {
                    string2 = null;
                } else {
                    String string4 = string3;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string4;
                    boolean bl3 = false;
                    string2 = "file";
                }
            }
        }
        String string5 = string2;
        if (string5 == null) {
            String string6;
            object = $this_sources;
            boolean bl = false;
            boolean bl4 = false;
            Object it = object;
            boolean bl5 = false;
            Set<LogicalLocation> set = location.getLogicalLocations();
            if (set == null) {
                string6 = null;
            } else {
                LogicalLocation logicalLocation = (LogicalLocation)CollectionsKt.firstOrNull((Iterable)set);
                if (logicalLocation == null) {
                    string6 = null;
                } else {
                    LogicalLocation logicalLocation2 = logicalLocation;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    LogicalLocation it2 = logicalLocation2;
                    boolean bl8 = false;
                    string6 = "module";
                }
            }
            String string7 = string6;
            if (string7 == null) {
                set = $this_sources;
                boolean bl9 = false;
                boolean bl10 = false;
                Set<LogicalLocation> it3 = set;
                boolean bl11 = false;
                string = "no specific module";
            } else {
                string = string7;
            }
        } else {
            string = string5;
        }
        return string;
    }

    public static final /* synthetic */ SimpleProblem access$convertToProblemSafe(SarifConverter $this, Run $receiver, Result result, String toolName) {
        return $this.convertToProblemSafe($receiver, result, toolName);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/qodana/sarif/SarifConverter$ProblemsCount;", "", "processed", "", "lost", "(II)V", "getLost", "()I", "getProcessed", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "sarif-converter"})
    public static final class ProblemsCount {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int processed;
        private final int lost;
        @NotNull
        private static final ProblemsCount empty = new ProblemsCount(0, 0);

        public ProblemsCount(int processed, int lost) {
            this.processed = processed;
            this.lost = lost;
        }

        public final int getProcessed() {
            return this.processed;
        }

        public final int getLost() {
            return this.lost;
        }

        public final int component1() {
            return this.processed;
        }

        public final int component2() {
            return this.lost;
        }

        @NotNull
        public final ProblemsCount copy(int processed, int lost) {
            return new ProblemsCount(processed, lost);
        }

        public static /* synthetic */ ProblemsCount copy$default(ProblemsCount problemsCount, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = problemsCount.processed;
            }
            if ((n3 & 2) != 0) {
                n2 = problemsCount.lost;
            }
            return problemsCount.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "ProblemsCount(processed=" + this.processed + ", lost=" + this.lost + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.processed);
            result = result * 31 + Integer.hashCode(this.lost);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProblemsCount)) {
                return false;
            }
            ProblemsCount problemsCount = (ProblemsCount)other;
            if (this.processed != problemsCount.processed) {
                return false;
            }
            return this.lost == problemsCount.lost;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/qodana/sarif/SarifConverter$ProblemsCount$Companion;", "", "()V", "empty", "Lorg/jetbrains/qodana/sarif/SarifConverter$ProblemsCount;", "getEmpty", "()Lorg/jetbrains/qodana/sarif/SarifConverter$ProblemsCount;", "sarif-converter"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ProblemsCount getEmpty() {
                return empty;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

