/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import icons.QodanaIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.actions.LinkCloudProjectAction;
import org.jetbrains.qodana.actions.OpenQodanaCloudReportAction;
import org.jetbrains.qodana.cloud.QodanaCloudStateService;
import org.jetbrains.qodana.cloud.UserState;
import org.jetbrains.qodana.cloud.project.LinkState;
import org.jetbrains.qodana.cloud.project.QodanaCloudProjectLinkService;
import org.jetbrains.qodana.ui.link.LinkCloudProjectDialog;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/qodana/actions/ProblemsViewCloudLinkAction;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionIcon", "Ljavax/swing/Icon;", "linkState", "Lorg/jetbrains/qodana/cloud/project/LinkState;", "getActionName", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "update", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nProblemsViewCloudLinkAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProblemsViewCloudLinkAction.kt\norg/jetbrains/qodana/actions/ProblemsViewCloudLinkAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
final class ProblemsViewCloudLinkAction
extends DefaultActionGroup
implements DumbAware {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        UserState userState = (UserState)QodanaCloudStateService.Companion.getInstance().getUserState().getValue();
        LinkState linkState = (LinkState)QodanaCloudProjectLinkService.Companion.getInstance(project3).getLinkState().getValue();
        e.getPresentation().setText(this.getActionName(linkState));
        e.getPresentation().setIcon(this.getActionIcon(linkState));
        e.getPresentation().setPopupGroup(true);
        e.getPresentation().setPerformGroup(true);
        e.getPresentation().putClientProperty(ActionButton.HIDE_DROPDOWN_ICON, (Object)true);
        if (!(userState instanceof UserState.Authorized)) {
            e.getPresentation().setEnabled(false);
            return;
        }
        if (linkState instanceof LinkState.Linked) {
            e.getPresentation().setPerformGroup(false);
            e.getPresentation().putClientProperty(ActionButton.HIDE_DROPDOWN_ICON, (Object)false);
        }
        e.getPresentation().setEnabled(true);
    }

    @NlsActions.ActionText
    private final String getActionName(LinkState linkState) {
        String string;
        LinkState linkState2 = linkState;
        if (linkState2 instanceof LinkState.Linked) {
            String string2 = QodanaBundle.message("problems.toolwindow.link.action.linked", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"problems.toolwindow.link.action.linked\")");
        } else if (linkState2 instanceof LinkState.NotLinked) {
            String string3 = QodanaBundle.message("problems.toolwindow.link.action.not.linked", new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"problems.toolwi\u2026.link.action.not.linked\")");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final Icon getActionIcon(LinkState linkState) {
        Icon icon;
        LinkState linkState2 = linkState;
        if (linkState2 instanceof LinkState.Linked) {
            Icon icon2 = QodanaIcons.Icons.LinkedProject;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"LinkedProject");
        } else if (linkState2 instanceof LinkState.NotLinked) {
            Icon icon3 = QodanaIcons.Icons.NotLinkedProject;
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"NotLinkedProject");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return icon;
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray = new AnAction[]{new OpenQodanaCloudReportAction(), new LinkCloudProjectAction()};
        return anActionArray;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project2 = e.getProject();
            if (project2 == null) break block0;
            Project it = project2;
            boolean bl = false;
            new LinkCloudProjectDialog(it).show();
        }
    }
}

