/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public final class JavaModuleBuildTargetType
extends ModuleBasedBuildTargetType<ModuleBuildTarget> {
    public static final JavaModuleBuildTargetType PRODUCTION = new JavaModuleBuildTargetType("java-production", false);
    public static final JavaModuleBuildTargetType TEST = new JavaModuleBuildTargetType("java-test", true);
    public static final List<JavaModuleBuildTargetType> ALL_TYPES = List.of(PRODUCTION, TEST);
    private final boolean myTests;

    private JavaModuleBuildTargetType(String typeId, boolean tests) {
        super(typeId, true);
        this.myTests = tests;
    }

    @Override
    @NotNull
    public List<ModuleBuildTarget> computeAllTargets(@NotNull JpsModel model) {
        if (model == null) {
            JavaModuleBuildTargetType.$$$reportNull$$$0(0);
        }
        List modules = model.getProject().getModules();
        ArrayList<ModuleBuildTarget> targets = new ArrayList<ModuleBuildTarget>(modules.size());
        for (JpsModule module : modules) {
            targets.add(new ModuleBuildTarget(module, this));
        }
        ArrayList<ModuleBuildTarget> arrayList = targets;
        if (arrayList == null) {
            JavaModuleBuildTargetType.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public Loader createLoader(@NotNull JpsModel model) {
        if (model == null) {
            JavaModuleBuildTargetType.$$$reportNull$$$0(2);
        }
        return new Loader(model);
    }

    public boolean isTests() {
        return this.myTests;
    }

    public static JavaModuleBuildTargetType getInstance(boolean tests) {
        return tests ? TEST : PRODUCTION;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/builders/java/JavaModuleBuildTargetType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/builders/java/JavaModuleBuildTargetType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAllTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeAllTargets";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createLoader";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Loader
    extends BuildTargetLoader<ModuleBuildTarget> {
        private final Map<String, JpsModule> myModules = new HashMap<String, JpsModule>();

        Loader(JpsModel model) {
            for (JpsModule module : model.getProject().getModules()) {
                this.myModules.put(module.getName(), module);
            }
        }

        @Override
        @Nullable
        public ModuleBuildTarget createTarget(@NotNull String targetId) {
            JpsModule module;
            if (targetId == null) {
                Loader.$$$reportNull$$$0(0);
            }
            return (module = this.myModules.get(targetId)) != null ? new ModuleBuildTarget(module, JavaModuleBuildTargetType.this) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetId", "org/jetbrains/jps/builders/java/JavaModuleBuildTargetType$Loader", "createTarget"));
        }
    }
}

