/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class FilteringClassLoaderSpecSerializer
implements Serializer<FilteringClassLoader.Spec> {
    public void write(Encoder encoder, FilteringClassLoader.Spec spec) throws Exception {
        this.encodeStrings(encoder, spec.getClassNames());
        this.encodeStrings(encoder, spec.getDisallowedClassNames());
        this.encodeStrings(encoder, spec.getPackagePrefixes());
        this.encodeStrings(encoder, spec.getDisallowedPackagePrefixes());
        this.encodeStrings(encoder, spec.getPackageNames());
        this.encodeStrings(encoder, spec.getResourceNames());
        this.encodeStrings(encoder, spec.getResourcePrefixes());
    }

    private void encodeStrings(Encoder encoder, Set<String> strings) throws Exception {
        encoder.writeInt(strings.size());
        for (String string : strings) {
            encoder.writeString((CharSequence)string);
        }
    }

    public FilteringClassLoader.Spec read(Decoder decoder) throws Exception {
        List<String> classNames = this.decodeStrings(decoder);
        List<String> disallowedClassNames = this.decodeStrings(decoder);
        List<String> packagePrefixes = this.decodeStrings(decoder);
        List<String> disallowedPackagePrefixes = this.decodeStrings(decoder);
        List<String> packageNames = this.decodeStrings(decoder);
        List<String> resourceNames = this.decodeStrings(decoder);
        List<String> resourcePrefixes = this.decodeStrings(decoder);
        return new FilteringClassLoader.Spec(classNames, packageNames, packagePrefixes, resourcePrefixes, resourceNames, disallowedClassNames, disallowedPackagePrefixes);
    }

    private List<String> decodeStrings(Decoder decoder) throws Exception {
        ArrayList strings = Lists.newArrayList();
        int size = decoder.readInt();
        for (int i = 0; i < size; ++i) {
            strings.add(decoder.readString());
        }
        return strings;
    }
}

