/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.OutputFilesRepository;
import org.gradle.internal.execution.steps.AfterExecutionResult;
import org.gradle.internal.execution.steps.Context;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.snapshot.FileSystemSnapshot;

public class RecordOutputsStep<C extends Context, R extends AfterExecutionResult>
implements Step<C, R> {
    private final OutputFilesRepository outputFilesRepository;
    private final Step<? super C, ? extends R> delegate;

    public RecordOutputsStep(OutputFilesRepository outputFilesRepository, Step<? super C, ? extends R> delegate) {
        this.outputFilesRepository = outputFilesRepository;
        this.delegate = delegate;
    }

    @Override
    public R execute(UnitOfWork work, C context) {
        AfterExecutionResult result = (AfterExecutionResult)this.delegate.execute(work, context);
        result.getAfterExecutionState().ifPresent(afterExecutionState -> this.outputFilesRepository.recordOutputs((Iterable<? extends FileSystemSnapshot>)afterExecutionState.getOutputFilesProducedByWork().values()));
        return (R)result;
    }
}

