/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.i18n;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.DefaultNumberRule;
import net.sf.freecol.common.i18n.DualNumberRule;
import net.sf.freecol.common.i18n.Number;
import net.sf.freecol.common.i18n.NumberRules;
import net.sf.freecol.common.i18n.OtherNumberRule;
import net.sf.freecol.common.i18n.PluralNumberRule;
import net.sf.freecol.common.i18n.Rule;
import net.sf.freecol.common.i18n.ZeroOneNumberRule;
import net.sf.freecol.util.test.FreeColTestCase;

public class CLDRTest
extends FreeColTestCase {
    public void testRuleParsing() {
        Rule rule = new Rule("n mod 10 in 2..4 and n mod 100 not in 12..14");
        CLDRTest.assertTrue((boolean)rule.matches(2.0));
        CLDRTest.assertTrue((boolean)rule.matches(102.0));
        CLDRTest.assertTrue((boolean)rule.matches(103.0));
        CLDRTest.assertFalse((boolean)rule.matches(1.0));
        CLDRTest.assertFalse((boolean)rule.matches(5.0));
        CLDRTest.assertFalse((boolean)rule.matches(112.0));
        DefaultNumberRule arabic = new DefaultNumberRule();
        arabic.addRule(Number.Category.zero, "n is 0");
        arabic.addRule(Number.Category.one, "n is 1");
        arabic.addRule(Number.Category.two, "n is 2");
        arabic.addRule(Number.Category.few, "N Mod 100 in 3.. 10");
        arabic.addRule(Number.Category.many, "n MOD 100 in 11   ..99");
        CLDRTest.assertEquals((Object)((Object)Number.Category.zero), (Object)((Object)arabic.getCategory(0.0)));
        CLDRTest.assertEquals((Object)((Object)Number.Category.one), (Object)((Object)arabic.getCategory(1.0)));
        CLDRTest.assertEquals((Object)((Object)Number.Category.two), (Object)((Object)arabic.getCategory(2.0)));
        CLDRTest.assertEquals((Object)((Object)Number.Category.few), (Object)((Object)arabic.getCategory(3.0)));
        CLDRTest.assertEquals((Object)((Object)Number.Category.few), (Object)((Object)arabic.getCategory(7.0)));
        CLDRTest.assertEquals((Object)((Object)Number.Category.few), (Object)((Object)arabic.getCategory(10.0)));
        CLDRTest.assertEquals((Object)((Object)Number.Category.many), (Object)((Object)arabic.getCategory(11.0)));
        CLDRTest.assertEquals((Object)((Object)Number.Category.many), (Object)((Object)arabic.getCategory(99.0)));
        CLDRTest.assertEquals((Object)((Object)Number.Category.many), (Object)((Object)arabic.getCategory(2345.0)));
    }

    public void testPlurals() {
        File inputFile = new File("data/strings/plurals.xml");
        CLDRTest.assertTrue((boolean)inputFile.exists());
        try (InputStream in = Files.newInputStream(inputFile.toPath(), new OpenOption[0]);){
            NumberRules numberRules = new NumberRules(in);
        }
        catch (IOException | XMLStreamException ex) {
            CLDRTest.fail((String)ex.toString());
        }
        CLDRTest.assertNotNull((Object)NumberRules.getNumberForLanguage("az"));
        CLDRTest.assertTrue((boolean)(NumberRules.getNumberForLanguage("az") instanceof OtherNumberRule));
        CLDRTest.assertNotNull((Object)NumberRules.getNumberForLanguage("ko"));
        CLDRTest.assertTrue((boolean)(NumberRules.getNumberForLanguage("ko") instanceof OtherNumberRule));
        CLDRTest.assertNotNull((Object)NumberRules.getNumberForLanguage("th"));
        CLDRTest.assertTrue((boolean)(NumberRules.getNumberForLanguage("th") instanceof OtherNumberRule));
        CLDRTest.assertNotNull((Object)NumberRules.getNumberForLanguage("en"));
        CLDRTest.assertTrue((boolean)(NumberRules.getNumberForLanguage("en") instanceof PluralNumberRule));
        CLDRTest.assertNotNull((Object)NumberRules.getNumberForLanguage("it"));
        CLDRTest.assertTrue((boolean)(NumberRules.getNumberForLanguage("it") instanceof PluralNumberRule));
        CLDRTest.assertNotNull((Object)NumberRules.getNumberForLanguage("pt"));
        CLDRTest.assertTrue((boolean)(NumberRules.getNumberForLanguage("pt") instanceof PluralNumberRule));
        CLDRTest.assertNotNull((Object)NumberRules.getNumberForLanguage("ak"));
        CLDRTest.assertTrue((boolean)(NumberRules.getNumberForLanguage("ak") instanceof ZeroOneNumberRule));
        CLDRTest.assertNotNull((Object)NumberRules.getNumberForLanguage("hi"));
        CLDRTest.assertTrue((boolean)(NumberRules.getNumberForLanguage("hi") instanceof ZeroOneNumberRule));
        CLDRTest.assertNotNull((Object)NumberRules.getNumberForLanguage("wa"));
        CLDRTest.assertTrue((boolean)(NumberRules.getNumberForLanguage("wa") instanceof ZeroOneNumberRule));
        CLDRTest.assertNotNull((Object)NumberRules.getNumberForLanguage("ga"));
        CLDRTest.assertTrue((boolean)(NumberRules.getNumberForLanguage("ga") instanceof DualNumberRule));
        CLDRTest.assertNotNull((Object)NumberRules.getNumberForLanguage("smi"));
        CLDRTest.assertTrue((boolean)(NumberRules.getNumberForLanguage("smi") instanceof DualNumberRule));
        CLDRTest.assertNotNull((Object)NumberRules.getNumberForLanguage("sms"));
        CLDRTest.assertTrue((boolean)(NumberRules.getNumberForLanguage("sms") instanceof DualNumberRule));
    }
}

