'use strict';

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var MetricsAggregationBase = require('./metrics-aggregation-base');

/**
 * A multi-value metrics aggregation that computes stats over numeric values
 * extracted from the aggregated documents. These values can be extracted either
 * from specific numeric fields in the documents, or be generated by a provided
 * script.
 *
 * [Elasticsearch reference](https://www.elastic.co/guide/en/elasticsearch/reference/current/search-aggregations-metrics-extendedstats-aggregation.html)
 *
 * Aggregation that computes extra stats over numeric values extracted from
 * the aggregated documents.
 *
 * @example
 * const agg = esb.extendedStatsAggregation('grades_stats', 'grade');
 *
 * @example
 * // Compute the grade stats based on a script
 * const agg = esb.extendedStatsAggregation('grades_stats').script(
 *     esb.script('inline', "doc['grade'].value").lang('painless')
 * );
 *
 * @example
 * // Value script, apply grade correction
 * const agg = esb.extendedStatsAggregation('grades_stats', 'grade').script(
 *     esb.script('inline', '_value * params.correction')
 *         .lang('painless')
 *         .params({ correction: 1.2 })
 * );
 *
 * @example
 * // Missing value
 * const agg = esb.extendedStatsAggregation('grades_stats', 'grade').missing(0);
 *
 * @param {string} name The name which will be used to refer to this aggregation.
 * @param {string=} field The field to aggregate on
 *
 * @extends MetricsAggregationBase
 */

var ExtendedStatsAggregation = function (_MetricsAggregationBa) {
    (0, _inherits3.default)(ExtendedStatsAggregation, _MetricsAggregationBa);

    // eslint-disable-next-line require-jsdoc
    function ExtendedStatsAggregation(name, field) {
        (0, _classCallCheck3.default)(this, ExtendedStatsAggregation);
        return (0, _possibleConstructorReturn3.default)(this, (ExtendedStatsAggregation.__proto__ || Object.getPrototypeOf(ExtendedStatsAggregation)).call(this, name, 'extended_stats', field));
    }

    /**
     * Set sigma in the request for getting custom boundary.
     * sigma controls how many standard deviations +/- from the mean should be displayed
     *
     * @example
     * const agg = esb.extendedStatsAggregation('grades_stats', 'grade').sigma(3);
     *
     * @param {number} sigma sigma can be any non-negative double,
     * meaning you can request non-integer values such as 1.5.
     * A value of 0 is valid, but will simply return the average for both upper and lower bounds.
     * @returns {ExtendedStatsAggregation} returns `this` so that calls can be chained
     */


    (0, _createClass3.default)(ExtendedStatsAggregation, [{
        key: 'sigma',
        value: function sigma(_sigma) {
            this._aggsDef.sigma = _sigma;
            return this;
        }
    }]);
    return ExtendedStatsAggregation;
}(MetricsAggregationBase);

module.exports = ExtendedStatsAggregation;